/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.template.internal.ImportDetector;
import org.openrewrite.java.template.internal.JavacResolution;
import org.openrewrite.java.template.internal.TemplateCode;
import org.openrewrite.java.template.internal.UsedMethodDetector;
import org.openrewrite.java.template.processor.TypeAwareProcessor;

@SupportedAnnotationTypes(value={"com.google.errorprone.refaster.annotation.BeforeTemplate", "com.google.errorprone.refaster.annotation.AfterTemplate"})
public class RefasterTemplateProcessor
extends TypeAwareProcessor {
    static final String BEFORE_TEMPLATE = "com.google.errorprone.refaster.annotation.BeforeTemplate";
    static final String AFTER_TEMPLATE = "com.google.errorprone.refaster.annotation.AfterTemplate";
    static Set<String> UNSUPPORTED_ANNOTATIONS = Stream.of("com.google.errorprone.refaster.annotation.AllowCodeBetweenLines", "com.google.errorprone.refaster.annotation.Matches", "com.google.errorprone.refaster.annotation.MayOptionallyUse", "com.google.errorprone.refaster.annotation.NoAutoboxing", "com.google.errorprone.refaster.annotation.NotMatches", "com.google.errorprone.refaster.annotation.OfKind", "com.google.errorprone.refaster.annotation.Placeholder", "com.google.errorprone.refaster.annotation.Repeated").collect(Collectors.toSet());
    static ClassValue<java.util.List<String>> LST_TYPE_MAP = new ClassValue<java.util.List<String>>(){

        @Override
        protected java.util.List<String> computeValue(Class<?> type) {
            if (JCTree.JCUnary.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Unary");
            }
            if (JCTree.JCBinary.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Binary");
            }
            if (JCTree.JCMethodInvocation.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.MethodInvocation");
            }
            if (JCTree.JCFieldAccess.class.isAssignableFrom(type)) {
                return Arrays.asList("J.FieldAccess", "J.Identifier");
            }
            if (JCTree.JCConditional.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Ternary");
            }
            if (JCTree.JCNewClass.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.NewClass");
            }
            if (JCTree.JCExpression.class.isAssignableFrom(type)) {
                return Collections.singletonList("Expression");
            }
            if (JCTree.JCStatement.class.isAssignableFrom(type)) {
                return Collections.singletonList("Statement");
            }
            throw new IllegalArgumentException(type.toString());
        }
    };
    private final Map<String, Integer> printedMessages = new TreeMap<String, Integer>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit jcCompilationUnit = this.toUnit(element);
            if (jcCompilationUnit == null) continue;
            this.maybeGenerateTemplateSources(jcCompilationUnit);
        }
        return false;
    }

    void maybeGenerateTemplateSources(final JCTree.JCCompilationUnit cu) {
        final Context context = this.javacProcessingEnv.getContext();
        new TreeScanner(){
            final Map<TemplateDescriptor, Set<String>> imports = new HashMap<TemplateDescriptor, Set<String>>();
            final Map<TemplateDescriptor, Set<String>> staticImports = new HashMap<TemplateDescriptor, Set<String>>();
            final Map<String, String> recipes = new LinkedHashMap<String, String>();

            @Override
            public void visitClassDef(JCTree.JCClassDecl classDecl) {
                super.visitClassDef(classDecl);
                RuleDescriptor descriptor = RefasterTemplateProcessor.this.getRuleDescriptor(classDecl, context, cu);
                if (descriptor != null) {
                    TreeMaker treeMaker = TreeMaker.instance(context).forToplevel(cu);
                    java.util.List membersWithoutConstructor = classDecl.getMembers().stream().filter(m -> !(m instanceof JCTree.JCMethodDecl) || !((JCTree.JCMethodDecl)m).name.contentEquals("<init>")).collect(Collectors.toList());
                    JCTree.JCClassDecl copy = treeMaker.ClassDef(classDecl.mods, classDecl.name, classDecl.typarams, classDecl.extending, classDecl.implementing, List.from(membersWithoutConstructor));
                    String templateFqn = classDecl.sym.fullname.toString() + "Recipe";
                    String templateCode = copy.toString().trim();
                    for (TemplateDescriptor templateDescriptor : descriptor.beforeTemplates) {
                        for (Symbol anImport : ImportDetector.imports(templateDescriptor.method)) {
                            if (anImport instanceof Symbol.ClassSymbol) {
                                this.imports.computeIfAbsent(templateDescriptor, k -> new TreeSet()).add(anImport.getQualifiedName().toString().replace('$', '.'));
                                continue;
                            }
                            if (anImport instanceof Symbol.VarSymbol || anImport instanceof Symbol.MethodSymbol) {
                                this.staticImports.computeIfAbsent(templateDescriptor, k -> new TreeSet()).add(anImport.owner.getQualifiedName().toString().replace('$', '.') + '.' + anImport.flatName().toString());
                                continue;
                            }
                            throw new AssertionError(anImport.getClass());
                        }
                    }
                    for (Symbol symbol : ImportDetector.imports(descriptor.afterTemplate.method)) {
                        if (symbol instanceof Symbol.ClassSymbol) {
                            this.imports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.getQualifiedName().toString().replace('$', '.'));
                            continue;
                        }
                        if (symbol instanceof Symbol.VarSymbol || symbol instanceof Symbol.MethodSymbol) {
                            this.staticImports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.owner.getQualifiedName().toString().replace('$', '.') + '.' + symbol.flatName().toString());
                            continue;
                        }
                        throw new AssertionError(symbol.getClass());
                    }
                    for (Set set : this.imports.values()) {
                        set.removeIf(i -> {
                            int endIndex = i.lastIndexOf(46);
                            return endIndex < 0 || "java.lang".equals(i.substring(0, endIndex)) || "com.google.errorprone.refaster".equals(i.substring(0, endIndex));
                        });
                    }
                    for (Set set : this.staticImports.values()) {
                        set.removeIf(i -> i.startsWith("java.lang.") || i.startsWith("com.google.errorprone.refaster."));
                    }
                    LinkedHashMap<String, TemplateDescriptor> beforeTemplates = new LinkedHashMap<String, TemplateDescriptor>();
                    for (TemplateDescriptor templ : descriptor.beforeTemplates) {
                        String name = templ.method.name.toString();
                        if (beforeTemplates.containsKey(name)) {
                            String base = name;
                            int i2 = 0;
                            while (beforeTemplates.containsKey(name = base + i2)) {
                                ++i2;
                            }
                        }
                        beforeTemplates.put(name, templ);
                    }
                    String string = descriptor.afterTemplate.method.name.toString();
                    StringBuilder recipe = new StringBuilder();
                    Symbol.PackageSymbol pkg = classDecl.sym.packge();
                    String typeName = classDecl.sym.fullname.toString();
                    String refasterRuleClassName = pkg.isUnnamed() ? typeName : typeName.substring(pkg.fullname.length() + 1);
                    recipe.append("/**\n * OpenRewrite recipe created for Refaster template {@code ").append(refasterRuleClassName).append("}.\n */\n");
                    String recipeName = templateFqn.substring(templateFqn.lastIndexOf(46) + 1);
                    recipe.append("@SuppressWarnings(\"all\")\n");
                    recipe.append("@NonNullApi\n");
                    recipe.append(descriptor.classDecl.sym.outermostClass() == descriptor.classDecl.sym ? "public class " : "public static class ").append(recipeName).append(" extends Recipe {\n\n");
                    recipe.append("    /**\n");
                    recipe.append("     * Instantiates a new instance.\n");
                    recipe.append("     */\n");
                    recipe.append("    public ").append(recipeName).append("() {}\n\n");
                    recipe.append(this.recipeDescriptor(classDecl, "Refaster template `" + refasterRuleClassName + '`', "Recipe created for the following Refaster template:\\n```java\\n" + RefasterTemplateProcessor.this.escape(templateCode) + "\\n```\\n."));
                    recipe.append("    @Override\n");
                    recipe.append("    public TreeVisitor<?, ExecutionContext> getVisitor() {\n");
                    recipe.append("        JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {\n");
                    for (Map.Entry entry : beforeTemplates.entrySet()) {
                        int arity = ((TemplateDescriptor)entry.getValue()).getArity();
                        for (int i3 = 0; i3 < arity; ++i3) {
                            recipe.append("            final JavaTemplate ").append((String)entry.getKey()).append(arity > 1 ? "$" + i3 : "").append(" = ").append(((TemplateDescriptor)entry.getValue()).toJavaTemplateBuilder(i3)).append("\n                    .build();\n");
                        }
                    }
                    recipe.append("            final JavaTemplate ").append(string).append(" = ").append(descriptor.afterTemplate.toJavaTemplateBuilder()).append("\n                    .build();\n");
                    recipe.append("\n");
                    java.util.List<String> lstTypes = LST_TYPE_MAP.get(RefasterTemplateProcessor.this.getType(descriptor.beforeTemplates.get((int)0).method));
                    for (String lstType : lstTypes) {
                        String methodSuffix = lstType.startsWith("J.") ? lstType.substring(2) : lstType;
                        recipe.append("            @Override\n");
                        recipe.append("            public J visit").append(methodSuffix).append("(").append(lstType).append(" elem, ExecutionContext ctx) {\n");
                        if (lstType.equals("Statement")) {
                            recipe.append("                if (elem instanceof J.Block) {;\n");
                            recipe.append("                    // FIXME workaround\n");
                            recipe.append("                    return elem;\n");
                            recipe.append("                }\n");
                        }
                        recipe.append("                JavaTemplate.Matcher matcher;\n");
                        for (Map.Entry entry : beforeTemplates.entrySet()) {
                            int arity = ((TemplateDescriptor)entry.getValue()).getArity();
                            for (int i4 = 0; i4 < arity; ++i4) {
                                recipe.append("                if ((matcher = ").append((String)entry.getKey()).append(arity > 1 ? "$" + i4 : "").append(".matcher(getCursor())).find()").append(") {\n");
                                java.util.List jcVariableDecls = ((TemplateDescriptor)entry.getValue()).method.getParameters();
                                for (int j = 0; j < ((List)jcVariableDecls).size(); ++j) {
                                    JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)((List)jcVariableDecls).get(j);
                                    java.util.List annotations = param.getModifiers().getAnnotations();
                                    for (JCTree.JCAnnotation jcAnnotation : annotations) {
                                        String matcher;
                                        String annotationType = jcAnnotation.attribute.type.tsym.getQualifiedName().toString();
                                        if (annotationType.equals("org.openrewrite.java.template.NotMatches")) {
                                            matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                                            recipe.append("                    if (new ").append(matcher).append("().matches((Expression) matcher.parameter(").append(j).append("))) {\n");
                                            recipe.append("                        return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                                            recipe.append("                    }\n");
                                            continue;
                                        }
                                        if (!annotationType.equals("org.openrewrite.java.template.Matches")) continue;
                                        matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                                        recipe.append("                    if (!new ").append(matcher).append("().matches((Expression) matcher.parameter(").append(j).append("))) {\n");
                                        recipe.append("                        return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                                        recipe.append("                    }\n");
                                    }
                                }
                                this.maybeRemoveImports(this.imports, recipe, (TemplateDescriptor)entry.getValue(), i4, descriptor.afterTemplate);
                                this.maybeRemoveStaticImports(this.staticImports, recipe, (TemplateDescriptor)entry.getValue(), i4, descriptor.afterTemplate);
                                ArrayList<String> embedOptions = new ArrayList<String>();
                                JCTree.JCExpression afterReturn = RefasterTemplateProcessor.this.getReturnExpression(descriptor.afterTemplate.method);
                                if (afterReturn instanceof JCTree.JCParens || afterReturn instanceof JCTree.JCUnary && ((JCTree.JCUnary)afterReturn).getExpression() instanceof JCTree.JCParens) {
                                    embedOptions.add("REMOVE_PARENS");
                                }
                                embedOptions.add("SHORTEN_NAMES");
                                if (this.simplifyBooleans(descriptor.afterTemplate.method)) {
                                    embedOptions.add("SIMPLIFY_BOOLEANS");
                                }
                                recipe.append("                    return embed(\n");
                                recipe.append("                            ").append(string).append(".apply(getCursor(), elem.getCoordinates().replace()");
                                String parameters = RefasterTemplateProcessor.this.parameters((TemplateDescriptor)entry.getValue(), descriptor);
                                if (!parameters.isEmpty()) {
                                    recipe.append(", ").append(parameters);
                                }
                                recipe.append("),\n");
                                recipe.append("                            getCursor(),\n");
                                recipe.append("                            ctx,\n");
                                recipe.append("                            ").append(String.join((CharSequence)", ", embedOptions)).append("\n");
                                recipe.append("                    );\n");
                                recipe.append("                }\n");
                            }
                        }
                        recipe.append("                return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                        recipe.append("            }\n");
                        recipe.append("\n");
                    }
                    recipe.append("        };\n");
                    String string2 = this.generatePreconditions(descriptor.beforeTemplates, 16);
                    if (string2 == null) {
                        recipe.append("        return javaVisitor;\n");
                    } else {
                        recipe.append("        return Preconditions.check(\n");
                        recipe.append("                ").append(string2).append(",\n");
                        recipe.append("                javaVisitor\n");
                        recipe.append("        );\n");
                    }
                    recipe.append("    }\n");
                    recipe.append("}\n");
                    this.recipes.put(recipeName, recipe.toString());
                }
                if (classDecl.sym != null && classDecl.sym.getNestingKind() == NestingKind.TOP_LEVEL && !this.recipes.isEmpty()) {
                    boolean outerClassRequired = descriptor == null;
                    try {
                        Symbol.PackageSymbol pkg = classDecl.sym.packge();
                        String inputOuterFQN = outerClassRequired ? classDecl.sym.fullname.toString() : descriptor.classDecl.sym.fullname.toString();
                        String className = inputOuterFQN + (outerClassRequired ? "Recipes" : "Recipe");
                        JavaFileObject builderFile = RefasterTemplateProcessor.this.processingEnv.getFiler().createSourceFile(className, new Element[0]);
                        Throwable throwable = null;
                        try (BufferedWriter out = new BufferedWriter(builderFile.openWriter());){
                            if (!pkg.isUnnamed()) {
                                out.write("package " + pkg.fullname + ";\n");
                                out.write("\n");
                            }
                            out.write("import org.openrewrite.ExecutionContext;\n");
                            out.write("import org.openrewrite.Preconditions;\n");
                            out.write("import org.openrewrite.Recipe;\n");
                            out.write("import org.openrewrite.TreeVisitor;\n");
                            out.write("import org.openrewrite.internal.lang.NonNullApi;\n");
                            out.write("import org.openrewrite.java.JavaParser;\n");
                            out.write("import org.openrewrite.java.JavaTemplate;\n");
                            out.write("import org.openrewrite.java.JavaVisitor;\n");
                            out.write("import org.openrewrite.java.search.*;\n");
                            out.write("import org.openrewrite.java.template.Primitive;\n");
                            out.write("import org.openrewrite.java.template.function.*;\n");
                            out.write("import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;\n");
                            out.write("import org.openrewrite.java.tree.*;\n");
                            out.write("\n");
                            out.write("import java.util.*;\n");
                            out.write("\n");
                            out.write("import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;\n");
                            out.write("\n");
                            if (outerClassRequired) {
                                out.write("/**\n * OpenRewrite recipes created for Refaster template {@code " + inputOuterFQN + "}.\n */\n");
                                String outerClassName = className.substring(className.lastIndexOf(46) + 1);
                                out.write("@SuppressWarnings(\"all\")\n");
                                out.write("public class " + outerClassName + " extends Recipe {\n");
                                out.write("    /**\n");
                                out.write("     * Instantiates a new instance.\n");
                                out.write("     */\n");
                                out.write("    public " + outerClassName + "() {}\n\n");
                                out.write(this.recipeDescriptor(classDecl, String.format("`%s` Refaster recipes", inputOuterFQN.substring(inputOuterFQN.lastIndexOf(46) + 1)), String.format("Refaster template recipes for `%s`.", inputOuterFQN)));
                                String recipesAsList = this.recipes.keySet().stream().map(r -> "                new " + r.substring(r.lastIndexOf(46) + 1) + "()").collect(Collectors.joining(",\n"));
                                out.write("    @Override\n    public List<Recipe> getRecipeList() {\n        return Arrays.asList(\n" + recipesAsList + '\n' + "        );\n    }\n\n");
                                for (String r2 : this.recipes.values()) {
                                    out.write(r2.replaceAll("(?m)^(.+)$", "    $1"));
                                    ((Writer)out).write(10);
                                }
                                out.write("}\n");
                            } else {
                                for (String r3 : this.recipes.values()) {
                                    out.write(r3);
                                    ((Writer)out).write(10);
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            private boolean simplifyBooleans(JCTree.JCMethodDecl template) {
                if (template.getReturnType().type.getTag() == TypeTag.BOOLEAN) {
                    return true;
                }
                return new TreeScanner(){
                    boolean found;

                    boolean find(JCTree tree) {
                        this.scan(tree);
                        return this.found;
                    }

                    @Override
                    public void visitBinary(JCTree.JCBinary jcBinary) {
                        this.found |= jcBinary.type.getTag() == TypeTag.BOOLEAN;
                        super.visitBinary(jcBinary);
                    }

                    @Override
                    public void visitUnary(JCTree.JCUnary jcUnary) {
                        this.found |= jcUnary.type.getTag() == TypeTag.BOOLEAN;
                        super.visitUnary(jcUnary);
                    }
                }.find(template.getBody());
            }

            private String recipeDescriptor(JCTree.JCClassDecl classDecl, String defaultDisplayName, String defaultDescription) {
                String displayName = defaultDisplayName;
                String description = defaultDescription;
                LinkedHashSet<String> tags = new LinkedHashSet<String>();
                Tokens.Comment comment = cu.docComments.getComment(classDecl);
                if (comment != null && comment.getText() != null && !comment.getText().isEmpty()) {
                    String commentText = comment.getText().replaceAll("\\{@\\S+\\s+(.*?)}", "`$1`").replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\t", "\\t").replace("\f", "\\f").replace("\r", "\\r");
                    String[] lines = commentText.split("\\.\\R+", 2);
                    displayName = lines[0].trim().replace("\n", "");
                    if (displayName.endsWith(".")) {
                        displayName = displayName.substring(0, displayName.length() - 1);
                    }
                    if (lines.length > 1 && !lines[1].trim().isEmpty() && !(description = lines[1].trim().replace("\n", "\\n")).endsWith(".")) {
                        description = description + '.';
                    }
                }
                for (JCTree.JCAnnotation annotation : classDecl.getModifiers().getAnnotations()) {
                    String annotationFqn = annotation.type.toString();
                    if ("org.openrewrite.java.template.RecipeDescriptor".equals(annotationFqn)) {
                        for (JCTree.JCExpression argExpr : annotation.getArguments()) {
                            JCTree.JCAssign arg = (JCTree.JCAssign)argExpr;
                            switch (arg.lhs.toString()) {
                                case "name": {
                                    displayName = RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString());
                                    break;
                                }
                                case "description": {
                                    description = RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString());
                                    break;
                                }
                                case "tags": {
                                    if (arg.rhs instanceof JCTree.JCLiteral) {
                                        tags.add(RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString()));
                                        break;
                                    }
                                    if (!(arg.rhs instanceof JCTree.JCNewArray)) break;
                                    for (JCTree.JCExpression e : ((JCTree.JCNewArray)arg.rhs).elems) {
                                        tags.add(RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)e).getValue().toString()));
                                    }
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    if (!"tech.picnic.errorprone.refaster.annotation.OnlineDocumentation".equals(annotationFqn) || !((List)annotation.getArguments()).isEmpty()) continue;
                    description = description + " [Source](https://error-prone.picnic.tech/refasterrules/" + classDecl.name.toString() + ").";
                }
                String recipeDescriptor = "    @Override\n    public String getDisplayName() {\n        return \"" + displayName + "\";\n    }\n\n    @Override\n    public String getDescription() {\n        return \"" + description + "\";\n    }\n\n";
                if (tags.size() == 1) {
                    recipeDescriptor = recipeDescriptor + "    @Override\n    public Set<String> getTags() {\n        return Collections.singleton(\"" + String.join((CharSequence)"\", \"", tags) + "\");\n    }\n\n";
                } else if (tags.size() > 1) {
                    recipeDescriptor = recipeDescriptor + "    @Override\n    public Set<String> getTags() {\n        return new HashSet<>(Arrays.asList(\"" + String.join((CharSequence)"\", \"", tags) + "\"));\n    }\n\n";
                }
                return recipeDescriptor;
            }

            private void maybeRemoveImports(Map<TemplateDescriptor, Set<String>> importsByTemplate, StringBuilder recipe, TemplateDescriptor beforeTemplate, int pos, TemplateDescriptor afterTemplate) {
                Set beforeImports = beforeTemplate.usedTypes(pos).stream().map(sym -> sym.fullname.toString()).collect(Collectors.toCollection(LinkedHashSet::new));
                beforeImports.removeAll(this.getImportsAsStrings(importsByTemplate, afterTemplate));
                beforeImports.removeIf(i -> i.startsWith("java.lang.") || i.startsWith("com.google.errorprone.refaster."));
                beforeImports.forEach(anImport -> recipe.append("                    maybeRemoveImport(\"").append((String)anImport).append("\");\n"));
            }

            private void maybeRemoveStaticImports(Map<TemplateDescriptor, Set<String>> importsByTemplate, StringBuilder recipe, TemplateDescriptor beforeTemplate, int pos, TemplateDescriptor afterTemplate) {
                Set beforeImports = beforeTemplate.usedMembers(pos).stream().map(symbol -> symbol.owner.getQualifiedName() + "." + symbol.name).collect(Collectors.toCollection(LinkedHashSet::new));
                beforeImports.removeAll(this.getImportsAsStrings(importsByTemplate, afterTemplate));
                beforeImports.removeIf(i -> i.startsWith("java.lang.") || i.startsWith("com.google.errorprone.refaster."));
                beforeImports.forEach(anImport -> recipe.append("                    maybeRemoveImport(\"").append((String)anImport).append("\");\n"));
            }

            private Set<String> getImportsAsStrings(Map<TemplateDescriptor, Set<String>> importsByTemplate, TemplateDescriptor templateMethod) {
                return importsByTemplate.entrySet().stream().filter(e -> templateMethod == e.getKey()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
            }

            @Nullable
            private String generatePreconditions(java.util.List<TemplateDescriptor> beforeTemplates, int indent) {
                LinkedHashMap preconditions = new LinkedHashMap();
                for (TemplateDescriptor templateDescriptor : beforeTemplates) {
                    int arity = templateDescriptor.getArity();
                    for (int i = 0; i < arity; ++i) {
                        LinkedHashSet<String> usesVisitors = new LinkedHashSet<String>();
                        for (Symbol.ClassSymbol usedType : templateDescriptor.usedTypes(i)) {
                            String name = usedType.getQualifiedName().toString().replace('$', '.');
                            if (name.startsWith("java.lang.") || name.startsWith("com.google.errorprone.refaster.")) continue;
                            usesVisitors.add("new UsesType<>(\"" + name + "\", true)");
                        }
                        for (Symbol.MethodSymbol method : templateDescriptor.usedMethods(i)) {
                            if (method.owner.getQualifiedName().toString().startsWith("com.google.errorprone.refaster.")) continue;
                            String methodName = method.name.toString();
                            methodName = methodName.equals("<init>") ? "<constructor>" : methodName;
                            usesVisitors.add("new UsesMethod<>(\"" + method.owner.getQualifiedName().toString() + ' ' + methodName + "(..)\")");
                        }
                        preconditions.put(templateDescriptor.method.name.toString() + (arity == 1 ? "" : "$" + i), usesVisitors);
                    }
                }
                if (preconditions.size() == 1) {
                    return this.joinPreconditions((Collection)preconditions.values().iterator().next(), "and", indent + 4);
                }
                if (preconditions.size() > 1) {
                    LinkedHashSet<String> common = new LinkedHashSet<String>();
                    for (String dep2 : (Set)preconditions.values().iterator().next()) {
                        if (!preconditions.values().stream().allMatch(v -> v.contains(dep2))) continue;
                        common.add(dep2);
                    }
                    common.forEach(dep -> preconditions.values().forEach(v -> v.remove(dep)));
                    preconditions.values().removeIf(Collection::isEmpty);
                    if (common.isEmpty()) {
                        return this.joinPreconditions(preconditions.values().stream().map(v -> this.joinPreconditions((Collection<String>)v, "and", indent + 4)).collect(Collectors.toList()), "or", indent + 4);
                    }
                    if (!preconditions.isEmpty()) {
                        String string = this.joinPreconditions(preconditions.values().stream().map(v -> this.joinPreconditions((Collection<String>)v, "and", indent + 12)).collect(Collectors.toList()), "or", indent + 8);
                        common.add(string);
                    }
                    return this.joinPreconditions(common, "and", indent + 4);
                }
                return null;
            }

            private String joinPreconditions(Collection<String> preconditions, String op, int indent) {
                if (preconditions.isEmpty()) {
                    return null;
                }
                if (preconditions.size() == 1) {
                    return preconditions.iterator().next();
                }
                char[] indentChars = new char[indent];
                Arrays.fill(indentChars, ' ');
                String indentStr = new String(indentChars);
                return "Preconditions." + op + "(\n" + indentStr + String.join((CharSequence)(",\n" + indentStr), preconditions) + "\n" + indentStr.substring(0, indent - 4) + ')';
            }
        }.scan(cu);
    }

    private String escape(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\\R", "\\\\n");
    }

    private String parameters(TemplateDescriptor before, RuleDescriptor descriptor) {
        final AtomicInteger beforeParameterOccurrence = new AtomicInteger();
        final HashMap beforeParamOrder = new HashMap();
        final ArrayList afterParams = new ArrayList();
        final HashSet seenParams = new HashSet();
        new TreeScanner(){

            @Override
            public void scan(JCTree jcTree) {
                if (jcTree instanceof JCTree.JCIdent) {
                    JCTree.JCIdent jcIdent = (JCTree.JCIdent)jcTree;
                    if (jcIdent.sym instanceof Symbol.VarSymbol && jcIdent.sym.owner instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)jcIdent.sym.owner).params.contains(jcIdent.sym) && seenParams.add(jcIdent.sym)) {
                        beforeParamOrder.put(((Symbol.MethodSymbol)jcIdent.sym.owner).params.indexOf(jcIdent.sym), beforeParameterOccurrence.getAndIncrement());
                    }
                }
                super.scan(jcTree);
            }
        }.scan(before.method.body);
        new TreeScanner(){

            @Override
            public void scan(JCTree jcTree) {
                if (jcTree instanceof JCTree.JCIdent) {
                    JCTree.JCIdent jcIdent = (JCTree.JCIdent)jcTree;
                    if (jcIdent.sym instanceof Symbol.VarSymbol && jcIdent.sym.owner instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)jcIdent.sym.owner).params.contains(jcIdent.sym) && seenParams.add(jcIdent.sym)) {
                        afterParams.add(beforeParamOrder.get(((Symbol.MethodSymbol)jcIdent.sym.owner).params.indexOf(jcIdent.sym)));
                    }
                }
                super.scan(jcTree);
            }
        }.scan(descriptor.afterTemplate.method.body);
        StringJoiner joiner = new StringJoiner(", ");
        for (Integer param : afterParams) {
            joiner.add("matcher.parameter(" + param + ")");
        }
        return joiner.toString();
    }

    private Class<? extends JCTree> getType(JCTree.JCMethodDecl method) {
        JCTree.JCExpression returnExpression = this.getReturnExpression(method);
        return returnExpression != null ? returnExpression.getClass() : ((JCTree.JCStatement)((List)method.getBody().getStatements()).last()).getClass();
    }

    @Nullable
    private JCTree.JCExpression getReturnExpression(JCTree.JCMethodDecl method) {
        JCTree.JCStatement statement = (JCTree.JCStatement)((List)method.getBody().getStatements()).last();
        if (statement instanceof JCTree.JCReturn) {
            return ((JCTree.JCReturn)statement).expr;
        }
        if (statement instanceof JCTree.JCExpressionStatement) {
            return ((JCTree.JCExpressionStatement)statement).expr;
        }
        return null;
    }

    @Nullable
    private RuleDescriptor getRuleDescriptor(JCTree.JCClassDecl tree, Context context, JCTree.JCCompilationUnit cu) {
        RuleDescriptor result = new RuleDescriptor(tree, cu, context);
        for (JCTree member : tree.getMembers()) {
            if (!(member instanceof JCTree.JCMethodDecl)) continue;
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)member;
            java.util.List<JCTree.JCAnnotation> annotations = RefasterTemplateProcessor.getTemplateAnnotations(method, BEFORE_TEMPLATE::equals);
            if (!annotations.isEmpty()) {
                result.beforeTemplate(method);
            }
            if ((annotations = RefasterTemplateProcessor.getTemplateAnnotations(method, AFTER_TEMPLATE::equals)).isEmpty()) continue;
            result.afterTemplate(method);
        }
        return result.validate();
    }

    private void printNoteOnce(String message, Symbol.ClassSymbol symbol) {
        if (this.printedMessages.compute(message, (k, v) -> v == null ? 1 : v + 1) == 1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message, symbol);
        }
    }

    private static java.util.List<JCTree.JCAnnotation> getTemplateAnnotations(MethodTree method, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : method.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCAnnotation)annotationTree).attribute != null && ((JCTree.JCAnnotation)annotationTree).attribute.type instanceof Type.ClassType && ((JCTree.JCAnnotation)annotationTree).attribute.type.tsym != null && typePredicate.test(((JCTree.JCAnnotation)annotationTree).attribute.type.tsym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }

    private static java.util.List<JCTree.JCAnnotation> getTemplateAnnotations(VariableTree parameter, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : parameter.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }

    private static String escapeJava(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\n", "\\n").replace("\t", "\\t").replace("\f", "\\f").replace("\r", "\\r");
    }

    class TemplateDescriptor {
        JCTree.JCMethodDecl method;
        private final JCTree.JCClassDecl classDecl;
        private final JCTree.JCCompilationUnit cu;
        private final Context context;

        public TemplateDescriptor(JCTree.JCMethodDecl method, JCTree.JCClassDecl classDecl, JCTree.JCCompilationUnit cu, Context context) {
            this.classDecl = classDecl;
            this.method = method;
            this.cu = cu;
            this.context = context;
        }

        public int getArity() {
            final AtomicReference anyOfCall = new AtomicReference();
            new TreeScanner(){

                @Override
                public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                    if (TemplateDescriptor.this.isAnyOfCall(jcMethodInvocation)) {
                        anyOfCall.set(jcMethodInvocation);
                        return;
                    }
                    super.visitApply(jcMethodInvocation);
                }
            }.scan(this.method);
            return Optional.ofNullable(anyOfCall.get()).map(call -> call.args.size()).orElse(1);
        }

        private boolean isAnyOfCall(JCTree.JCMethodInvocation call) {
            JCTree.JCExpression meth = call.meth;
            if (meth instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)meth;
                return fieldAccess.name.toString().equals("anyOf") && ((JCTree.JCIdent)fieldAccess.selected).name.toString().equals("Refaster");
            }
            return false;
        }

        private String toJavaTemplateBuilder() {
            JCTree tree = (JCTree)((List)this.method.getBody().getStatements()).get(0);
            if (tree instanceof JCTree.JCReturn) {
                tree = ((JCTree.JCReturn)tree).getExpression();
            }
            String javaTemplateBuilder = TemplateCode.process(tree, this.method.getParameters(), this.method.restype.type instanceof Type.JCVoidType, true);
            return TemplateCode.indent(javaTemplateBuilder, 16);
        }

        private String toJavaTemplateBuilder(final int pos) {
            if (this.getArity() == 1) {
                assert (pos == 0);
                return this.toJavaTemplateBuilder();
            }
            JCTree tree = (JCTree)((List)this.method.getBody().getStatements()).get(0);
            if (tree instanceof JCTree.JCReturn) {
                tree = ((JCTree.JCReturn)tree).getExpression();
            }
            final AtomicReference original = new AtomicReference();
            new TreeScanner(){

                @Override
                public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                    if (TemplateDescriptor.this.isAnyOfCall(jcMethodInvocation)) {
                        original.set(jcMethodInvocation.args.get(pos));
                        return;
                    }
                    super.visitApply(jcMethodInvocation);
                }
            }.scan(tree);
            TreeCopier copier = new TreeCopier(TreeMaker.instance(this.context).forToplevel(this.cu));
            JCTree copied = copier.copy(tree);
            JCTree translated = new TreeTranslator(){

                @Override
                public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                    if (TemplateDescriptor.this.isAnyOfCall(jcMethodInvocation)) {
                        this.result = (JCTree)original.get();
                        return;
                    }
                    super.visitApply(jcMethodInvocation);
                }
            }.translate(copied);
            String javaTemplateBuilder = TemplateCode.process(translated, this.method.getParameters(), this.method.restype.type instanceof Type.JCVoidType, true);
            return TemplateCode.indent(javaTemplateBuilder, 16);
        }

        boolean validate() {
            if (this.method.typarams != null && !this.method.typarams.isEmpty()) {
                RefasterTemplateProcessor.this.printNoteOnce("Generic type parameters are currently not supported", this.classDecl.sym);
                return false;
            }
            Iterator<Object> iterator = RefasterTemplateProcessor.getTemplateAnnotations(this.method, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains).iterator();
            if (iterator.hasNext()) {
                JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)iterator.next();
                RefasterTemplateProcessor.this.printNoteOnce("@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
                return false;
            }
            for (JCTree.JCVariableDecl parameter : this.method.getParameters()) {
                Iterator iterator2 = RefasterTemplateProcessor.getTemplateAnnotations(parameter, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains).iterator();
                if (iterator2.hasNext()) {
                    JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)iterator2.next();
                    RefasterTemplateProcessor.this.printNoteOnce("@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
                    return false;
                }
                if (!(parameter.vartype.type instanceof Type.TypeVar)) continue;
                RefasterTemplateProcessor.this.printNoteOnce("Generic type parameters are currently not supported", this.classDecl.sym);
                return false;
            }
            if (this.method.restype.type instanceof Type.TypeVar) {
                RefasterTemplateProcessor.this.printNoteOnce("Generic type parameters are currently not supported", this.classDecl.sym);
                return false;
            }
            if (this.method.body.stats.get(0) instanceof JCTree.JCIf) {
                RefasterTemplateProcessor.this.printNoteOnce("If statements are currently not supported", this.classDecl.sym);
                return false;
            }
            if (this.method.body.stats.get(0) instanceof JCTree.JCReturn) {
                JCTree.JCExpression expr = ((JCTree.JCReturn)this.method.body.stats.get((int)0)).expr;
                if (expr instanceof JCTree.JCLambda) {
                    RefasterTemplateProcessor.this.printNoteOnce("Lambdas are currently not supported", this.classDecl.sym);
                    return false;
                }
                if (expr instanceof JCTree.JCMemberReference) {
                    RefasterTemplateProcessor.this.printNoteOnce("Method references are currently not supported", this.classDecl.sym);
                    return false;
                }
            }
            return new TreeScanner(){
                boolean valid = true;
                int anyOfCount = 0;

                boolean validate(JCTree tree) {
                    this.scan(tree);
                    return this.valid;
                }

                @Override
                public void visitSelect(JCTree.JCFieldAccess jcFieldAccess) {
                    if (jcFieldAccess.selected.type.tsym.toString().equals("com.google.errorprone.refaster.Refaster") && jcFieldAccess.name.toString().equals("anyOf")) {
                        if (++this.anyOfCount > 1) {
                            RefasterTemplateProcessor.this.printNoteOnce("Refaster.anyOf() can only be used once per template", ((TemplateDescriptor)TemplateDescriptor.this).classDecl.sym);
                            this.valid = false;
                        }
                        return;
                    }
                    super.visitSelect(jcFieldAccess);
                }

                @Override
                public void visitIdent(JCTree.JCIdent jcIdent) {
                    if (this.valid && jcIdent.sym != null && jcIdent.sym.packge().getQualifiedName().contentEquals("com.google.errorprone.refaster")) {
                        RefasterTemplateProcessor.this.printNoteOnce(jcIdent.type.tsym.getQualifiedName() + " is currently not supported", ((TemplateDescriptor)TemplateDescriptor.this).classDecl.sym);
                        this.valid = false;
                    }
                }
            }.validate(this.method.getBody());
        }

        private boolean resolve() {
            this.method = this.resolve(this.method);
            return this.method != null;
        }

        @Nullable
        private JCTree.JCMethodDecl resolve(JCTree.JCMethodDecl method) {
            JavacResolution res = new JavacResolution(this.context);
            try {
                this.classDecl.defs = this.classDecl.defs.prepend(method);
                JCTree.JCMethodDecl resolvedMethod = (JCTree.JCMethodDecl)res.resolveAll(this.context, this.cu, Collections.singletonList(method)).get(method);
                this.classDecl.defs = this.classDecl.defs.tail;
                resolvedMethod.params = method.params;
                method = resolvedMethod;
                return method;
            }
            catch (Throwable t) {
                RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Had trouble type attributing the template method: " + method.name);
                return null;
            }
        }

        public java.util.List<Symbol.ClassSymbol> usedTypes(final int i) {
            java.util.List<Symbol> imports;
            if (this.getArity() == 1) {
                imports = ImportDetector.imports(this.method);
            } else {
                final HashSet skip = new HashSet();
                new TreeScanner(){

                    @Override
                    public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                        if (TemplateDescriptor.this.isAnyOfCall(jcMethodInvocation)) {
                            for (int j = 0; j < jcMethodInvocation.args.size(); ++j) {
                                if (j == i) continue;
                                skip.add(jcMethodInvocation.args.get(j));
                            }
                            return;
                        }
                        super.visitApply(jcMethodInvocation);
                    }
                }.scan(this.method);
                imports = ImportDetector.imports(this.method, t -> !skip.contains(t));
            }
            return imports.stream().filter(Symbol.ClassSymbol.class::isInstance).map(Symbol.ClassSymbol.class::cast).collect(Collectors.toList());
        }

        public java.util.List<Symbol> usedMembers(final int i) {
            java.util.List<Symbol> imports;
            if (this.getArity() == 1) {
                imports = ImportDetector.imports(this.method);
            } else {
                final HashSet skip = new HashSet();
                new TreeScanner(){

                    @Override
                    public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                        if (TemplateDescriptor.this.isAnyOfCall(jcMethodInvocation)) {
                            for (int j = 0; j < jcMethodInvocation.args.size(); ++j) {
                                if (j == i) continue;
                                skip.add(jcMethodInvocation.args.get(j));
                            }
                            return;
                        }
                        super.visitApply(jcMethodInvocation);
                    }
                }.scan(this.method);
                imports = ImportDetector.imports(this.method, t -> !skip.contains(t));
            }
            return imports.stream().filter(sym -> sym instanceof Symbol.VarSymbol || sym instanceof Symbol.MethodSymbol).collect(Collectors.toList());
        }

        public java.util.List<Symbol.MethodSymbol> usedMethods(final int i) {
            if (this.getArity() == 1) {
                return UsedMethodDetector.usedMethods(this.method);
            }
            final HashSet skip = new HashSet();
            new TreeScanner(){

                @Override
                public void visitApply(JCTree.JCMethodInvocation jcMethodInvocation) {
                    if (TemplateDescriptor.this.isAnyOfCall(jcMethodInvocation)) {
                        for (int j = 0; j < jcMethodInvocation.args.size(); ++j) {
                            if (j == i) continue;
                            skip.add(jcMethodInvocation.args.get(j));
                        }
                        return;
                    }
                    super.visitApply(jcMethodInvocation);
                }
            }.scan(this.method);
            return UsedMethodDetector.usedMethods(this.method, t -> !skip.contains(t));
        }
    }

    class RuleDescriptor {
        final JCTree.JCClassDecl classDecl;
        private final JCTree.JCCompilationUnit cu;
        private final Context context;
        final java.util.List<TemplateDescriptor> beforeTemplates = new ArrayList<TemplateDescriptor>();
        TemplateDescriptor afterTemplate;

        public RuleDescriptor(JCTree.JCClassDecl classDecl, JCTree.JCCompilationUnit cu, Context context) {
            this.classDecl = classDecl;
            this.cu = cu;
            this.context = context;
        }

        @Nullable
        private RuleDescriptor validate() {
            if (this.beforeTemplates.isEmpty() || this.afterTemplate == null) {
                return null;
            }
            if (this.classDecl.typarams != null && !this.classDecl.typarams.isEmpty()) {
                RefasterTemplateProcessor.this.printNoteOnce("Generic type parameters are currently not supported", this.classDecl.sym);
                return null;
            }
            for (JCTree member : this.classDecl.getMembers()) {
                if (!(member instanceof JCTree.JCMethodDecl) || !this.beforeTemplates.stream().noneMatch(t -> t.method == member) || member == this.afterTemplate.method) continue;
                Iterator iterator = RefasterTemplateProcessor.getTemplateAnnotations((JCTree.JCMethodDecl)member, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains).iterator();
                if (!iterator.hasNext()) continue;
                JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)iterator.next();
                RefasterTemplateProcessor.this.printNoteOnce("@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
                return null;
            }
            boolean valid = this.resolve();
            if (valid) {
                for (TemplateDescriptor template : this.beforeTemplates) {
                    valid = valid && template.validate();
                }
                valid = valid && this.afterTemplate.validate();
            }
            return valid ? this : null;
        }

        public void beforeTemplate(JCTree.JCMethodDecl method) {
            this.beforeTemplates.add(new TemplateDescriptor(method, this.classDecl, this.cu, this.context));
        }

        public void afterTemplate(JCTree.JCMethodDecl method) {
            this.afterTemplate = new TemplateDescriptor(method, this.classDecl, this.cu, this.context);
        }

        private boolean resolve() {
            boolean valid = true;
            try {
                for (TemplateDescriptor beforeTemplate : this.beforeTemplates) {
                    valid &= beforeTemplate.resolve();
                }
                valid &= this.afterTemplate.resolve();
            }
            catch (Throwable t) {
                RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Had trouble type attributing the template.");
                valid = false;
            }
            return valid;
        }
    }
}

