/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import java.util.function.Predicate;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.Style;

class DelegateSourceFileForDiff
implements SourceFile {
    private final SourceFile delegate;
    private final String expected;

    public <P> String printAll(PrintOutputCapture<P> out) {
        out.append(this.expected);
        return out.getOut();
    }

    public DelegateSourceFileForDiff(SourceFile delegate, String expected) {
        this.delegate = delegate;
        this.expected = expected;
    }

    public boolean printEqualsInput(Parser.Input input, ExecutionContext ctx) {
        return this.delegate.printEqualsInput(input, ctx);
    }

    public Path getSourcePath() {
        return this.delegate.getSourcePath();
    }

    public <T extends SourceFile> T withSourcePath(Path path) {
        return (T)this.delegate.withSourcePath(path);
    }

    public Charset getCharset() {
        return this.delegate.getCharset();
    }

    public <T extends SourceFile> T withCharset(Charset charset) {
        return (T)this.delegate.withCharset(charset);
    }

    public boolean isCharsetBomMarked() {
        return this.delegate.isCharsetBomMarked();
    }

    public <T extends SourceFile> T withCharsetBomMarked(boolean marked) {
        return (T)this.delegate.withCharsetBomMarked(marked);
    }

    public Checksum getChecksum() {
        return this.delegate.getChecksum();
    }

    public <T extends SourceFile> T withChecksum(Checksum checksum) {
        return (T)this.delegate.withChecksum(checksum);
    }

    public FileAttributes getFileAttributes() {
        return this.delegate.getFileAttributes();
    }

    public <T extends SourceFile> T withFileAttributes(FileAttributes fileAttributes) {
        return (T)this.delegate.withFileAttributes(fileAttributes);
    }

    public <S extends Style> S getStyle(Class<S> style) {
        return (S)this.delegate.getStyle(style);
    }

    public <S extends Style> S getStyle(Class<S> style, S defaultStyle) {
        return (S)this.delegate.getStyle(style, defaultStyle);
    }

    public <P> byte[] printAllAsBytes(P p) {
        return this.delegate.printAllAsBytes(p);
    }

    public byte[] printAllAsBytes() {
        return this.delegate.printAllAsBytes();
    }

    public <P> String printAll(P p) {
        return this.delegate.printAll(p);
    }

    public String printAll() {
        return this.delegate.printAll();
    }

    public <P> String printAllTrimmed(P p) {
        return this.delegate.printAllTrimmed(p);
    }

    public String printAllTrimmed() {
        return this.delegate.printAllTrimmed();
    }

    public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return this.delegate.printer(cursor);
    }

    public <S, T extends S> T service(Class<S> service) {
        return (T)this.delegate.service(service);
    }

    public long getWeight(Predicate<Object> uniqueIdentity) {
        return this.delegate.getWeight(uniqueIdentity);
    }

    public String getJacksonPolymorphicTypeTag() {
        return this.delegate.getJacksonPolymorphicTypeTag();
    }

    public UUID getId() {
        return this.delegate.getId();
    }

    public Markers getMarkers() {
        return this.delegate.getMarkers();
    }

    public <T extends Tree> T withMarkers(Markers markers) {
        return (T)this.delegate.withMarkers(markers);
    }

    public <T extends Tree> T withId(UUID id) {
        return (T)this.delegate.withId(id);
    }

    public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.delegate.accept(v, p);
    }

    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return this.delegate.isAcceptable(v, p);
    }

    public String print(Cursor cursor) {
        return this.delegate.print(cursor);
    }

    public <P> String print(Cursor cursor, PrintOutputCapture<P> out) {
        return this.delegate.print(cursor, out);
    }

    public <P> String print(TreeVisitor<?, PrintOutputCapture<Integer>> printer) {
        return this.delegate.print(printer);
    }

    public <P> String printTrimmed(P p, Cursor cursor) {
        return this.delegate.printTrimmed(p, cursor);
    }

    public String printTrimmed(Cursor cursor) {
        return this.delegate.printTrimmed(cursor);
    }

    public String printTrimmed(TreeVisitor<?, PrintOutputCapture<Integer>> printer) {
        return this.delegate.printTrimmed(printer);
    }

    public boolean isScope(Tree tree) {
        return this.delegate.isScope(tree);
    }

    public <T2 extends Tree> T2 cast() {
        return (T2)this.delegate.cast();
    }

    public <T2 extends Tree> T2 safeCast() {
        return (T2)this.delegate.safeCast();
    }

    static interface PrintAll {
        public <P> String printAll(PrintOutputCapture<P> var1);
    }
}

