/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.util.function.Consumer;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.quark.Quark;
import org.openrewrite.quark.QuarkParser;
import org.openrewrite.test.Dir;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public interface SourceSpecs
extends Iterable<SourceSpec<?>> {
    public static SourceSpecs dir(String dir, SourceSpecs ... sources) {
        return SourceSpecs.dir(dir, (SourceSpec<SourceFile> s) -> {}, sources);
    }

    public static SourceSpecs dir(String dir, Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... sources) {
        return new Dir(dir, spec, sources);
    }

    public static SourceSpecs other(@Nullable String before) {
        return SourceSpecs.other(before, (SourceSpec<Quark> s) -> {});
    }

    public static SourceSpecs other(@Nullable String before, Consumer<SourceSpec<Quark>> spec) {
        SourceSpec<Quark> quark = new SourceSpec<Quark>(Quark.class, null, (Parser.Builder)QuarkParser.builder(), before, null);
        spec.accept(quark);
        return quark;
    }

    public static SourceSpecs other(@Nullable String before, @Nullable String after) {
        return SourceSpecs.other(before, after, s -> {});
    }

    public static SourceSpecs other(@Nullable String before, @Nullable String after, Consumer<SourceSpec<Quark>> spec) {
        SourceSpec<Quark> quark = new SourceSpec<Quark>(Quark.class, null, (Parser.Builder)QuarkParser.builder(), before, s -> after);
        spec.accept(quark);
        return quark;
    }

    public static SourceSpecs text(@Nullable String before) {
        return SourceSpecs.text(before, (SourceSpec<PlainText> s) -> {});
    }

    public static SourceSpecs text(@Nullable String before, Consumer<SourceSpec<PlainText>> spec) {
        SourceSpec<PlainText> text = new SourceSpec<PlainText>(PlainText.class, null, (Parser.Builder)PlainTextParser.builder(), before, null);
        spec.accept(text);
        return text;
    }

    public static SourceSpecs text(@Nullable String before, @Nullable String after) {
        return SourceSpecs.text(before, after, s -> {});
    }

    public static SourceSpecs text(@Nullable String before, @Nullable String after, Consumer<SourceSpec<PlainText>> spec) {
        SourceSpec<PlainText> text = new SourceSpec<PlainText>(PlainText.class, null, (Parser.Builder)PlainTextParser.builder(), before, s -> after);
        spec.accept(text);
        return text;
    }
}

