/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.internal;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class YamlPrinter<P>
extends YamlVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> YAML_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    @Override
    public Yaml visitDocument(Yaml.Document document, PrintOutputCapture<P> p) {
        this.beforeSyntax(document, p);
        if (document.isExplicit()) {
            p.out.append("---");
        }
        this.visit(document.getBlock(), p);
        if (document.getEnd() != null) {
            p.out.append(document.getEnd().getPrefix());
            if (document.getEnd().isExplicit()) {
                p.out.append("...");
            }
        }
        this.afterSyntax(document, p);
        return document;
    }

    @Override
    public Yaml visitDocuments(Yaml.Documents documents, PrintOutputCapture<P> p) {
        this.visitMarkers(documents.getMarkers(), p);
        this.visit(documents.getDocuments(), p);
        this.afterSyntax(documents, p);
        return documents;
    }

    @Override
    public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, PrintOutputCapture<P> p) {
        p.out.append(entry.getPrefix());
        if (entry.isDash()) {
            p.out.append('-');
        }
        this.visit(entry.getBlock(), p);
        if (entry.getTrailingCommaPrefix() != null) {
            p.out.append(entry.getTrailingCommaPrefix()).append(',');
        }
        this.afterSyntax(entry, p);
        return entry;
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence sequence, PrintOutputCapture<P> p) {
        this.visitMarkers(sequence.getMarkers(), p);
        if (sequence.getAnchor() != null) {
            this.visit(sequence.getAnchor(), p);
        }
        if (sequence.getOpeningBracketPrefix() != null) {
            p.out.append(sequence.getOpeningBracketPrefix()).append('[');
        }
        Yaml result = super.visitSequence(sequence, p);
        if (sequence.getClosingBracketPrefix() != null) {
            p.out.append(sequence.getClosingBracketPrefix()).append(']');
        }
        this.afterSyntax(result, p);
        return result;
    }

    @Override
    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, PrintOutputCapture<P> p) {
        this.beforeSyntax(entry, p);
        this.visit(entry.getKey(), p);
        p.out.append(entry.getBeforeMappingValueIndicator()).append(':');
        this.visit(entry.getValue(), p);
        this.afterSyntax(entry, p);
        return entry;
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping mapping, PrintOutputCapture<P> p) {
        this.visitMarkers(mapping.getMarkers(), p);
        if (mapping.getAnchor() != null) {
            this.visit(mapping.getAnchor(), p);
        }
        if (mapping.getOpeningBracePrefix() != null) {
            p.out.append(mapping.getOpeningBracePrefix()).append('{');
        }
        Yaml result = super.visitMapping(mapping, p);
        if (mapping.getClosingBracePrefix() != null) {
            p.out.append(mapping.getClosingBracePrefix()).append('}');
        }
        this.afterSyntax(result, p);
        return result;
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar scalar, PrintOutputCapture<P> p) {
        this.beforeSyntax(scalar, p);
        if (scalar.getAnchor() != null) {
            this.visit(scalar.getAnchor(), p);
        }
        switch (scalar.getStyle()) {
            case DOUBLE_QUOTED: {
                p.out.append('\"').append(scalar.getValue().replace("\\", "\\\\").replace("\u0000", "\\0").replace("\u0007", "\\a").replace("\b", "\\b").replace("\t", "\\t").replace("\n", "\\n").replace("\u000b", "\\v").replace("\f", "\\f").replace("\r", "\\r").replace("\u001b", "\\e").replace("\"", "\\\"").replace("\u0085", "\\N").replace("\u00a0", "\\_").replace("\u2028", "\\L").replace("\u2029", "\\P")).append('\"');
                break;
            }
            case SINGLE_QUOTED: {
                p.out.append('\'').append(scalar.getValue()).append('\'');
                break;
            }
            case LITERAL: {
                p.out.append('|').append(scalar.getValue());
                break;
            }
            case FOLDED: {
                p.out.append('>').append(scalar.getValue());
                break;
            }
            default: {
                p.out.append(scalar.getValue());
            }
        }
        this.afterSyntax(scalar, p);
        return scalar;
    }

    @Override
    public Yaml visitAnchor(Yaml.Anchor anchor, PrintOutputCapture<P> p) {
        this.visitMarkers(anchor.getMarkers(), p);
        p.out.append(anchor.getPrefix());
        p.out.append("&");
        p.out.append(anchor.getKey());
        p.out.append(anchor.getPostfix());
        this.afterSyntax(anchor, p);
        return anchor;
    }

    @Override
    public Yaml visitAlias(Yaml.Alias alias, PrintOutputCapture<P> p) {
        this.beforeSyntax(alias, p);
        p.out.append("*");
        p.out.append(alias.getAnchor().getKey());
        this.afterSyntax(alias, p);
        return alias;
    }

    private void beforeSyntax(Yaml y, PrintOutputCapture<P> p) {
        for (Marker marker : y.getMarkers().getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), YAML_MARKER_WRAPPER));
        }
        p.out.append(y.getPrefix());
        this.visitMarkers(y.getMarkers(), p);
        for (Marker marker : y.getMarkers().getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), YAML_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Yaml y, PrintOutputCapture<P> p) {
        for (Marker marker : y.getMarkers().getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), YAML_MARKER_WRAPPER));
        }
    }
}

