/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.DeleteProperty;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class CommentOutProperty
extends Recipe {
    @Option(displayName="Property key", description="The key to be commented out.", example="applicability.singleSource")
    private final String propertyKey;
    @Option(displayName="comment text", description="The comment text to be added before the specified key.", example="The `foo` property is deprecated, please migrate")
    private final String commentText;

    public String getDisplayName() {
        return "Comment out property";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s`", this.propertyKey);
    }

    public String getDescription() {
        return "Comment out a YAML property and add a comment in front.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){
            private String comment = "";
            private String indentation = "";

            @Override
            public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ExecutionContext ctx) {
                this.indentation = entry.getPrefix();
                if (!this.comment.isEmpty()) {
                    String newPrefix = entry.getPrefix() + "# " + CommentOutProperty.this.commentText + this.comment + entry.getPrefix();
                    this.comment = "";
                    return entry.withPrefix(newPrefix);
                }
                return super.visitSequenceEntry(entry, ctx);
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                String lastIndentation = this.indentation;
                this.indentation = entry.getPrefix();
                if (!this.comment.isEmpty()) {
                    String newPrefix = entry.getPrefix() + "# " + CommentOutProperty.this.commentText + this.comment + entry.getPrefix();
                    this.comment = "";
                    return entry.withPrefix(newPrefix);
                }
                Deque propertyEntries = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
                String prop = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyEntries.descendingIterator(), 0), false).map(e2 -> e2.getKey().getValue()).collect(Collectors.joining("."));
                if (prop.equals(CommentOutProperty.this.propertyKey)) {
                    String prefix = entry.getPrefix();
                    this.comment = prefix.contains("\n") ? entry.print(this.getCursor()).replace(prefix, prefix + "# ") : lastIndentation + "#" + entry.print(this.getCursor());
                    this.doAfterVisit(new DeleteProperty(CommentOutProperty.this.propertyKey, null, null).getVisitor());
                    return entry;
                }
                return super.visitMappingEntry(entry, ctx);
            }
        };
    }

    public CommentOutProperty(String propertyKey, String commentText) {
        this.propertyKey = propertyKey;
        this.commentText = commentText;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String getCommentText() {
        return this.commentText;
    }

    @NonNull
    public String toString() {
        return "CommentOutProperty(propertyKey=" + this.getPropertyKey() + ", commentText=" + this.getCommentText() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommentOutProperty)) {
            return false;
        }
        CommentOutProperty other = (CommentOutProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$commentText = this.getCommentText();
        String other$commentText = other.getCommentText();
        return !(this$commentText == null ? other$commentText != null : !this$commentText.equals(other$commentText));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CommentOutProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $commentText = this.getCommentText();
        result = result * 59 + ($commentText == null ? 43 : $commentText.hashCode());
        return result;
    }
}

