/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.CreateFileVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.remote.Remote;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class CreateYamlFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Relative file path", description="File path of new file.", example="foo/bar/baz.yaml")
    private final String relativeFileName;
    @Option(displayName="File contents", description="Multiline text content for the file.", example="a:\nproperty: value\nanother:\nproperty: value", required=false)
    @Nullable
    @Language(value="yml")
    private final String fileContents;
    @Option(displayName="File contents URL", description="URL to file containing text content for the file. Use either `fileContents` or `fileContentsUrl` option.", example="http://foo.bar/baz.yaml", required=false)
    @Nullable
    private final String fileContentsUrl;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten.", required=false)
    @Nullable
    private final Boolean overwriteExisting;

    public String getDisplayName() {
        return "Create YAML file";
    }

    public String getDescription() {
        return "Create a new YAML file.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AtomicBoolean shouldCreate) {
        return new CreateFileVisitor(Paths.get(this.relativeFileName, new String[0]), shouldCreate);
    }

    public Collection<SourceFile> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            return YamlParser.builder().build().parse("").map(brandNewFile -> brandNewFile.withSourcePath(Paths.get(this.relativeFileName, new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicBoolean created) {
        final Path path = Paths.get(this.relativeFileName, new String[0]);
        return new YamlVisitor<ExecutionContext>(){

            @Override
            public Yaml visitDocuments(Yaml.Documents documents, ExecutionContext ctx) {
                if ((created.get() || Boolean.TRUE.equals(CreateYamlFile.this.overwriteExisting)) && path.equals(documents.getSourcePath())) {
                    SourceFile sourceFile;
                    String yamlContents = CreateYamlFile.this.fileContents;
                    if (yamlContents == null && CreateYamlFile.this.fileContentsUrl != null) {
                        yamlContents = Remote.builder((Path)path, (URI)URI.create(CreateYamlFile.this.fileContentsUrl)).build().printAll((Object)ctx);
                    }
                    if (StringUtils.isBlank((String)yamlContents)) {
                        return documents.withDocuments(Collections.emptyList());
                    }
                    if (documents.printAll().equals(yamlContents)) {
                        return documents;
                    }
                    Optional<SourceFile> sourceFiles = YamlParser.builder().build().parse(yamlContents).findFirst();
                    if (sourceFiles.isPresent() && (sourceFile = sourceFiles.get()) instanceof Yaml.Documents) {
                        return documents.withDocuments(((Yaml.Documents)sourceFile).getDocuments());
                    }
                }
                return documents;
            }
        };
    }

    @Generated
    public CreateYamlFile(String relativeFileName, @Nullable @Language(value="yml") String fileContents, @Nullable String fileContentsUrl, @Nullable Boolean overwriteExisting) {
        this.relativeFileName = relativeFileName;
        this.fileContents = fileContents;
        this.fileContentsUrl = fileContentsUrl;
        this.overwriteExisting = overwriteExisting;
    }

    @Generated
    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Nullable
    @Language(value="yml")
    @Generated
    public String getFileContents() {
        return this.fileContents;
    }

    @Nullable
    @Generated
    public String getFileContentsUrl() {
        return this.fileContentsUrl;
    }

    @Nullable
    @Generated
    public Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CreateYamlFile(relativeFileName=" + this.getRelativeFileName() + ", fileContents=" + this.getFileContents() + ", fileContentsUrl=" + this.getFileContentsUrl() + ", overwriteExisting=" + this.getOverwriteExisting() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateYamlFile)) {
            return false;
        }
        CreateYamlFile other = (CreateYamlFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        if (this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName)) {
            return false;
        }
        String this$fileContents = this.getFileContents();
        String other$fileContents = other.getFileContents();
        if (this$fileContents == null ? other$fileContents != null : !this$fileContents.equals(other$fileContents)) {
            return false;
        }
        String this$fileContentsUrl = this.getFileContentsUrl();
        String other$fileContentsUrl = other.getFileContentsUrl();
        return !(this$fileContentsUrl == null ? other$fileContentsUrl != null : !this$fileContentsUrl.equals(other$fileContentsUrl));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CreateYamlFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        String $fileContents = this.getFileContents();
        result = result * 59 + ($fileContents == null ? 43 : $fileContents.hashCode());
        String $fileContentsUrl = this.getFileContentsUrl();
        result = result * 59 + ($fileContentsUrl == null ? 43 : $fileContentsUrl.hashCode());
        return result;
    }
}

