/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.cleanup;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class RemoveUnusedVisitor<P>
extends YamlIsoVisitor<P> {
    private final @Nullable Cursor cursor;

    public RemoveUnusedVisitor(@Nullable Cursor cursor) {
        this.cursor = cursor;
    }

    @Override
    public Yaml.Sequence visitSequence(Yaml.Sequence sequence, P p) {
        Yaml s = super.visitSequence(sequence, (Object)p);
        if ((this.cursor == null || this.cursor.isScopeInPath((Tree)s)) && ((Yaml.Sequence)(s = ((Yaml.Sequence)s).withEntries(ListUtils.map(((Yaml.Sequence)s).getEntries(), e -> {
            if (e.getBlock() == null || this.isEmptyScalar(e.getBlock())) {
                return null;
            }
            return e;
        })))).getEntries().isEmpty()) {
            return null;
        }
        return s;
    }

    @Override
    public Yaml.Mapping visitMapping(Yaml.Mapping mapping, P p) {
        Yaml m = super.visitMapping(mapping, (Object)p);
        if ((this.cursor == null || this.cursor.isScopeInPath((Tree)m)) && ((Yaml.Mapping)(m = ((Yaml.Mapping)m).withEntries(ListUtils.map(((Yaml.Mapping)m).getEntries(), e -> {
            if (e.getValue() == null || this.isEmptyScalar(e.getValue())) {
                return null;
            }
            if (e.getValue() instanceof Yaml.Mapping && ((Yaml.Mapping)e.getValue()).getEntries().isEmpty()) {
                return null;
            }
            return e;
        })))).getEntries().isEmpty()) {
            return null;
        }
        return m;
    }

    private boolean isEmptyScalar(Yaml.Block y) {
        if (y instanceof Yaml.Scalar) {
            Yaml.Scalar scalar = (Yaml.Scalar)y;
            return scalar.getValue().isEmpty() && Yaml.Scalar.Style.PLAIN.equals((Object)scalar.getStyle());
        }
        return false;
    }
}

