/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.features.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.servicemix.kernel.gshell.features.internal.FeatureImpl;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.pax.scanner.ScannerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FeaturesFilter {
    private final String m_name;
    private final String m_version;

    FeaturesFilter(String name) {
        this(name, null);
    }

    FeaturesFilter(String name, String version) {
        NullArgumentException.validateNotEmpty(name, true, "Feature name");
        this.m_name = name;
        this.m_version = version == null || version.trim().length() == 0 ? FeatureImpl.DEFAULT_VERSION : version;
    }

    String getName() {
        return this.m_name;
    }

    String getVersion() {
        return this.m_version;
    }

    static Collection<FeaturesFilter> fromProvisionSpec(ProvisionSpec provisionSpec) throws ScannerException {
        String[] features;
        String rawFeatures = provisionSpec.getFilter();
        if (rawFeatures == null || rawFeatures.length() == 0) {
            throw new ScannerException("Feature names are mandatory (use !/)");
        }
        ArrayList<FeaturesFilter> filters = new ArrayList<FeaturesFilter>();
        for (String feature : features = rawFeatures.split(",")) {
            String[] segments = feature.split("/");
            if (segments.length > 1) {
                filters.add(new FeaturesFilter(segments[0], segments[1]));
                continue;
            }
            filters.add(new FeaturesFilter(segments[0]));
        }
        return filters;
    }
}

