/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.pom.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.pax.scanner.ScannedBundle;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.scanner.ScannerException;
import org.ops4j.pax.scanner.common.ScannedFileBundle;
import org.ops4j.pax.scanner.common.ScannerConfiguration;
import org.ops4j.pax.scanner.common.SystemPropertyUtils;
import org.ops4j.pax.scanner.pom.internal.PomScannerConfiguration;
import org.ops4j.pax.scanner.pom.internal.PomScannerConfigurationImpl;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomScanner
implements Scanner {
    private static final Log LOGGER = LogFactory.getLog(PomScanner.class);
    private PropertyResolver m_propertyResolver;

    public PomScanner(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScannedBundle> scan(ProvisionSpec provisionSpec) throws MalformedSpecificationException, ScannerException {
        NullArgumentException.validateNotNull(provisionSpec, "Provision spec");
        LOGGER.debug("Scanning [" + provisionSpec.getPath() + "]");
        ArrayList<ScannedBundle> scannedBundles = new ArrayList<ScannedBundle>();
        PomScannerConfiguration config = this.createConfiguration();
        InputStream inputStream = null;
        try {
            try {
                List<Element> dependencies;
                Element properties;
                inputStream = URLUtils.prepareInputStream(provisionSpec.getPathAsUrl(), config.getCertificateCheck() == false);
                Document doc = XmlUtils.parseDoc(inputStream);
                Integer defaultStartLevel = this.getDefaultStartLevel(provisionSpec, config);
                Boolean defaultStart = this.getDefaultStart(provisionSpec, config);
                Boolean defaultUpdate = this.getDefaultUpdate(provisionSpec, config);
                String mainArtifactURL = PomScanner.composeURL(doc.getDocumentElement(), "packaging", config);
                if (mainArtifactURL != null) {
                    scannedBundles.add(new ScannedFileBundle(mainArtifactURL, defaultStartLevel, defaultStart, defaultUpdate));
                }
                if ((properties = XmlUtils.getElement(doc, "properties")) != null) {
                    List<Element> props = XmlUtils.getChildElements(properties);
                    for (Element property : props) {
                        String key = property.getNodeName();
                        String value = PomScanner.getTextContent(property);
                        System.setProperty(key, value);
                    }
                }
                if ((dependencies = XmlUtils.getElements(doc, "dependencies/dependency")) != null) {
                    for (Element dependency : dependencies) {
                        String dependencyURL = PomScanner.composeURL(dependency, "type", config);
                        if (dependencyURL == null) continue;
                        ScannedFileBundle scannedFileBundle = new ScannedFileBundle(dependencyURL, defaultStartLevel, defaultStart, defaultUpdate);
                        scannedBundles.add(scannedFileBundle);
                        LOGGER.debug("Installing bundle [" + scannedFileBundle + "]");
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new ScannerException("Could not parse the provision file", e);
        }
        catch (ParserConfigurationException e) {
            throw new ScannerException("Could not parse the provision file", e);
        }
        catch (SAXException e) {
            throw new ScannerException("Could not parse the provision file", e);
        }
        return scannedBundles;
    }

    private static String composeURL(Element parentElement, String typeElementName, PomScannerConfiguration configuration) throws ScannerException {
        Element element = XmlUtils.getElement(parentElement, "artifactId");
        if (element == null) {
            throw new ScannerException("Invalid pom file. Missing artifact id.");
        }
        String artifactId = PomScanner.getTextContent(element);
        if (artifactId == null || artifactId.trim().length() == 0) {
            throw new ScannerException("Invalid pom file. Invalid artifact id.");
        }
        element = XmlUtils.getElement(parentElement, "groupId");
        if (element == null) {
            throw new ScannerException("Invalid pom file. Missing group id.");
        }
        String groupId = PomScanner.getTextContent(element);
        if (groupId == null || groupId.trim().length() == 0) {
            throw new ScannerException("Invalid pom file. Invalid group id.");
        }
        element = XmlUtils.getElement(parentElement, "version");
        String version = null;
        if (element != null) {
            version = PomScanner.getTextContent(element);
        }
        if (version != null && version.trim().length() == 0) {
            version = null;
        }
        element = XmlUtils.getElement(parentElement, typeElementName);
        String type = null;
        if (element != null) {
            type = PomScanner.getTextContent(element);
        }
        if (PomScanner.isNotAcceptedType(type, configuration)) {
            return null;
        }
        if (type != null && (type.trim().length() == 0 || type.trim().equalsIgnoreCase("bundle"))) {
            type = null;
        }
        element = XmlUtils.getElement(parentElement, "scope");
        String scope = null;
        if (element != null) {
            scope = PomScanner.getTextContent(element);
        }
        if (scope != null && scope.equalsIgnoreCase("test")) {
            return null;
        }
        StringBuilder builder = new StringBuilder().append("mvn:").append(groupId).append("/").append(artifactId);
        if (version != null) {
            builder.append("/").append(version);
            if (type != null) {
                builder.append("/").append(type);
            }
        }
        return builder.toString();
    }

    private static boolean isNotAcceptedType(String type, PomScannerConfiguration configuration) {
        String[] includedTypes;
        String[] excludedTypes;
        String localType = type;
        if (localType == null) {
            localType = "jar";
        }
        if ((excludedTypes = configuration.getDefaultExcludedTypes()) != null) {
            for (String excludedType : excludedTypes) {
                if (!localType.matches(excludedType)) continue;
                return true;
            }
        }
        if ((includedTypes = configuration.getDefaultIncludedTypes()) != null) {
            for (String includedType : includedTypes) {
                if (!localType.matches(includedType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getTextContent(Element element) {
        String text = XmlUtils.getTextContent(element);
        if (text != null) {
            text = SystemPropertyUtils.resolvePlaceholders(text);
            text = text.trim();
        }
        return text;
    }

    private Integer getDefaultStartLevel(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Integer startLevel = provisionSpec.getStartLevel();
        if (startLevel == null) {
            startLevel = config.getStartLevel();
        }
        return startLevel;
    }

    private Boolean getDefaultStart(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean start = provisionSpec.shouldStart();
        if (start == null) {
            start = config.shouldStart();
        }
        return start;
    }

    private Boolean getDefaultUpdate(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean update = provisionSpec.shouldUpdate();
        if (update == null) {
            update = config.shouldUpdate();
        }
        return update;
    }

    public void setResolver(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    PomScannerConfiguration createConfiguration() {
        return new PomScannerConfigurationImpl(this.m_propertyResolver);
    }
}

