/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.bundlerepository.CapabilityImpl;
import org.apache.felix.bundlerepository.Logger;
import org.apache.felix.bundlerepository.PropertyImpl;
import org.apache.felix.bundlerepository.R4Import;
import org.apache.felix.bundlerepository.R4Package;
import org.apache.felix.bundlerepository.RequirementImpl;
import org.apache.felix.bundlerepository.ResourceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.Resource;

public class LocalRepositoryImpl
implements Repository {
    private BundleContext m_context = null;
    private final Logger m_logger;
    private long m_currentTimeStamp = 0L;
    private long m_snapshotTimeStamp = 0L;
    private List m_localResourceList = new ArrayList();
    private BundleListener m_bundleListener = null;

    public LocalRepositoryImpl(BundleContext context, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
        this.initialize();
    }

    public void dispose() {
        this.m_context.removeBundleListener(this.m_bundleListener);
    }

    public URL getURL() {
        return null;
    }

    public String getName() {
        return "Locally Installed Repository";
    }

    public synchronized long getLastModified() {
        return this.m_snapshotTimeStamp;
    }

    public synchronized long getCurrentTimeStamp() {
        return this.m_currentTimeStamp;
    }

    public synchronized Resource[] getResources() {
        return this.m_localResourceList.toArray(new Resource[this.m_localResourceList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.m_bundleListener = new SynchronousBundleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bundleChanged(BundleEvent event) {
                LocalRepositoryImpl localRepositoryImpl = LocalRepositoryImpl.this;
                synchronized (localRepositoryImpl) {
                    LocalRepositoryImpl.this.m_currentTimeStamp = new Date().getTime();
                }
            }
        };
        this.m_context.addBundleListener(this.m_bundleListener);
        Bundle[] bundles = null;
        LocalRepositoryImpl localRepositoryImpl = this;
        synchronized (localRepositoryImpl) {
            this.m_snapshotTimeStamp = this.m_currentTimeStamp = new Date().getTime();
            bundles = this.m_context.getBundles();
        }
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            try {
                this.m_localResourceList.add(new LocalResourceImpl(bundles[i], this.m_logger));
                continue;
            }
            catch (InvalidSyntaxException ex) {
                this.m_logger.log(2, ex.getMessage(), ex);
            }
        }
    }

    public static class LocalResourceImpl
    extends ResourceImpl {
        private Bundle m_bundle = null;

        LocalResourceImpl(Bundle bundle, Logger logger) throws InvalidSyntaxException {
            this(null, bundle, logger);
        }

        LocalResourceImpl(ResourceImpl resource, Bundle bundle, Logger logger) throws InvalidSyntaxException {
            super(resource);
            this.m_bundle = bundle;
            this.initialize();
        }

        public Bundle getBundle() {
            return this.m_bundle;
        }

        private void initialize() throws InvalidSyntaxException {
            Dictionary dict = this.m_bundle.getHeaders();
            this.convertAttributesToProperties(dict);
            this.convertImportPackageToRequirement(dict);
            this.convertImportServiceToRequirement(dict);
            this.convertExportPackageToCapability(dict);
            this.convertExportServiceToCapability(dict);
            if (this.m_bundle.getBundleId() == 0L) {
                // empty if block
            }
        }

        private void convertAttributesToProperties(Dictionary dict) {
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.equalsIgnoreCase("Bundle-SymbolicName")) {
                    this.put("symbolicname", (String)dict.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("Bundle-Name")) {
                    this.put("presentationname", (String)dict.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("Bundle-Version")) {
                    this.put("version", (String)dict.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("Bundle-Source")) {
                    this.put("source", (String)dict.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("Bundle-Description")) {
                    this.put("description", (String)dict.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("Bundle-DocURL")) {
                    this.put("documentation", (String)dict.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("Bundle-Copyright")) {
                    this.put("copyright", (String)dict.get(key));
                    continue;
                }
                if (!key.equalsIgnoreCase("Bundle-License")) continue;
                this.put("license", (String)dict.get(key));
            }
        }

        private void convertImportPackageToRequirement(Dictionary dict) throws InvalidSyntaxException {
            String target = (String)dict.get("Import-Package");
            if (target != null) {
                R4Package[] pkgs = R4Package.parseImportOrExportHeader(target);
                R4Import[] imports = new R4Import[pkgs.length];
                for (int i = 0; i < pkgs.length; ++i) {
                    imports[i] = new R4Import(pkgs[i]);
                }
                for (int impIdx = 0; impIdx < imports.length; ++impIdx) {
                    String low;
                    RequirementImpl req = new RequirementImpl();
                    req.setMultiple("false");
                    req.setOptional(Boolean.toString(imports[impIdx].isOptional()));
                    req.setName("package");
                    req.addText("Import package " + imports[impIdx].toString());
                    String string = low = imports[impIdx].isLowInclusive() ? "(version>=" + imports[impIdx].getVersion() + ")" : "(!(version<=" + imports[impIdx].getVersion() + "))";
                    if (imports[impIdx].getVersionHigh() != null) {
                        String high = imports[impIdx].isHighInclusive() ? "(version<=" + imports[impIdx].getVersionHigh() + ")" : "(!(version>=" + imports[impIdx].getVersionHigh() + "))";
                        req.setFilter("(&(package=" + imports[impIdx].getName() + ")" + low + high + ")");
                    } else {
                        req.setFilter("(&(package=" + imports[impIdx].getName() + ")" + low + ")");
                    }
                    this.addRequire(req);
                }
            }
        }

        private void convertImportServiceToRequirement(Dictionary dict) throws InvalidSyntaxException {
            String target = (String)dict.get("Import-Service");
            if (target != null) {
                R4Package[] pkgs = R4Package.parseImportOrExportHeader(target);
                for (int pkgIdx = 0; pkgs != null && pkgIdx < pkgs.length; ++pkgIdx) {
                    RequirementImpl req = new RequirementImpl();
                    req.setMultiple("false");
                    req.setName("service");
                    req.addText("Import service " + pkgs[pkgIdx].toString());
                    req.setFilter("(service=" + pkgs[pkgIdx].getName() + ")");
                    this.addRequire(req);
                }
            }
        }

        private void convertExportPackageToCapability(Dictionary dict) {
            String target = (String)dict.get("Export-Package");
            if (target != null) {
                R4Package[] pkgs = R4Package.parseImportOrExportHeader(target);
                for (int pkgIdx = 0; pkgs != null && pkgIdx < pkgs.length; ++pkgIdx) {
                    CapabilityImpl cap = new CapabilityImpl();
                    cap.setName("package");
                    cap.addP(new PropertyImpl("package", null, pkgs[pkgIdx].getName()));
                    cap.addP(new PropertyImpl("version", "version", pkgs[pkgIdx].getVersion().toString()));
                    this.addCapability(cap);
                }
            }
        }

        private void convertExportServiceToCapability(Dictionary dict) {
            String target = (String)dict.get("Export-Service");
            if (target != null) {
                R4Package[] pkgs = R4Package.parseImportOrExportHeader(target);
                for (int pkgIdx = 0; pkgs != null && pkgIdx < pkgs.length; ++pkgIdx) {
                    CapabilityImpl cap = new CapabilityImpl();
                    cap.setName("service");
                    cap.addP(new PropertyImpl("service", null, pkgs[pkgIdx].getName()));
                    this.addCapability(cap);
                }
            }
        }
    }
}

