/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.platform.JavaRunner;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.pax.runner.platform.internal.CommandLineBuilder;

public class ScriptJavaRunner
implements JavaRunner {
    private static final Log LOG = LogFactory.getLog(ScriptJavaRunner.class);

    public synchronized void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDirectory) throws PlatformException {
        StringBuilder batchCp = new StringBuilder();
        StringBuilder shellCp = new StringBuilder();
        for (String path : classpath) {
            if (batchCp.length() != 0) {
                batchCp.append(';');
            }
            batchCp.append(path);
            if (shellCp.length() != 0) {
                shellCp.append(':');
            }
            shellCp.append(path);
        }
        CommandLineBuilder batchCommandLine = new CommandLineBuilder().append("java").append(vmOptions).append("-cp").append(batchCp.toString()).append(mainClass).append(programOptions);
        CommandLineBuilder shellCommandLine = new CommandLineBuilder().append("java").append(vmOptions).append("-cp").append(shellCp.toString()).append(mainClass).append(programOptions);
        LOG.debug("Start UNIX command line [" + Arrays.toString(shellCommandLine.toArray()) + "]");
        LOG.debug("Start WIN command line [" + Arrays.toString(batchCommandLine.toArray()) + "]");
        String shell = this.getShellScript(shellCommandLine);
        String batch = this.getBatchScript(batchCommandLine);
        try {
            LOG.debug("Writing run scripts.");
            FileWriter sh = new FileWriter(new File(workingDirectory, "run.sh"));
            sh.write(shell);
            sh.close();
            FileWriter bat = new FileWriter(new File(workingDirectory, "run.bat"));
            bat.write(batch);
            bat.close();
        }
        catch (IOException e) {
            throw new PlatformException("Could not write run scripts", e);
        }
    }

    private String getShellScript(CommandLineBuilder commandLine) {
        String newline = "\n";
        StringBuilder script = new StringBuilder();
        script.append("#!/bin/sh");
        script.append("\n");
        for (String s : commandLine.toArray()) {
            script.append(s);
            script.append(" ");
        }
        script.append("\"$@\"");
        script.append("\n");
        return script.toString();
    }

    private String getBatchScript(CommandLineBuilder commandLine) {
        String newline = "\r\n";
        StringBuilder script = new StringBuilder();
        script.append("\r\n");
        for (String s : commandLine.toArray()) {
            script.append(s);
            script.append(" ");
        }
        script.append("%*");
        script.append("\r\n");
        return script.toString();
    }
}

