/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.dir.internal;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.io.DirectoryLister;
import org.ops4j.io.Lister;
import org.ops4j.io.ZipLister;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.pax.scanner.ScannedBundle;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.scanner.ScannerException;
import org.ops4j.pax.scanner.common.ScannedFileBundle;
import org.ops4j.pax.scanner.common.ScannerConfiguration;
import org.ops4j.pax.scanner.common.ScannerConfigurationImpl;
import org.ops4j.util.property.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirScanner
implements Scanner {
    private static final Log LOGGER = LogFactory.getLog(DirScanner.class);
    private PropertyResolver m_propertyResolver;

    public DirScanner(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    @Override
    public List<ScannedBundle> scan(ProvisionSpec provisionSpec) throws MalformedSpecificationException, ScannerException {
        NullArgumentException.validateNotNull(provisionSpec, "Provision spec");
        LOGGER.debug("Scanning [" + provisionSpec.getPath() + "]");
        ScannerConfiguration config = this.createConfiguration();
        Pattern filter = provisionSpec.getFilterPattern();
        String spec = provisionSpec.getPath();
        Integer defaultStartLevel = this.getDefaultStartLevel(provisionSpec, config);
        Boolean defaultStart = this.getDefaultStart(provisionSpec, config);
        Boolean defaultUpdate = this.getDefaultUpdate(provisionSpec, config);
        LOGGER.trace("Searching for [" + spec + "]");
        URL url = null;
        try {
            url = new URL(spec);
        }
        catch (MalformedURLException ignore) {
            LOGGER.trace("Specification is not a valid url: " + ignore.getMessage() + ". Continue discovery...");
        }
        File file = null;
        if (url != null && "file".equals(url.getProtocol())) {
            try {
                URI uri = new URI(url.toExternalForm().replaceAll(" ", "%20"));
                file = new File(uri);
            }
            catch (URISyntaxException ignore) {
                LOGGER.trace("Specification is not a valid file url: " + ignore.getMessage() + ". Continue discovery...");
            }
        } else {
            file = new File(spec);
        }
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                try {
                    return this.list(new DirectoryLister(file, filter), defaultStartLevel, defaultStart, defaultUpdate);
                }
                catch (MalformedURLException e) {
                    throw new MalformedSpecificationException(e);
                }
            }
            LOGGER.trace("Specification is not a directory. Continue discovery...");
        } else {
            LOGGER.trace("Specification is not a valid file. Continue discovery...");
        }
        try {
            ZipFile zip = null;
            URL baseUrl = null;
            if (file != null && file.exists()) {
                zip = new ZipFile(file);
                baseUrl = file.toURL();
            } else if (url != null) {
                zip = new ZipFile(url.toExternalForm());
                baseUrl = url;
            }
            if (zip != null && baseUrl != null) {
                try {
                    return this.list(new ZipLister(baseUrl, zip.entries(), filter), defaultStartLevel, defaultStart, defaultUpdate);
                }
                catch (MalformedURLException e) {
                    throw new MalformedSpecificationException(e);
                }
            }
        }
        catch (IOException ignore) {
            LOGGER.trace("Specification is not a valid zip: " + ignore.getMessage() + "Continue discovery...");
        }
        if (url != null && !url.toExternalForm().startsWith("jar")) {
            try {
                URL jarUrl = new URL("jar:" + url.toURI().toASCIIString() + "!/");
                JarURLConnection jar = (JarURLConnection)jarUrl.openConnection();
                return this.list(new ZipLister(url, jar.getJarFile().entries(), filter), defaultStartLevel, defaultStart, defaultUpdate);
            }
            catch (Exception ignore) {
                LOGGER.trace("Specification is not a valid jar: " + ignore.getMessage());
            }
        }
        LOGGER.trace("Specification urlSpec cannot be used. Stopping.");
        throw new MalformedSpecificationException("Specification [" + provisionSpec.getPath() + "] could not be used");
    }

    private List<ScannedBundle> list(Lister lister, Integer startLevel, Boolean shouldStart, Boolean update) throws MalformedURLException {
        ArrayList<ScannedBundle> scannedBundles = new ArrayList<ScannedBundle>();
        List<URL> urls = lister.list();
        if (urls != null) {
            for (URL url : urls) {
                ScannedFileBundle scannedFileBundle = new ScannedFileBundle(url.toExternalForm(), startLevel, shouldStart, update);
                scannedBundles.add(scannedFileBundle);
                LOGGER.debug("Installing bundle [" + scannedFileBundle + "]");
            }
        }
        return scannedBundles;
    }

    private Integer getDefaultStartLevel(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Integer startLevel = provisionSpec.getStartLevel();
        if (startLevel == null) {
            startLevel = config.getStartLevel();
        }
        return startLevel;
    }

    private Boolean getDefaultStart(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean start = provisionSpec.shouldStart();
        if (start == null) {
            start = config.shouldStart();
        }
        return start;
    }

    private Boolean getDefaultUpdate(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean update = provisionSpec.shouldUpdate();
        if (update == null) {
            update = config.shouldUpdate();
        }
        return update;
    }

    public void setResolver(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    ScannerConfiguration createConfiguration() {
        return new ScannerConfigurationImpl(this.m_propertyResolver, "org.ops4j.pax.scanner.dir");
    }
}

