/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.Configuration;

public class ConfigurationImpl
implements Configuration {
    private static final Log LOGGER = LogFactory.getLog(ConfigurationImpl.class);
    private static final String CLASSPATH_PROTOCOL = "classpath:";
    private final Properties m_properties;

    public ConfigurationImpl(String url) {
        NullArgumentException.validateNotEmpty(url, "Configuration url");
        try {
            InputStream inputStream;
            if (url.startsWith(CLASSPATH_PROTOCOL)) {
                String actualConfigFileName = url.split(":")[1];
                NullArgumentException.validateNotEmpty(actualConfigFileName, "configuration file name");
                inputStream = this.getClass().getClassLoader().getResourceAsStream(actualConfigFileName);
            } else {
                inputStream = new URL(url).openStream();
            }
            NullArgumentException.validateNotNull(inputStream, "Canot find url [" + url + "]");
            this.m_properties = new Properties();
            this.m_properties.load(inputStream);
            LOGGER.debug("Using config [" + url + "]");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load configuration from url [" + url + "]", e);
        }
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public String[] getPropertyNames(String regex) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<?> propertyNames = this.m_properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (!propertyName.matches(regex)) continue;
            result.add(propertyName);
        }
        return result.toArray(new String[result.size()]);
    }
}

