/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.BundleReference;
import org.ops4j.pax.runner.platform.BundleReferenceBean;
import org.ops4j.pax.runner.platform.internal.PlatformDefinition;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.util.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformDefinitionImpl
implements PlatformDefinition {
    private static final Log LOGGER = LogFactory.getLog(PlatformDefinitionImpl.class);
    private String m_systemPackageName;
    private URL m_systemPackage;
    private String m_packages;
    private final Map<String, String> m_profiles;
    private final Map<String, List<BundleReference>> m_bundles;
    private String m_defaultProfile;

    public PlatformDefinitionImpl(InputStream inputStream, Integer startLevel) throws IOException, ParserConfigurationException, SAXException {
        NullArgumentException.validateNotNull(inputStream, "Input stream");
        this.m_profiles = new HashMap<String, String>();
        this.m_bundles = new HashMap<String, List<BundleReference>>();
        Document doc = XmlUtils.parseDoc(inputStream);
        this.m_systemPackageName = XmlUtils.getTextContentOfElement(doc, "name");
        String systemPackage = XmlUtils.getTextContentOfElement(doc, "system");
        if (systemPackage == null) {
            throw new IOException("Invalid syntax: system bundle url not defined");
        }
        this.m_systemPackage = new URL(systemPackage);
        if (this.m_systemPackageName == null) {
            this.m_systemPackageName = systemPackage;
        }
        this.m_packages = XmlUtils.getTextContentOfElement(doc, "packages");
        if (this.m_packages != null) {
            this.m_packages = this.m_packages.replace(" ", "").replace("\n", "");
        }
        this.extractProfiles(doc, startLevel);
        if (this.m_profiles.size() == 0) {
            throw new IOException("Invalid syntax: there should be at least one profile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractProfiles(Document doc, Integer profileStartLevel) throws IOException, ParserConfigurationException, SAXException {
        List<Element> profileRefs;
        List<Element> profiles = XmlUtils.getElements(doc, "profile");
        if (profiles != null) {
            for (Element profile : profiles) {
                String profileName = profile.getAttribute("name");
                if (this.m_profiles.containsKey(profileName)) continue;
                Boolean profileDefault = Boolean.valueOf(profile.getAttribute("default"));
                String profileExtends = profile.getAttribute("extends");
                if (profileExtends != null && profileExtends.trim().length() == 0) {
                    profileExtends = null;
                }
                if (profileName == null) {
                    throw new IOException("Invalid syntax: all profiles must have a name");
                }
                if (this.m_defaultProfile == null || profileDefault.booleanValue()) {
                    this.m_defaultProfile = profileName;
                }
                this.m_profiles.put(profileName, profileExtends);
                this.m_bundles.put(profileName, new ArrayList());
                List<Element> bundles = XmlUtils.getElements(profile, "bundle");
                if (bundles == null) continue;
                for (Element bundle : bundles) {
                    Boolean shouldUpdate;
                    Boolean shouldStart;
                    Integer startLevel;
                    String name = XmlUtils.getTextContentOfElement(bundle, "name");
                    String urlSpec = XmlUtils.getTextContentOfElement(bundle, "url");
                    if (urlSpec == null) {
                        throw new IOException("Invalid syntax: bundle url not defined in profile " + profileName);
                    }
                    ProvisionSpec provisionSpec = new ProvisionSpec(urlSpec);
                    URL bundleURL = new URL(provisionSpec.getScheme() + ":" + provisionSpec.getPath());
                    if (name == null) {
                        name = bundleURL.toExternalForm();
                    }
                    if ((startLevel = provisionSpec.getStartLevel()) == null) {
                        startLevel = profileStartLevel;
                    }
                    if ((shouldStart = provisionSpec.shouldStart()) == null) {
                        shouldStart = Boolean.TRUE;
                    }
                    if ((shouldUpdate = provisionSpec.shouldUpdate()) == null) {
                        shouldUpdate = Boolean.FALSE;
                    }
                    this.m_bundles.get(profileName).add(new BundleReferenceBean(name, bundleURL, startLevel, shouldStart, shouldUpdate));
                }
            }
        }
        if ((profileRefs = XmlUtils.getElements(doc, "profileRef")) != null) {
            for (Element profileRef : profileRefs) {
                String href = profileRef.getAttribute("href");
                if (href == null) {
                    throw new IOException("Invalid syntax: all profileRefs must have an href attribute");
                }
                InputStream is = null;
                try {
                    is = new URL(href).openStream();
                    this.extractProfiles(XmlUtils.parseDoc(new URL(href).openStream()), profileStartLevel);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
    }

    @Override
    public URL getSystemPackage() {
        return this.m_systemPackage;
    }

    @Override
    public String getSystemPackageName() {
        return this.m_systemPackageName;
    }

    @Override
    public String getPackages() {
        return this.m_packages;
    }

    @Override
    public List<BundleReference> getPlatformBundles(String profiles) {
        String[] segments;
        List<BundleReference> bundles = null;
        if (profiles == null || profiles.trim().length() == 0) {
            return this.getPlatformBundles(this.m_defaultProfile);
        }
        for (String segment : segments = profiles.split(",")) {
            if (this.m_profiles.containsKey(segment)) {
                List<BundleReference> references;
                String extended;
                if (bundles == null) {
                    bundles = new ArrayList<BundleReference>();
                }
                if ((extended = this.m_profiles.get(segment)) != null && (references = this.getPlatformBundles(extended)) != null && references.size() > 0) {
                    for (BundleReference reference : references) {
                        if (bundles.contains(reference)) continue;
                        bundles.add(reference);
                    }
                }
                if ((references = this.m_bundles.get(segment)) == null || references.size() <= 0) continue;
                for (BundleReference reference : references) {
                    if (bundles.contains(reference)) continue;
                    bundles.add(reference);
                }
                continue;
            }
            LOGGER.warn("Invalid profile [" + segment + "]. Skipping.");
        }
        if (bundles == null && !this.m_defaultProfile.equals(profiles)) {
            bundles = this.getPlatformBundles(this.m_defaultProfile);
        }
        return bundles;
    }
}

