/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.felix.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.BundleReference;
import org.ops4j.pax.runner.platform.Configuration;
import org.ops4j.pax.runner.platform.PlatformBuilder;
import org.ops4j.pax.runner.platform.PlatformContext;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.util.collections.PropertiesWriter;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FelixPlatformBuilder
implements PlatformBuilder {
    protected final Log LOGGER = LogFactory.getLog(this.getClass());
    private static final String PROVIDER_NAME = "felix";
    private static final String MAIN_CLASS_NAME = "org.apache.felix.main.Main";
    protected static final String CONFIG_DIRECTORY = "felix";
    private static final String CONFIG_INI = "config.ini";
    protected static final String CACHE_DIRECTORY = "cache";
    private static final String CONSOLE_PROFILE = "tui";
    private static final String SEPARATOR = " ";
    private final BundleContext m_bundleContext;
    private final String m_version;

    public FelixPlatformBuilder(BundleContext bundleContext, String version) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        NullArgumentException.validateNotNull(version, "Version");
        this.m_bundleContext = bundleContext;
        this.m_version = version;
    }

    @Override
    public void prepare(PlatformContext context) throws PlatformException {
        NullArgumentException.validateNotNull(context, "Platform context");
        List<BundleReference> bundles = context.getBundles();
        OutputStream os = null;
        try {
            Integer bundleStartLevel;
            File workingDirectory = context.getWorkingDirectory();
            File configDirectory = new File(workingDirectory, "felix");
            configDirectory.mkdirs();
            File configFile = new File(configDirectory, CONFIG_INI);
            configFile.createNewFile();
            this.LOGGER.debug("Create felix configuration ini file [" + configFile + "]");
            Configuration configuration = context.getConfiguration();
            os = new FileOutputStream(configFile);
            PropertiesWriter writer = new PropertiesWriter(os, SEPARATOR);
            this.writeHeader(writer);
            writer.append("#############################");
            writer.append(" Felix settings");
            writer.append("#############################");
            Integer startLevel = configuration.getStartLevel();
            if (startLevel != null) {
                writer.append(this.getFrameworkStartLevelPropertyName(), startLevel.toString());
            }
            if ((bundleStartLevel = configuration.getBundleStartLevel()) != null) {
                writer.append("felix.startlevel.bundle", bundleStartLevel.toString());
            }
            this.appendFrameworkStorage(context, writer);
            writer.append("org.osgi.framework.executionenvironment", context.getExecutionEnvironment());
            String bootDelegation = context.getConfiguration().getBootDelegation();
            if (bootDelegation != null) {
                writer.append("org.osgi.framework.bootdelegation", bootDelegation);
            }
            writer.append("org.osgi.framework.system.packages", context.getSystemPackages());
            if (bundles != null && bundles.size() > 0) {
                writer.append();
                writer.append("#############################");
                writer.append(" Client bundles to install");
                writer.append("#############################");
                this.appendBundles(writer, bundles, context, configuration.getBundleStartLevel());
            }
            writer.append();
            writer.append("#############################");
            writer.append(" System properties");
            writer.append("#############################");
            this.appendProperties(writer, context.getProperties());
            writer.write();
        }
        catch (IOException e) {
            throw new PlatformException("Could not create felix configuration file", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new PlatformException("Could not create felix configuration file", e);
                }
            }
        }
    }

    protected abstract void appendFrameworkStorage(PlatformContext var1, PropertiesWriter var2);

    private void appendProperties(PropertiesWriter writer, Properties properties) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                writer.append(key, properties.getProperty(key));
            }
        }
    }

    private void appendBundles(PropertiesWriter writer, List<BundleReference> bundles, PlatformContext context, Integer defaultStartlevel) throws MalformedURLException, PlatformException {
        for (BundleReference reference : bundles) {
            URL url = reference.getURL();
            if (url == null) {
                throw new PlatformException("The file from bundle to install cannot be null");
            }
            StringBuilder propertyName = new StringBuilder().append("felix.auto");
            Boolean shouldStart = reference.shouldStart();
            if (shouldStart != null && shouldStart.booleanValue()) {
                propertyName.append(".").append("start");
            } else {
                propertyName.append(".").append("install");
            }
            Integer startLevel = reference.getStartLevel();
            if (startLevel == null) {
                startLevel = defaultStartlevel;
            }
            if (startLevel != null) {
                propertyName.append(".").append(startLevel);
            }
            writer.append(propertyName.toString(), "\"" + context.getFilePathStrategy().normalizeAsUrl(url) + "\"");
        }
    }

    private void writeHeader(PropertiesWriter writer) {
        writer.append("###############################################");
        writer.append("              ______  ________  __  __        #");
        writer.append("             / __  / /  __   / / / / /        #");
        writer.append("            /  ___/ /  __   / _\\ \\ _/         #");
        writer.append("           /  /    /  / /  / / _\\ \\           #");
        writer.append("          /__/    /__/ /__/ /_/ /_/           #");
        writer.append("                                              #");
        writer.append(" Pax Runner from OPS4J - http://www.ops4j.org #");
        writer.append("###############################################");
        writer.append();
    }

    @Override
    public String getMainClassName() {
        return MAIN_CLASS_NAME;
    }

    @Override
    public String[] getArguments(PlatformContext context) {
        return null;
    }

    @Override
    public String[] getVMOptions(PlatformContext context) {
        NullArgumentException.validateNotNull(context, "Platform context");
        ArrayList<String> vmOptions = new ArrayList<String>();
        File workingDirectory = context.getWorkingDirectory();
        vmOptions.add("-Dfelix.config.properties=" + context.getFilePathStrategy().normalizeAsUrl(new File(new File(workingDirectory, "felix"), CONFIG_INI)));
        Properties frameworkProperties = context.getProperties();
        if (frameworkProperties != null) {
            Enumeration<?> enumeration = frameworkProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String property = frameworkProperties.getProperty(key);
                String quotedProperty = property.replace("\"", "\\\"");
                if (property.length() < quotedProperty.length() || property.indexOf(32) >= 0) {
                    property = '\"' + quotedProperty + '\"';
                }
                StringBuilder vmOption = new StringBuilder(2 + key.length() + 1 + property.length());
                vmOption.append("-D");
                vmOption.append(key);
                if (property.length() > 0) {
                    vmOption.append('=');
                    vmOption.append(property);
                }
                vmOptions.add(vmOption.toString());
            }
        }
        return vmOptions.toArray(new String[vmOptions.size()]);
    }

    @Override
    public InputStream getDefinition(Configuration configuration) throws IOException {
        String definitionFile = "META-INF/platform-felix/definition-" + this.m_version + ".xml";
        URL url = this.m_bundleContext.getBundle().getResource(definitionFile);
        if (url == null) {
            throw new FileNotFoundException(definitionFile + " could not be found");
        }
        return url.openStream();
    }

    @Override
    public String getRequiredProfile(PlatformContext context) {
        String profile = context.getConfiguration().getFrameworkProfile();
        if (profile != null && !"runner".equals(profile)) {
            return profile;
        }
        Boolean console = context.getConfiguration().startConsole();
        if (console == null || !console.booleanValue()) {
            return null;
        }
        return CONSOLE_PROFILE;
    }

    public String toString() {
        return "Felix " + this.m_version;
    }

    @Override
    public String getProviderName() {
        return "felix";
    }

    @Override
    public String getProviderVersion() {
        return this.m_version;
    }

    protected abstract String getFrameworkStartLevelPropertyName();
}

