/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.felix.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.ops4j.io.FileUtils;
import org.ops4j.pax.runner.platform.Configuration;
import org.ops4j.pax.runner.platform.PlatformContext;
import org.ops4j.pax.runner.platform.felix.internal.FelixPlatformBuilder;
import org.ops4j.util.collections.PropertiesWriter;
import org.osgi.framework.BundleContext;

public class FelixPlatformBuilderF100T122
extends FelixPlatformBuilder {
    public FelixPlatformBuilderF100T122(BundleContext bundleContext, String version) {
        super(bundleContext, version);
    }

    protected void appendFrameworkStorage(PlatformContext context, PropertiesWriter writer) {
        Configuration configuration = context.getConfiguration();
        String profile = configuration.getFrameworkProfile();
        if (profile != null) {
            writer.append("felix.cache.profile", profile);
            Boolean usePersistedState = configuration.usePersistedState();
            if (usePersistedState != null && !usePersistedState.booleanValue()) {
                File workingDirectory = context.getWorkingDirectory();
                File configDirectory = new File(workingDirectory, "felix");
                File cacheDirectory = new File(configDirectory, "cache");
                File profileDirectory = new File(cacheDirectory, profile);
                this.LOGGER.trace("Cleaning profile folder [" + profileDirectory + "]");
                FileUtils.delete(profileDirectory);
            }
        }
    }

    public String[] getVMOptions(PlatformContext context) {
        ArrayList<String> vmOptions = new ArrayList<String>(Arrays.asList(super.getVMOptions(context)));
        File workingDirectory = context.getWorkingDirectory();
        File configDirectory = new File(workingDirectory, "felix");
        File cacheDirectory = new File(configDirectory, "cache");
        vmOptions.add("-Dfelix.cache.dir=" + context.getFilePathStrategy().normalizeAsPath(cacheDirectory));
        return vmOptions.toArray(new String[vmOptions.size()]);
    }

    protected String getFrameworkStartLevelPropertyName() {
        return "felix.startlevel.framework";
    }
}

