/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.Configuration;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;

public class ConfigurationImpl
extends PropertyStore
implements Configuration {
    private static final Log LOGGER = LogFactory.getLog(ConfigurationImpl.class);
    private static final String DEFAULT_WORKING_DIRECTORY = "runner";
    private static final String DEFAULT_FRAMEWORK_PROFILE = "runner";
    private static final int DEFAULT_START_LEVEL = 6;
    private static final int DEFAULT_PROFILE_START_LEVEL = 1;
    private static final int DEFAULT_BUNDLE_START_LEVEL = 5;
    private final PropertyResolver m_propertyResolver;

    public ConfigurationImpl(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.m_propertyResolver = propertyResolver;
    }

    public URL getDefinitionURL() throws MalformedURLException {
        if (!this.contains("org.ops4j.pax.runner.platform.definitionURL")) {
            String urlSpec = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.definitionURL");
            URL url = null;
            if (urlSpec != null) {
                url = new URL(urlSpec);
            }
            return this.set("org.ops4j.pax.runner.platform.definitionURL", url);
        }
        return (URL)this.get("org.ops4j.pax.runner.platform.definitionURL");
    }

    public String getWorkingDirectory() {
        if (!this.contains("org.ops4j.pax.runner.platform.workingDirectory")) {
            String workDir = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.workingDirectory");
            if (workDir == null) {
                workDir = "runner";
            }
            return this.set("org.ops4j.pax.runner.platform.workingDirectory", workDir);
        }
        return (String)this.get("org.ops4j.pax.runner.platform.workingDirectory");
    }

    public String[] getVMOptions() {
        if (!this.contains("org.ops4j.pax.runner.platform.vmOptions")) {
            String vmOptions = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.vmOptions");
            if (vmOptions != null) {
                if (vmOptions.contains("-Dorg.osgi.framework.bootdelegation=")) {
                    LOGGER.warn("WARNING!: Setting boot delegation packages should be done via --bootDelegation/bd option not by using org.osgi.framework.bootdelegation system variable");
                }
                if (vmOptions.contains("-cp")) {
                    LOGGER.warn("WARNING!: Setting class path should be done via --classpath/cp option not by using -cp as vm option");
                }
                ArrayList<String> options = new ArrayList<String>();
                for (String option : vmOptions.split(" ")) {
                    if (option.trim().length() <= 0) continue;
                    options.add(option);
                }
                if (options.size() > 0) {
                    return this.set("org.ops4j.pax.runner.platform.vmOptions", options.toArray(new String[options.size()]));
                }
                return this.set("org.ops4j.pax.runner.platform.vmOptions", null);
            }
            return this.set("org.ops4j.pax.runner.platform.vmOptions", null);
        }
        return (String[])this.get("org.ops4j.pax.runner.platform.vmOptions");
    }

    public String[] getEnvOptions() {
        String envOptions;
        if (!this.contains("org.ops4j.pax.runner.platform.envOptions") && (envOptions = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.envOptions")) != null) {
            ArrayList<String> options = new ArrayList<String>();
            for (String option : envOptions.split(",")) {
                if (option.trim().length() <= 0) continue;
                options.add(option);
            }
            if (options.size() > 0) {
                return this.set("org.ops4j.pax.runner.platform.envOptions", options.toArray(new String[options.size()]));
            }
            return this.set("org.ops4j.pax.runner.platform.envOptions", new String[0]);
        }
        return (String[])this.get("org.ops4j.pax.runner.platform.envOptions");
    }

    public String getClasspath() {
        if (!this.contains("org.ops4j.pax.runner.platform.classpath")) {
            String classpath = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.classpath");
            if (classpath == null) {
                classpath = "";
            } else if (!classpath.startsWith(File.pathSeparator)) {
                classpath = File.pathSeparator + classpath;
            }
            return this.set("org.ops4j.pax.runner.platform.classpath", classpath);
        }
        return (String)this.get("org.ops4j.pax.runner.platform.classpath");
    }

    public String getSystemPackages() {
        if (!this.contains("org.ops4j.pax.runner.platform.systemPackages")) {
            return this.set("org.ops4j.pax.runner.platform.systemPackages", this.m_propertyResolver.get("org.ops4j.pax.runner.platform.systemPackages"));
        }
        return (String)this.get("org.ops4j.pax.runner.platform.systemPackages");
    }

    public String getExecutionEnvironment() {
        if (!this.contains("org.ops4j.pax.runner.platform.ee")) {
            String javaVersion = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.ee");
            if (javaVersion == null) {
                javaVersion = "J2SE-" + System.getProperty("java.version").substring(0, 3);
            }
            return this.set("org.ops4j.pax.runner.platform.ee", javaVersion);
        }
        return (String)this.get("org.ops4j.pax.runner.platform.ee");
    }

    public String getJavaHome() {
        if (!this.contains("org.ops4j.pax.runner.platform.javaHome")) {
            String javaHome = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.javaHome");
            if (javaHome == null && (javaHome = System.getProperty("JAVA_HOME")) == null) {
                try {
                    javaHome = System.getenv("JAVA_HOME");
                }
                catch (Error error) {
                    // empty catch block
                }
                if (javaHome == null) {
                    javaHome = System.getProperty("java.home");
                }
            }
            return this.set("org.ops4j.pax.runner.platform.javaHome", javaHome);
        }
        return (String)this.get("org.ops4j.pax.runner.platform.javaHome");
    }

    public Boolean usePersistedState() {
        if (!this.contains("org.ops4j.pax.runner.platform.usePersistedState")) {
            String usePersistedState = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.usePersistedState");
            if (usePersistedState == null) {
                return this.set("org.ops4j.pax.runner.platform.usePersistedState", Boolean.FALSE);
            }
            return this.set("org.ops4j.pax.runner.platform.usePersistedState", Boolean.valueOf(usePersistedState));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.usePersistedState");
    }

    public Boolean startConsole() {
        if (!this.contains("org.ops4j.pax.runner.platform.console")) {
            String console = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.console");
            if (console == null) {
                return this.set("org.ops4j.pax.runner.platform.console", Boolean.TRUE);
            }
            return this.set("org.ops4j.pax.runner.platform.console", Boolean.valueOf(console));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.console");
    }

    public Boolean isOverwrite() {
        if (!this.contains("org.ops4j.pax.runner.platform.overwrite")) {
            return this.set("org.ops4j.pax.runner.platform.overwrite", Boolean.valueOf(this.m_propertyResolver.get("org.ops4j.pax.runner.platform.overwrite")));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.overwrite");
    }

    public String getProfiles() {
        if (!this.contains("org.ops4j.pax.runner.platform.profiles")) {
            return this.set("org.ops4j.pax.runner.platform.profiles", this.m_propertyResolver.get("org.ops4j.pax.runner.platform.profiles"));
        }
        return (String)this.get("org.ops4j.pax.runner.platform.profiles");
    }

    public String getFrameworkProfile() {
        if (!this.contains("org.ops4j.pax.runner.platform.frameworkProfile")) {
            String profile = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.frameworkProfile");
            if (profile == null) {
                profile = "runner";
            }
            return this.set("org.ops4j.pax.runner.platform.frameworkProfile", profile);
        }
        return (String)this.get("org.ops4j.pax.runner.platform.frameworkProfile");
    }

    public Integer getProfileStartLevel() {
        return this.resolveStartLevel("org.ops4j.pax.runner.platform.profileStartLevel", 1);
    }

    public Integer getStartLevel() {
        return this.resolveStartLevel("org.ops4j.pax.runner.platform.startLevel", 6);
    }

    public Integer getBundleStartLevel() {
        return this.resolveStartLevel("org.ops4j.pax.runner.platform.bundleStartLevel", 5);
    }

    private Integer resolveStartLevel(String optionName, Integer defaultValue) {
        if (!this.contains(optionName)) {
            String startLevel = this.m_propertyResolver.get(optionName);
            Integer startLevelAsInt = defaultValue;
            if (startLevel != null) {
                try {
                    startLevelAsInt = Integer.valueOf(startLevel);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            return this.set(optionName, startLevelAsInt);
        }
        return (Integer)this.get(optionName);
    }

    public Boolean isOverwriteUserBundles() {
        if (!this.contains("org.ops4j.pax.runner.platform.overwriteUserBundles")) {
            return this.set("org.ops4j.pax.runner.platform.overwriteUserBundles", Boolean.valueOf(this.m_propertyResolver.get("org.ops4j.pax.runner.platform.overwriteUserBundles")));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.overwriteUserBundles");
    }

    public Boolean isOverwriteSystemBundles() {
        if (!this.contains("org.ops4j.pax.runner.platform.overwriteSystemBundles")) {
            return this.set("org.ops4j.pax.runner.platform.overwriteSystemBundles", Boolean.valueOf(this.m_propertyResolver.get("org.ops4j.pax.runner.platform.overwriteSystemBundles")));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.overwriteSystemBundles");
    }

    public Boolean isDebugClassLoading() {
        if (!this.contains("org.ops4j.pax.runner.platform.debugClassLoading")) {
            return this.set("org.ops4j.pax.runner.platform.debugClassLoading", Boolean.valueOf(this.m_propertyResolver.get("org.ops4j.pax.runner.platform.debugClassLoading")));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.debugClassLoading");
    }

    public Boolean isDownloadFeedback() {
        if (!this.contains("org.ops4j.pax.runner.platform.downloadFeedback")) {
            String downloadFeedback = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.downloadFeedback");
            if (downloadFeedback == null) {
                downloadFeedback = Boolean.TRUE.toString();
            }
            return this.set("org.ops4j.pax.runner.platform.downloadFeedback", Boolean.valueOf(downloadFeedback));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.overwriteSystemBundles");
    }

    public String getBootDelegation() {
        if (!this.contains("org.ops4j.pax.runner.platform.bootDelegation")) {
            String bootDelegation = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.bootDelegation");
            if (bootDelegation != null) {
                if ((bootDelegation = bootDelegation.trim()).endsWith(",")) {
                    bootDelegation = bootDelegation.substring(0, bootDelegation.length() - 1);
                }
                if (bootDelegation.length() == 0) {
                    bootDelegation = null;
                }
            }
            return this.set("org.ops4j.pax.runner.platform.bootDelegation", bootDelegation);
        }
        return (String)this.get("org.ops4j.pax.runner.platform.bootDelegation");
    }

    public Boolean isAutoWrap() {
        if (!this.contains("org.ops4j.pax.runner.platform.autoWrap")) {
            return this.set("org.ops4j.pax.runner.platform.autoWrap", Boolean.valueOf(this.m_propertyResolver.get("org.ops4j.pax.runner.platform.autoWrap")));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.autoWrap");
    }

    public Boolean keepOriginalUrls() {
        if (!this.contains("org.ops4j.pax.runner.platform.keepOriginalUrls")) {
            return this.set("org.ops4j.pax.runner.platform.keepOriginalUrls", Boolean.valueOf(this.m_propertyResolver.get("org.ops4j.pax.runner.platform.keepOriginalUrls")));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.keepOriginalUrls");
    }

    public Boolean validateBundles() {
        if (!this.contains("org.ops4j.pax.runner.platform.bundleValidation")) {
            String validateBundles = this.m_propertyResolver.get("org.ops4j.pax.runner.platform.bundleValidation");
            if (validateBundles == null) {
                return this.set("org.ops4j.pax.runner.platform.bundleValidation", Boolean.TRUE);
            }
            return this.set("org.ops4j.pax.runner.platform.bundleValidation", Boolean.valueOf(validateBundles));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.bundleValidation");
    }

    public Boolean skipInvalidBundles() {
        if (!this.contains("org.ops4j.pax.runner.platform.skipInvalidBundles")) {
            return this.set("org.ops4j.pax.runner.platform.skipInvalidBundles", Boolean.valueOf(this.m_propertyResolver.get("org.ops4j.pax.runner.platform.skipInvalidBundles")));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.skipInvalidBundles");
    }

    public Boolean useAbsoluteFilePaths() {
        if (!this.contains("org.ops4j.pax.runner.platform.useAbsoluteFilePaths")) {
            return this.set("org.ops4j.pax.runner.platform.useAbsoluteFilePaths", Boolean.valueOf(this.m_propertyResolver.get("org.ops4j.pax.runner.platform.useAbsoluteFilePaths")));
        }
        return (Boolean)this.get("org.ops4j.pax.runner.platform.useAbsoluteFilePaths");
    }

    public String getProperty(String name) {
        return this.m_propertyResolver.get(name);
    }
}

