/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.assembly.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.assembly.internal.Resource;

class FileResource
implements Resource {
    private final File m_parent;
    private final File m_file;

    FileResource(File parent, File file) {
        NullArgumentException.validateNotNull(parent, "Resource parent");
        NullArgumentException.validateNotNull(file, "Resource file");
        try {
            if (!file.getCanonicalPath().startsWith(parent.getCanonicalPath())) {
                throw new IllegalArgumentException(String.format("Specified parent [%s] is not a parent of file [%s]", parent.getPath(), file.getPath()));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Validation failed due to exception", e);
        }
        this.m_parent = parent;
        this.m_file = file;
    }

    public String path() {
        try {
            return this.m_file.getCanonicalPath().substring(this.m_parent.getCanonicalPath().length() + 1).replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot determine path for file [%s]", this.m_file.getPath()), e);
        }
    }

    public URL url() {
        try {
            return this.m_file.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Cannot convert file [%s] to an url", this.m_file.getPath()), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource that = (Resource)o;
        return this.path().equals(that.path());
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    public String toString() {
        return this.path();
    }
}

