/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.unittest.mocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.unittest.mocks.ReturnTypeHandler;
import org.apache.aries.unittest.mocks.Skeleton;

public class DefaultReturnTypeHandlers {
    public static final ReturnTypeHandler LONG_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return 0L;
        }
    };
    public static final ReturnTypeHandler INT_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return 0;
        }
    };
    public static final ReturnTypeHandler SHORT_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return (short)0;
        }
    };
    public static final ReturnTypeHandler BYTE_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return (byte)0;
        }
    };
    public static final ReturnTypeHandler CHAR_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return Character.valueOf(' ');
        }
    };
    public static final ReturnTypeHandler STRING_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return "";
        }
    };
    public static final ReturnTypeHandler LIST_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return new ArrayList();
        }
    };
    public static final ReturnTypeHandler MAP_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return new HashMap();
        }
    };
    public static final ReturnTypeHandler SET_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return new HashSet();
        }
    };
    public static final ReturnTypeHandler FLOAT_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return new Float(0.0f);
        }
    };
    public static final ReturnTypeHandler DOUBLE_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return new Double(0.0);
        }
    };
    public static final ReturnTypeHandler BOOLEAN_HANDLER = new ReturnTypeHandler(){

        @Override
        public Object handle(Class<?> class1, Skeleton parent) {
            return Boolean.FALSE;
        }
    };

    public static void registerDefaultHandlers(Skeleton s) {
        s.registerReturnTypeHandler(Double.class, DOUBLE_HANDLER);
        s.registerReturnTypeHandler(Float.class, FLOAT_HANDLER);
        s.registerReturnTypeHandler(Long.class, LONG_HANDLER);
        s.registerReturnTypeHandler(Integer.class, INT_HANDLER);
        s.registerReturnTypeHandler(Short.class, SHORT_HANDLER);
        s.registerReturnTypeHandler(Byte.class, BYTE_HANDLER);
        s.registerReturnTypeHandler(Boolean.class, BOOLEAN_HANDLER);
        s.registerReturnTypeHandler(Character.class, CHAR_HANDLER);
        s.registerReturnTypeHandler(String.class, STRING_HANDLER);
        s.registerReturnTypeHandler(List.class, LIST_HANDLER);
        s.registerReturnTypeHandler(Map.class, MAP_HANDLER);
        s.registerReturnTypeHandler(Set.class, SET_HANDLER);
        s.registerReturnTypeHandler(Double.TYPE, DOUBLE_HANDLER);
        s.registerReturnTypeHandler(Float.TYPE, FLOAT_HANDLER);
        s.registerReturnTypeHandler(Long.TYPE, LONG_HANDLER);
        s.registerReturnTypeHandler(Integer.TYPE, INT_HANDLER);
        s.registerReturnTypeHandler(Short.TYPE, SHORT_HANDLER);
        s.registerReturnTypeHandler(Byte.TYPE, BYTE_HANDLER);
        s.registerReturnTypeHandler(Character.TYPE, CHAR_HANDLER);
        s.registerReturnTypeHandler(Boolean.TYPE, BOOLEAN_HANDLER);
    }
}

