/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditedProperties
extends Properties {
    private static final Log LOGGER = LogFactory.getLog(AuditedProperties.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(.*?\\$\\{)([.[^\\$]]+?)(\\}.*)");
    final Properties m_defaults;

    public AuditedProperties(Properties defaults) {
        this.m_defaults = defaults != null ? defaults : new Properties();
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = super.getProperty(key);
        if (value == null) {
            value = this.m_defaults.getProperty(key, defaultValue);
        }
        return value;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        String replaced = this.replacePlaceholders(value);
        LOGGER.trace("Setting system property [" + key + "=" + replaced + "]");
        return super.setProperty(key, replaced);
    }

    private String replacePlaceholders(String value) {
        String replaced = value;
        String rest = value;
        while (rest != null && rest.length() != 0) {
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(rest);
            if (matcher.matches() && matcher.groupCount() == 3) {
                String placeholderName = matcher.group(2);
                String placeholderValue = this.getProperty(placeholderName);
                if (placeholderValue != null) {
                    replaced = replaced.replace("${" + placeholderName + "}", placeholderValue);
                }
                rest = matcher.group(3);
                continue;
            }
            rest = null;
        }
        if (replaced != null && !replaced.equals(value)) {
            replaced = this.replacePlaceholders(replaced);
        }
        return replaced;
    }
}

