/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.handler.internal;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.handler.internal.Activator;
import org.ops4j.pax.runner.handler.internal.URLStreamHandlerProxy;
import org.ops4j.pax.runner.handler.internal.URLUtils;
import org.osgi.service.url.URLStreamHandlerService;

public class URLStreamHandlerExtender
implements URLStreamHandlerFactory {
    private static final Log LOGGER = LogFactory.getLog(Activator.class);
    private final Map<String, URLStreamHandlerProxy> m_proxies = new HashMap<String, URLStreamHandlerProxy>();

    public void start() {
        URLUtils.setURLStreamHandlerFactory(this);
    }

    public void register(String[] protocols, URLStreamHandlerService urlStreamHandlerService) {
        LOGGER.debug("Registering protocols [" + Arrays.toString(protocols) + "] to service [" + urlStreamHandlerService + "]");
        NullArgumentException.validateNotEmptyContent(protocols, true, "Protocol");
        NullArgumentException.validateNotNull(urlStreamHandlerService, "URL stream handler service");
        for (String protocol : protocols) {
            this.m_proxies.put(protocol, this.createProxy(urlStreamHandlerService));
        }
    }

    public void unregister(String[] protocols) {
        LOGGER.debug("Unregistering protocols [" + Arrays.toString(protocols) + "]");
        NullArgumentException.validateNotEmptyContent(protocols, true, "Protocols");
        for (String protocol : protocols) {
            this.m_proxies.remove(protocol);
        }
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        NullArgumentException.validateNotEmpty(protocol, true, "Protocol");
        return this.m_proxies.get(protocol);
    }

    URLStreamHandlerProxy createProxy(URLStreamHandlerService urlStreamHandlerService) {
        return new URLStreamHandlerProxy(urlStreamHandlerService);
    }
}

