/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.osgi;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.osgi.UnsupportedBundle;
import org.osgi.framework.BundleException;

public class RunnerBundle
extends UnsupportedBundle {
    private static final Log LOGGER = LogFactory.getLog(RunnerBundle.class);
    private URL m_location;
    private boolean m_shouldStart;
    private Integer m_startLevel;
    private boolean m_shouldUpdate;

    public RunnerBundle() {
        this.m_location = null;
        this.m_shouldStart = false;
        this.m_shouldUpdate = false;
    }

    public RunnerBundle(URL location) {
        LOGGER.debug("Installed bundle [" + location + "]");
        this.m_location = location;
    }

    @Override
    public int getState() {
        return 32;
    }

    @Override
    public void start() throws BundleException {
        LOGGER.debug("Bundle [" + this.m_location + "] will be started");
        this.m_shouldStart = true;
    }

    public boolean shouldStart() {
        return this.m_shouldStart;
    }

    public void setStartLevel(Integer startLevel) {
        LOGGER.debug("Bundle [" + this.m_location + "] will start at level [" + startLevel + "]");
        this.m_startLevel = startLevel;
    }

    public Integer getStartLevel() {
        return this.m_startLevel;
    }

    @Override
    public void update() {
        LOGGER.debug("Bundle [" + this.m_location + "] will be updated");
        this.m_shouldUpdate = true;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    public boolean shouldUpdate() {
        return this.m_shouldUpdate;
    }

    public URL getLocationAsURL() {
        return this.m_location;
    }

    @Override
    public URL getResource(String name) {
        return this.getClass().getClassLoader().getResource(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_location);
        if (this.m_startLevel != null) {
            sb.append(", at start level ").append(this.m_startLevel);
        } else {
            sb.append(", at default start level");
        }
        sb.append(this.m_shouldStart ? ", bundle will be started" : ", bundle will not be started");
        sb.append(this.m_shouldUpdate ? ", bundle will be re-downloaded" : ", bundle will be loaded from the cache");
        return sb.toString();
    }
}

