/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.commons.Info;
import org.ops4j.pax.runner.handler.internal.URLUtils;
import org.ops4j.pax.runner.platform.JavaRunner;
import org.ops4j.pax.runner.platform.PlatformException;

public class InProcessJavaRunner
implements JavaRunner {
    private static final Log LOG = LogFactory.getLog(InProcessJavaRunner.class);
    private boolean m_frameworkActive = false;

    @Override
    public void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDir, String[] environmentVariables) throws PlatformException {
        if (environmentVariables != null && environmentVariables.length != 0) {
            throw new PlatformException("Rethink what you are doing: trying to change process environment (setting env variables) and use Pax Runner with inProcess?");
        }
        this.exec(vmOptions, classpath, mainClass, programOptions, javaHome, workingDir);
    }

    @Override
    public synchronized void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDirectory) throws PlatformException {
        if (this.m_frameworkActive) {
            throw new PlatformException("Platform already started");
        }
        this.m_frameworkActive = true;
        URLClassLoader classLoader = InProcessJavaRunner.createClassLoader(classpath);
        Properties systemProps = InProcessJavaRunner.extractSystemProperties(vmOptions);
        ClassLoader tcclBackup = Thread.currentThread().getContextClassLoader();
        Properties systemPropsBackup = System.getProperties();
        URLStreamHandlerFactory handlerFactoryBackup = URLUtils.resetURLStreamHandlerFactory();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            System.setProperties(systemProps);
            Class<?> clazz = classLoader.loadClass(mainClass);
            Method mainMethod = clazz.getMethod("main", String[].class);
            LOG.info("Runner has successfully finished his job!");
            Info.println();
            mainMethod.invoke(null, new Object[]{programOptions});
        }
        catch (ClassNotFoundException e) {
            throw new PlatformException("Cannot find target framework main class", e);
        }
        catch (NoSuchMethodException e) {
            throw new PlatformException("Cannot find target framework main method", e);
        }
        catch (IllegalAccessException e) {
            throw new PlatformException("Cannot run the target framework", e);
        }
        catch (InvocationTargetException e) {
            throw new PlatformException("Cannot run the target framework", e);
        }
        finally {
            URLUtils.setURLStreamHandlerFactory(handlerFactoryBackup);
            System.setProperties(systemPropsBackup);
            Thread.currentThread().setContextClassLoader(tcclBackup);
        }
    }

    private static URLClassLoader createClassLoader(String[] classpath) throws PlatformException {
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        if (classpath != null) {
            for (String path : classpath) {
                try {
                    classpathUrls.add(new File(path).toURL());
                }
                catch (MalformedURLException e) {
                    throw new PlatformException("Cannot setup target framework classpath", e);
                }
            }
        }
        return new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), InProcessJavaRunner.class.getClassLoader().getParent());
    }

    private static Properties extractSystemProperties(String[] vmOptions) {
        Properties systemProps = new Properties();
        systemProps.putAll((Map<?, ?>)System.getProperties());
        for (String vmOption : vmOptions) {
            if (vmOption.startsWith("-D") && vmOption.length() > 3 && vmOption.contains("=")) {
                String[] segments = vmOption.substring(2).split("=");
                systemProps.setProperty(segments[0], segments[1]);
                continue;
            }
            LOG.warn("VM option [" + vmOption + "] cannot be used");
        }
        return systemProps;
    }
}

