/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.concierge.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.BundleReference;
import org.ops4j.pax.runner.platform.Configuration;
import org.ops4j.pax.runner.platform.PlatformBuilder;
import org.ops4j.pax.runner.platform.PlatformContext;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.util.collections.PropertiesWriter;
import org.osgi.framework.BundleContext;

public class ConciergePlatformBuilder
implements PlatformBuilder {
    private static final Log LOGGER = LogFactory.getLog(ConciergePlatformBuilder.class);
    private static final String PROVIDER_NAME = "concierge";
    private static final String MAIN_CLASS_NAME = "ch.ethz.iks.concierge.framework.Framework";
    private static final String CONFIG_DIRECTORY = "concierge";
    private static final String CONFIG_INI = "config.ini";
    private static final String CONSOLE_PROFILE = "tui";
    private final BundleContext m_bundleContext;
    private final String m_version;

    public ConciergePlatformBuilder(BundleContext bundleContext, String version) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        NullArgumentException.validateNotNull(version, "Version");
        this.m_bundleContext = bundleContext;
        this.m_version = version;
    }

    @Override
    public void prepare(PlatformContext context) throws PlatformException {
        NullArgumentException.validateNotNull(context, "Platform context");
        List<BundleReference> bundles = context.getBundles();
        OutputStream os = null;
        try {
            Integer startLevel;
            File workingDirectory = context.getWorkingDirectory();
            File configDirectory = new File(workingDirectory, "concierge");
            configDirectory.mkdirs();
            File configFile = new File(configDirectory, CONFIG_INI);
            configFile.createNewFile();
            LOGGER.debug("Create concierge configuration ini file [" + configFile + "]");
            Configuration configuration = context.getConfiguration();
            os = new FileOutputStream(configFile);
            PropertiesWriter writer = new PropertiesWriter(os);
            this.writeHeader(writer);
            writer.append("#############################");
            writer.append(" Concierge settings");
            writer.append("#############################");
            writer.append("-Dorg.osgi.framework.system.packages", context.getSystemPackages()).append("-Dch.ethz.iks.concierge.basedir", context.getFilePathStrategy().normalizeAsPath(configDirectory));
            Boolean usePersistedState = configuration.usePersistedState();
            if (usePersistedState != null && !usePersistedState.booleanValue()) {
                writer.appendRaw("-init");
            }
            if ((startLevel = configuration.getStartLevel()) != null) {
                writer.appendRaw("-startlevel " + startLevel.toString());
            }
            Integer bundleStartLevel = configuration.getBundleStartLevel();
            if (bundles != null && bundles.size() > 0) {
                writer.append();
                writer.append("#############################");
                writer.append(" Client bundles to install");
                writer.append("#############################");
                this.appendBundles(writer, bundles, context, bundleStartLevel);
            }
            writer.append();
            writer.append("#############################");
            writer.append(" System properties");
            writer.append("#############################");
            this.appendProperties(writer, context.getProperties());
            writer.write();
        }
        catch (IOException e) {
            throw new PlatformException("Could not create concierge configuration file", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new PlatformException("Could not create concierge configuration file", e);
                }
            }
        }
    }

    private void appendProperties(PropertiesWriter writer, Properties properties) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                writer.append("-D" + key, properties.getProperty(key));
            }
        }
    }

    private void appendBundles(PropertiesWriter writer, List<BundleReference> bundles, PlatformContext context, Integer defaultStartlevel) throws MalformedURLException, PlatformException {
        Hashtable<Integer, ArrayList<String>> bundlesPerStartlevel = new Hashtable<Integer, ArrayList<String>>();
        for (BundleReference bundleReference : bundles) {
            ArrayList<String> bundlesAsStrings;
            Integer startLevel;
            URL bundleFile = bundleReference.getURL();
            if (bundleFile == null) {
                throw new PlatformException("The file from bundle to install cannot be null");
            }
            String propertyName = "-install ";
            Boolean shouldStart = bundleReference.shouldStart();
            if (shouldStart != null && shouldStart.booleanValue()) {
                propertyName = "-istart ";
            }
            if ((startLevel = bundleReference.getStartLevel()) == null) {
                startLevel = defaultStartlevel;
            }
            if ((bundlesAsStrings = (ArrayList<String>)bundlesPerStartlevel.get(startLevel)) == null) {
                bundlesAsStrings = new ArrayList<String>();
                bundlesPerStartlevel.put(startLevel, bundlesAsStrings);
            }
            bundlesAsStrings.add(propertyName + context.getFilePathStrategy().normalizeAsUrl(bundleFile));
        }
        for (Map.Entry entry : bundlesPerStartlevel.entrySet()) {
            writer.appendRaw("-initlevel " + ((Integer)entry.getKey()).toString());
            for (String bundle : (List)entry.getValue()) {
                writer.appendRaw(bundle);
            }
        }
    }

    private void writeHeader(PropertiesWriter writer) {
        writer.append("###############################################");
        writer.append("              ______  ________  __  __        #");
        writer.append("             / __  / /  __   / / / / /        #");
        writer.append("            /  ___/ /  __   / _\\ \\ _/         #");
        writer.append("           /  /    /  / /  / / _\\ \\           #");
        writer.append("          /__/    /__/ /__/ /_/ /_/           #");
        writer.append("                                              #");
        writer.append(" Pax Runner from OPS4J - http://www.ops4j.org #");
        writer.append("###############################################");
        writer.append();
    }

    @Override
    public String getMainClassName() {
        return MAIN_CLASS_NAME;
    }

    @Override
    public String[] getArguments(PlatformContext context) {
        return null;
    }

    @Override
    public String[] getVMOptions(PlatformContext context) {
        NullArgumentException.validateNotNull(context, "Platform context");
        ArrayList<String> vmOptions = new ArrayList<String>();
        File workingDirectory = context.getWorkingDirectory();
        vmOptions.add("-Dosgi.maxLevel=100");
        vmOptions.add("-Dxargs=" + context.getFilePathStrategy().normalizeAsPath(new File(new File(workingDirectory, "concierge"), CONFIG_INI)));
        String bootDelegation = context.getConfiguration().getBootDelegation();
        if (bootDelegation != null) {
            vmOptions.add("-Dorg.osgi.framework.bootdelegation=" + bootDelegation);
        }
        return vmOptions.toArray(new String[vmOptions.size()]);
    }

    @Override
    public InputStream getDefinition(Configuration configuration) throws IOException {
        String definitionFile = "META-INF/platform-concierge/definition-" + this.m_version + ".xml";
        URL url = this.m_bundleContext.getBundle().getResource(definitionFile);
        if (url == null) {
            throw new FileNotFoundException(definitionFile + " could not be found");
        }
        return url.openStream();
    }

    @Override
    public String getRequiredProfile(PlatformContext context) {
        Boolean console = context.getConfiguration().startConsole();
        if (console == null || !console.booleanValue()) {
            return null;
        }
        return CONSOLE_PROFILE;
    }

    public String toString() {
        return "Concierge " + this.m_version;
    }

    @Override
    public String getProviderName() {
        return "concierge";
    }

    @Override
    public String getProviderVersion() {
        return this.m_version;
    }
}

