/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.internal;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.Platform;
import org.ops4j.pax.runner.platform.PlatformBuilder;
import org.ops4j.pax.runner.platform.internal.PlatformImpl;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Log LOGGER = LogFactory.getLog(Activator.class);
    private BundleContext m_bundleContext;
    private ServiceTracker m_serviceTracker;
    private Map<ServiceReference, ServiceRegistration> m_registrations;
    private Map<ServiceReference, PlatformImpl> m_platforms;
    private ServiceRegistration m_managedServiceReg;
    private Dictionary m_config;
    private Lock m_lock = new ReentrantLock();

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        this.m_bundleContext = bundleContext;
        this.m_registrations = new HashMap<ServiceReference, ServiceRegistration>();
        this.m_platforms = Collections.synchronizedMap(new HashMap());
        this.trackPlatformBuilders();
        this.registerManagedService();
        LOGGER.debug("Platform extender started");
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        if (this.m_serviceTracker != null) {
            this.m_serviceTracker.close();
            this.m_serviceTracker = null;
        }
        if (this.m_registrations != null) {
            for (ServiceRegistration registration : this.m_registrations.values()) {
                if (registration == null) continue;
                registration.unregister();
            }
        }
        if (this.m_managedServiceReg != null) {
            this.m_managedServiceReg.unregister();
        }
        this.m_platforms = null;
        this.m_bundleContext = null;
        LOGGER.debug("Platform extender stopped");
    }

    private void trackPlatformBuilders() {
        this.m_serviceTracker = new ServiceTracker(this.m_bundleContext, PlatformBuilder.class.getName(), null){

            @Override
            public Object addingService(ServiceReference serviceReference) {
                NullArgumentException.validateNotNull(serviceReference, "Service reference");
                LOGGER.debug("Platform builder available [" + serviceReference + "]");
                PlatformBuilder platformBuilder = (PlatformBuilder)super.addingService(serviceReference);
                if (platformBuilder != null) {
                    LOGGER.debug("Registering a platform for [" + platformBuilder + "]");
                    Hashtable<String, Object> props = new Hashtable<String, Object>();
                    String[] keys = serviceReference.getPropertyKeys();
                    if (keys != null) {
                        for (String key : keys) {
                            ((Dictionary)props).put(key, serviceReference.getProperty(key));
                        }
                    }
                    try {
                        Platform platform = Activator.this.createPlatform(platformBuilder);
                        ServiceRegistration registration = Activator.this.m_bundleContext.registerService(Platform.class.getName(), (Object)platform, props);
                        Activator.this.m_registrations.put(serviceReference, registration);
                        if (platform instanceof PlatformImpl) {
                            Activator.this.m_platforms.put(serviceReference, (PlatformImpl)platform);
                        }
                        LOGGER.debug("Registred platform [" + platform + "]");
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not register a platform for [" + serviceReference + "]", e);
                    }
                }
                return platformBuilder;
            }

            @Override
            public void removedService(ServiceReference serviceReference, Object object) {
                LOGGER.debug("Platform builder removed [" + serviceReference + "]");
                if (!(object instanceof PlatformBuilder)) {
                    throw new IllegalArgumentException("Invalid tracked object [" + object.getClass() + "]. Expected an " + PlatformBuilder.class.getName());
                }
                super.removedService(serviceReference, object);
                ServiceRegistration registration = (ServiceRegistration)Activator.this.m_registrations.get(serviceReference);
                if (registration != null) {
                    registration.unregister();
                    Activator.this.m_registrations.remove(serviceReference);
                    LOGGER.debug("Unregistred platform for [" + object + "]");
                }
                Activator.this.m_platforms.remove(serviceReference);
            }
        };
        this.m_serviceTracker.open();
    }

    private void registerManagedService() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.ops4j.pax.runner.platform");
        this.m_managedServiceReg = this.m_bundleContext.registerService(ManagedService.class.getName(), (Object)new ManagedService(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updated(Dictionary config) throws ConfigurationException {
                Activator.this.m_lock.lock();
                try {
                    Activator.this.m_config = config;
                    for (PlatformImpl platform : Activator.this.m_platforms.values()) {
                        if (Activator.this.m_config == null) {
                            platform.setResolver(new BundleContextPropertyResolver(Activator.this.m_bundleContext));
                            continue;
                        }
                        platform.setResolver(new DictionaryPropertyResolver(config, new BundleContextPropertyResolver(Activator.this.m_bundleContext)));
                    }
                }
                finally {
                    Activator.this.m_lock.unlock();
                }
            }
        }, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Platform createPlatform(PlatformBuilder platformBuilder) {
        PlatformImpl platform = new PlatformImpl(platformBuilder);
        this.m_lock.lock();
        try {
            if (this.m_config == null) {
                platform.setResolver(new BundleContextPropertyResolver(this.m_bundleContext));
            } else {
                platform.setResolver(new DictionaryPropertyResolver(this.m_config, new BundleContextPropertyResolver(this.m_bundleContext)));
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return platform;
    }
}

