/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.platform.FilePathStrategy;

public class RelativeFilePathStrategy
implements FilePathStrategy {
    private static Log LOG = LogFactory.getLog(RelativeFilePathStrategy.class);
    private final File m_baseDirectory;

    public RelativeFilePathStrategy(File baseDirectory) {
        this.m_baseDirectory = baseDirectory;
    }

    @Override
    public String normalizeAsPath(File file) {
        return this.normalizePath(this.m_baseDirectory, file);
    }

    @Override
    public String normalizeAsUrl(File file) {
        return "file:" + this.normalizePath(this.m_baseDirectory, file);
    }

    @Override
    public String normalizeAsUrl(URL url) {
        if ("file".equals(url.getProtocol())) {
            return "file:" + this.normalizePath(this.m_baseDirectory, new File(url.getFile()));
        }
        return url.toExternalForm();
    }

    private String normalizePath(File baseFolder, File file) {
        String out = file.getAbsolutePath();
        try {
            if (baseFolder.equals(file)) {
                out = ".";
            } else {
                String s1 = baseFolder.getCanonicalPath();
                String s2 = file.getCanonicalPath();
                out = s2.startsWith(s1) ? s2.substring(s1.length() + 1) : s2;
            }
        }
        catch (IOException e) {
            LOG.warn("problem during normalizing path.", e);
        }
        return out.replace(File.separatorChar, '/');
    }
}

