/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.bundle.internal;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.pax.scanner.ScannedBundle;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.scanner.ScannerException;
import org.ops4j.pax.scanner.common.ScannedFileBundle;
import org.ops4j.pax.scanner.common.ScannerConfiguration;
import org.ops4j.pax.scanner.common.ScannerConfigurationImpl;
import org.ops4j.util.property.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleScanner
implements Scanner {
    private static final Log LOGGER = LogFactory.getLog(BundleScanner.class);
    private PropertyResolver m_propertyResolver;

    public BundleScanner(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    @Override
    public List<ScannedBundle> scan(ProvisionSpec provisionSpec) throws MalformedSpecificationException, ScannerException {
        NullArgumentException.validateNotNull(provisionSpec, "Provision spec");
        LOGGER.debug("Scanning [" + provisionSpec.getPath() + "]");
        ArrayList<ScannedBundle> scannedBundles = new ArrayList<ScannedBundle>();
        ScannerConfiguration config = this.createConfiguration();
        try {
            ScannedFileBundle scannedFileBundle = new ScannedFileBundle(provisionSpec.getPath(), this.getDefaultStartLevel(provisionSpec, config), this.getDefaultStart(provisionSpec, config), this.getDefaultUpdate(provisionSpec, config));
            scannedBundles.add(scannedFileBundle);
            LOGGER.debug("Installing bundle [" + scannedFileBundle + "]");
        }
        catch (MalformedURLException e) {
            throw new MalformedSpecificationException("Invalid url", e);
        }
        return scannedBundles;
    }

    private Integer getDefaultStartLevel(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Integer startLevel = provisionSpec.getStartLevel();
        if (startLevel == null) {
            startLevel = config.getStartLevel();
        }
        return startLevel;
    }

    private Boolean getDefaultStart(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean start = provisionSpec.shouldStart();
        if (start == null) {
            start = config.shouldStart();
        }
        return start;
    }

    private Boolean getDefaultUpdate(ProvisionSpec provisionSpec, ScannerConfiguration config) {
        Boolean update = provisionSpec.shouldUpdate();
        if (update == null) {
            update = config.shouldUpdate();
        }
        return update;
    }

    public void setResolver(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    ScannerConfiguration createConfiguration() {
        return new ScannerConfigurationImpl(this.m_propertyResolver, "org.ops4j.pax.scanner.bundle");
    }
}

