/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.assembly.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import org.ops4j.io.StreamUtils;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.assembly.internal.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VirtualJar {
    private final Iterable<Resource> m_resources;
    private final URL m_manifest;

    VirtualJar(URL manifest, Iterable<Resource> resources) {
        NullArgumentException.validateNotNull(resources, "Resources");
        this.m_resources = resources;
        this.m_manifest = manifest;
    }

    InputStream inputStream() throws IOException {
        final PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream(pos);
        new Thread(){

            public void run() {
                ZipOutputStream jos = null;
                try {
                    jos = VirtualJar.this.m_manifest == null ? new JarOutputStream(pos) : new JarOutputStream((OutputStream)pos, new Manifest(VirtualJar.this.m_manifest.openStream()));
                    for (Resource resource : VirtualJar.this.m_resources) {
                        if ("META-INF/MANIFEST.MF".equals(resource.path())) continue;
                        ((JarOutputStream)jos).putNextEntry(new JarEntry(resource.path()));
                        StreamUtils.copyStream(resource.url().openStream(), jos, false);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not process resources", e);
                }
                finally {
                    try {
                        if (jos != null) {
                            jos.close();
                        }
                    }
                    catch (Exception ignore) {}
                }
            }
        }.start();
        return pis;
    }
}

