/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.mocks;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import org.apache.aries.mocks.BundleContextMock;
import org.apache.aries.unittest.mocks.MethodCall;
import org.apache.aries.unittest.mocks.MethodCallHandler;
import org.apache.aries.unittest.mocks.Skeleton;
import org.apache.aries.unittest.mocks.annotations.Singleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BundleMock {
    private final String symbolicName;
    private final Dictionary<?, ?> headers;
    private final BundleContext bc;
    private String location;
    private BundleClassLoader cl;

    public BundleMock(String name, Dictionary<?, ?> bundleHeaders) {
        this.symbolicName = name;
        this.headers = bundleHeaders;
        this.bc = Skeleton.newMock(new BundleContextMock(Skeleton.newMock(this, Bundle.class)), BundleContext.class);
        this.cl = AccessController.doPrivileged(new PrivilegedAction<BundleClassLoader>(){

            @Override
            public BundleClassLoader run() {
                return new BundleClassLoader(new URL[0], this.getClass().getClassLoader());
            }
        });
    }

    public BundleMock(String name, Dictionary<?, ?> bundleHeaders, boolean dummy) {
        this(name, bundleHeaders);
        this.cl = null;
    }

    public BundleMock(String name, Dictionary<?, ?> bundleHeaders, String location) {
        this(name, bundleHeaders);
        this.location = location;
        if (location != null) {
            String cp = (String)bundleHeaders.get("Bundle-ClassPath");
            if (cp == null) {
                cp = ".";
            }
            String[] cpEntries = cp.split(",");
            final ArrayList<URL> urls = new ArrayList<URL>();
            try {
                for (String cpEntry : cpEntries) {
                    if (".".equals(cpEntry.trim())) {
                        urls.add(new URL(location));
                        continue;
                    }
                    urls.add(new URL(location + "/" + cpEntry));
                }
                this.cl = AccessController.doPrivileged(new PrivilegedAction<BundleClassLoader>(){

                    @Override
                    public BundleClassLoader run() {
                        return new BundleClassLoader(urls.toArray(new URL[urls.size()]));
                    }
                });
            }
            catch (MalformedURLException e) {
                AssertionFailedError err = new AssertionFailedError("The location was not a valid url");
                err.initCause(e);
                throw err;
            }
        }
    }

    public BundleMock(String name, Dictionary<?, ?> properties, File location) throws Exception {
        this(name, properties, location.toURL().toExternalForm());
        Skeleton bcSkel = Skeleton.getSkeleton(this.bc);
        bcSkel.registerMethodCallHandler(new MethodCall(BundleContext.class, "getDataFile", String.class), new PrivateDataFileHandler(location));
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Dictionary<?, ?> getHeaders() {
        return this.headers;
    }

    public Enumeration<URL> findEntries(String baseDir, String matchRule, boolean recurse) {
        File base;
        System.err.println("findEntries: " + baseDir + ", " + matchRule + ", " + recurse);
        try {
            base = new File(new File(new URL(this.location.replaceAll(" ", "%20")).toURI()), baseDir);
            System.err.println("Base dir: " + base);
        }
        catch (Exception e) {
            AssertionFailedError err = new AssertionFailedError("Unable to findEntries from " + this.location);
            err.initCause(e);
            throw err;
        }
        matchRule = matchRule.equals("*.xml") ? ".*\\.xml" : matchRule.replaceAll("\\*", ".*");
        System.err.println("matchrule: " + matchRule);
        final Pattern p = Pattern.compile(matchRule);
        File[] files = base.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && p.matcher(pathname.getName()).matches();
            }
        });
        Vector<URL> v = new Vector<URL>();
        if (files != null) {
            for (File f : files) {
                try {
                    v.add(f.toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("no matching files");
        }
        if (v.isEmpty()) {
            return null;
        }
        System.err.println(v);
        return v.elements();
    }

    public URL getResource(String name) {
        if (this.cl != null) {
            return this.cl.getResource(name);
        }
        try {
            File f = new File(name);
            if (f.exists() || "Entities.jar".equals(name)) {
                return f.toURL();
            }
            return null;
        }
        catch (MalformedURLException e) {
            AssertionFailedError err = new AssertionFailedError("The resource " + name + " could not be found.");
            err.initCause(e);
            throw err;
        }
    }

    public Enumeration<URL> getResources(String name) {
        if (this.cl != null) {
            try {
                return this.cl.getResources(name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            final URL resource = this.getResource(name);
            if (resource != null) {
                return new Enumeration<URL>(){
                    boolean hasMore = true;

                    @Override
                    public boolean hasMoreElements() {
                        return this.hasMore;
                    }

                    @Override
                    public URL nextElement() {
                        this.hasMore = false;
                        return resource;
                    }
                };
            }
        }
        return new Enumeration<URL>(){

            @Override
            public URL nextElement() {
                return null;
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }
        };
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.cl != null) {
            return Class.forName(name, false, this.cl);
        }
        throw new ClassNotFoundException("Argh, things went horribly wrong trying to load " + name);
    }

    public String getLocation() {
        try {
            return this.location == null ? new File(this.symbolicName + ".jar").toURL().toString() : this.location;
        }
        catch (MalformedURLException e) {
            AssertionFailedError err = new AssertionFailedError("We could not generate a valid url for the bundle");
            err.initCause(e);
            throw err;
        }
    }

    public BundleContext getBundleContext() {
        return this.bc;
    }

    public Version getVersion() {
        String res = (String)this.headers.get("Bundle-Version");
        if (res != null) {
            return new Version(res);
        }
        return new Version("0.0.0");
    }

    public int getState() {
        return 32;
    }

    public void addToClassPath(URL ... urls) {
        if (this.cl != null) {
            int i;
            URL[] existingURLs = this.cl.getURLs();
            final URL[] mergedURLs = new URL[urls.length + existingURLs.length];
            for (i = 0; i < existingURLs.length; ++i) {
                mergedURLs[i] = existingURLs[i];
            }
            int j = 0;
            while (j < urls.length) {
                mergedURLs[i] = urls[j];
                ++j;
                ++i;
            }
            BundleClassLoader newCl = AccessController.doPrivileged(new PrivilegedAction<BundleClassLoader>(){

                @Override
                public BundleClassLoader run() {
                    return new BundleClassLoader(mergedURLs, BundleMock.this.cl.getParent());
                }
            });
            newCl.addBundle(this.cl.getBundles());
            this.cl = newCl;
        }
    }

    public void addBundleToClassPath(Bundle ... bundles) {
        if (this.cl != null) {
            this.cl.addBundle(bundles);
        }
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public ServiceReference[] getRegisteredServices() {
        ServiceReference[] result = null;
        try {
            result = this.bc.getServiceReferences(null, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return result;
    }

    private static class PrivateDataFileHandler
    implements MethodCallHandler {
        private final File location;

        public PrivateDataFileHandler(File f) {
            this.location = f;
        }

        public Object handle(MethodCall call, Skeleton parent) {
            File privateStorage = new File(this.location.getAbsolutePath(), "_private");
            if (!privateStorage.exists()) {
                privateStorage.mkdirs();
            }
            return new File(privateStorage, (String)call.getArguments()[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleClassLoader
    extends URLClassLoader
    implements BundleReference {
        List<Bundle> otherBundlesToCheck;

        public BundleClassLoader(URL[] urls) {
            super(urls);
            this.otherBundlesToCheck = new ArrayList<Bundle>();
        }

        public BundleClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.otherBundlesToCheck = new ArrayList<Bundle>();
        }

        public void addBundle(Bundle ... otherBundles) {
            this.otherBundlesToCheck.addAll(Arrays.asList(otherBundles));
        }

        public Bundle[] getBundles() {
            return this.otherBundlesToCheck.toArray(new Bundle[this.otherBundlesToCheck.size()]);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class result = null;
            for (Bundle b : this.otherBundlesToCheck) {
                try {
                    result = b.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (result == null) continue;
                return result;
            }
            return super.findClass(name);
        }

        public Bundle getBundle() {
            return Skeleton.newMock(BundleMock.this, Bundle.class);
        }
    }
}

