/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

class URLHandlersServiceTracker {
    private BundleContext m_context = null;
    private String m_filter = null;
    private ServiceReference m_ref = null;
    private Object m_svcObj = null;
    private long m_id = -1L;
    private int m_rank = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLHandlersServiceTracker(BundleContext context, String filter) {
        this.m_context = context;
        this.m_filter = filter;
        URLHandlersServiceTracker uRLHandlersServiceTracker = this;
        synchronized (uRLHandlersServiceTracker) {
            ServiceListener sl = new ServiceListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void serviceChanged(ServiceEvent event) {
                    ServiceReference eventRef = event.getServiceReference();
                    if (event.getType() == 1 || event.getType() == 2) {
                        URLHandlersServiceTracker uRLHandlersServiceTracker = URLHandlersServiceTracker.this;
                        synchronized (uRLHandlersServiceTracker) {
                            int rank;
                            Long idObj = (Long)eventRef.getProperty("service.id");
                            Integer rankObj = (Integer)eventRef.getProperty("service.ranking");
                            int n = rank = rankObj == null ? 0 : rankObj;
                            if (rank > URLHandlersServiceTracker.this.m_rank || rank == URLHandlersServiceTracker.this.m_rank && idObj < URLHandlersServiceTracker.this.m_id) {
                                if (URLHandlersServiceTracker.this.m_ref != null) {
                                    URLHandlersServiceTracker.this.m_context.ungetService(URLHandlersServiceTracker.this.m_ref);
                                }
                                URLHandlersServiceTracker.this.m_ref = eventRef;
                                URLHandlersServiceTracker.this.m_rank = rank;
                                URLHandlersServiceTracker.this.m_id = idObj;
                                URLHandlersServiceTracker.this.m_svcObj = URLHandlersServiceTracker.this.m_context.getService(URLHandlersServiceTracker.this.m_ref);
                            }
                        }
                    }
                    if (event.getType() == 4) {
                        URLHandlersServiceTracker uRLHandlersServiceTracker = URLHandlersServiceTracker.this;
                        synchronized (uRLHandlersServiceTracker) {
                            if (eventRef == URLHandlersServiceTracker.this.m_ref) {
                                URLHandlersServiceTracker.this.selectBestService();
                            }
                        }
                    }
                }
            };
            try {
                this.m_context.addServiceListener(sl, this.m_filter);
            }
            catch (InvalidSyntaxException ex) {
                System.out.println("Cannot add service listener." + ex);
            }
            this.selectBestService();
        }
    }

    public Object getService() {
        return this.m_svcObj;
    }

    private void selectBestService() {
        if (this.m_ref != null) {
            this.m_context.ungetService(this.m_ref);
            this.m_ref = null;
            this.m_svcObj = null;
            this.m_id = -1L;
            this.m_rank = -1;
        }
        try {
            ServiceReference[] refs = this.m_context.getServiceReferences(null, this.m_filter);
            for (int i = 0; refs != null && i < refs.length; ++i) {
                int rank;
                Long idObj = (Long)refs[i].getProperty("service.id");
                Integer rankObj = (Integer)refs[i].getProperty("service.ranking");
                int n = rank = rankObj == null ? 0 : rankObj;
                if (rank <= this.m_rank && (rank != this.m_rank || idObj >= this.m_id)) continue;
                this.m_ref = refs[i];
                this.m_rank = rank;
                this.m_id = idObj;
            }
            if (this.m_ref != null) {
                this.m_svcObj = this.m_context.getService(this.m_ref);
            }
        }
        catch (InvalidSyntaxException ex) {
            System.err.println("URLHandlersServiceTracker: " + ex);
        }
    }
}

