/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.common;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SystemPropertyUtils {
    private static final Log LOGGER = LogFactory.getLog(SystemPropertyUtils.class);
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";

    public static String resolvePlaceholders(String text) {
        return SystemPropertyUtils.resolvePlaceholders(text, new Properties());
    }

    public static String resolvePlaceholders(String text, Properties properties) {
        if (text == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(text);
        int startIndex = buf.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                int nextIndex;
                block9: {
                    String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                    nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                    try {
                        String propVal = properties.getProperty(placeholder);
                        if (propVal == null && (propVal = System.getProperty(placeholder)) == null) {
                            propVal = System.getenv(placeholder);
                        }
                        if (propVal != null) {
                            buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                            nextIndex = startIndex + propVal.length();
                        } else if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn((Object)("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: neither system property nor environment variable found"));
                        }
                    }
                    catch (Throwable ex) {
                        if (!LOGGER.isWarnEnabled()) break block9;
                        LOGGER.warn((Object)("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: " + ex));
                    }
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }
}

