/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.assembly.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.assembly.internal.Parser;
import org.ops4j.pax.url.assembly.internal.Resource;
import org.ops4j.pax.url.assembly.internal.ResourceAssembly;
import org.ops4j.pax.url.assembly.internal.VirtualJar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Connection
extends URLConnection {
    private Parser m_parser;

    Connection(URL url, Parser parser) throws IOException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL");
        NullArgumentException.validateNotNull(parser, "Parser");
        this.m_parser = parser;
    }

    @Override
    public void connect() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        ResourceAssembly assembly = new ResourceAssembly(this.m_parser.sources(), this.m_parser.mergePolicy());
        URL manifest = this.getManifest(assembly);
        VirtualJar virtualJar = new VirtualJar(manifest, assembly);
        return virtualJar.inputStream();
    }

    private URL getManifest(Iterable<Resource> resources) throws MalformedURLException {
        String manifest = this.m_parser.manifest();
        if (manifest != null) {
            try {
                return new URL(manifest);
            }
            catch (MalformedURLException e) {
                return new File(manifest).toURL();
            }
        }
        if (resources != null) {
            for (Resource resource : resources) {
                if (!"META-INF/MANIFEST.MF".equals(resource.path())) continue;
                return resource.url();
            }
        }
        return null;
    }
}

