/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http.HttpConfiguration;
import org.apache.maven.wagon.shared.http.HttpMethodConfiguration;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractHttpClientWagon
extends StreamWagon {
    protected static final int SC_NULL = -1;
    protected static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private HttpClient client;
    protected HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private Properties httpHeaders;
    private HttpConfiguration httpConfiguration;
    private HttpMethod getMethod;

    public void openConnectionInternal() {
        this.repository.setUrl(this.getURL(this.repository));
        this.client = new HttpClient(this.connectionManager);
        String username = null;
        String password = null;
        if (this.authenticationInfo != null) {
            username = this.authenticationInfo.getUserName();
            password = this.authenticationInfo.getPassword();
        }
        String host = this.getRepository().getHost();
        if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            int port = this.getRepository().getPort() > -1 ? this.getRepository().getPort() : -1;
            AuthScope scope = new AuthScope(host, port);
            this.client.getState().setCredentials(scope, creds);
        }
        HostConfiguration hc = new HostConfiguration();
        ProxyInfo proxyInfo = this.getProxyInfo(this.getRepository().getProtocol(), this.getRepository().getHost());
        if (proxyInfo != null) {
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyHost = proxyInfo.getHost();
            int proxyPort = proxyInfo.getPort();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (proxyHost != null) {
                hc.setProxy(proxyHost, proxyPort);
                if (proxyUsername != null && proxyPassword != null) {
                    UsernamePasswordCredentials creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    int port = proxyInfo.getPort() > -1 ? proxyInfo.getPort() : -1;
                    AuthScope scope = new AuthScope(proxyHost, port);
                    this.client.getState().setProxyCredentials(scope, creds);
                }
            }
        }
        hc.setHost(host);
        this.client.setHostConfiguration(hc);
    }

    public void closeConnection() {
        if (this.connectionManager instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)this.connectionManager).shutdown();
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.put(null, resource, source);
    }

    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, null);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.put(stream, resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(InputStream stream, Resource resource, File source) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        String url = this.getRepository().getUrl();
        String[] parts = StringUtils.split(resource.getName(), "/");
        for (int i = 0; i < parts.length; ++i) {
            url = url + "/" + URLEncoder.encode(parts[i]);
        }
        try {
            this.mkdirs(PathUtils.dirname(resource.getName()));
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
        }
        PutMethod putMethod = new PutMethod(url);
        this.firePutStarted(resource, source);
        try {
            int statusCode;
            putMethod.setRequestEntity(new RequestEntityImplementation(stream, resource, this, source));
            try {
                statusCode = this.execute(putMethod);
            }
            catch (IOException e) {
                this.fireTransferError(resource, e, 6);
                throw new TransferFailedException(e.getMessage(), e);
            }
            this.fireTransferDebug(url + " - Status code: " + statusCode);
            switch (statusCode) {
                case 200: 
                case 201: 
                case 202: 
                case 204: {
                    break;
                }
                case -1: {
                    TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url);
                    this.fireTransferError(resource, e, 6);
                    throw e;
                }
                case 403: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " does not exist");
                }
                default: {
                    TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                    this.fireTransferError(resource, e, 6);
                    throw e;
                }
            }
            this.firePutCompleted(resource, source);
        }
        finally {
            putMethod.releaseConnection();
        }
    }

    protected void mkdirs(String dirname) throws HttpException, IOException {
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        int statusCode;
        String url = this.getRepository().getUrl() + "/" + resourceName;
        HeadMethod headMethod = new HeadMethod(url);
        try {
            statusCode = this.execute(headMethod);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), e);
        }
        try {
            switch (statusCode) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 304: {
                    boolean bl = true;
                    return bl;
                }
                case -1: {
                    throw new TransferFailedException("Failed to transfer file: " + url);
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized.");
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy.");
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
        }
        finally {
            headMethod.releaseConnection();
        }
    }

    protected int execute(HttpMethod httpMethod) throws HttpException, IOException {
        int statusCode = -1;
        this.setParameters(httpMethod);
        this.setHeaders(httpMethod);
        statusCode = this.client.executeMethod(httpMethod);
        return statusCode;
    }

    protected void setParameters(HttpMethod method) {
        HttpMethodParams params;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config != null && (params = config.asMethodParams(method.getParams())) != null) {
            method.setParams(params);
        }
        if (config == null || config.getConnectionTimeout() == 60000) {
            method.getParams().setSoTimeout(this.getTimeout());
        }
    }

    protected void setHeaders(HttpMethod method) {
        Header[] headers;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config == null || config.isUseDefaultHeaders()) {
            method.addRequestHeader("Cache-control", "no-cache");
            method.addRequestHeader("Cache-store", "no-store");
            method.addRequestHeader("Pragma", "no-cache");
            method.addRequestHeader("Expires", "0");
            method.addRequestHeader("Accept-Encoding", "gzip");
        }
        if (this.httpHeaders != null) {
            Iterator<Object> i = this.httpHeaders.keySet().iterator();
            while (i.hasNext()) {
                String header = (String)i.next();
                method.addRequestHeader(header, this.httpHeaders.getProperty(header));
            }
        }
        Header[] headerArray = headers = config == null ? null : config.asRequestHeaders();
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                method.addRequestHeader(headers[i]);
            }
        }
    }

    protected String getURL(Repository repository) {
        return repository.getUrl();
    }

    protected HttpClient getClient() {
        return this.client;
    }

    public void setConnectionManager(HttpConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Header contentEncoding;
        int statusCode;
        Resource resource = inputData.getResource();
        String url = this.getRepository().getUrl() + "/" + resource.getName();
        this.getMethod = new GetMethod(url);
        long timestamp = resource.getLastModified();
        if (timestamp > 0L) {
            SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            fmt.setTimeZone(GMT_TIME_ZONE);
            Header hdr = new Header("If-Modified-Since", fmt.format(new Date(timestamp)));
            this.fireTransferDebug("sending ==> " + hdr + "(" + timestamp + ")");
            this.getMethod.addRequestHeader(hdr);
        }
        try {
            statusCode = this.execute(this.getMethod);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), e);
        }
        this.fireTransferDebug(url + " - Status code: " + statusCode);
        switch (statusCode) {
            case 200: {
                break;
            }
            case 304: {
                return;
            }
            case -1: {
                TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url);
                this.fireTransferError(resource, e, 5);
                throw e;
            }
            case 403: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Access denied to: " + url);
            }
            case 401: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Not authorized.");
            }
            case 407: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Not authorized by proxy.");
            }
            case 404: {
                throw new ResourceDoesNotExistException("File: " + url + " does not exist");
            }
            default: {
                this.cleanupGetTransfer(resource);
                TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                this.fireTransferError(resource, e, 5);
                throw e;
            }
        }
        InputStream is = null;
        Header contentLengthHeader = this.getMethod.getResponseHeader("Content-Length");
        if (contentLengthHeader != null) {
            try {
                long contentLength = Integer.valueOf(contentLengthHeader.getValue()).intValue();
                resource.setContentLength(contentLength);
            }
            catch (NumberFormatException e) {
                this.fireTransferDebug("error parsing content length header '" + contentLengthHeader.getValue() + "' " + e);
            }
        }
        Header lastModifiedHeader = this.getMethod.getResponseHeader("Last-Modified");
        long lastModified = 0L;
        if (lastModifiedHeader != null) {
            try {
                lastModified = DateUtil.parseDate(lastModifiedHeader.getValue()).getTime();
                resource.setLastModified(lastModified);
            }
            catch (DateParseException e) {
                this.fireTransferDebug("Unable to parse last modified header");
            }
            this.fireTransferDebug("last-modified = " + lastModifiedHeader.getValue() + " (" + lastModified + ")");
        }
        boolean isGZipped = (contentEncoding = this.getMethod.getResponseHeader("Content-Encoding")) == null ? false : "gzip".equalsIgnoreCase(contentEncoding.getValue());
        try {
            is = this.getMethod.getResponseBodyAsStream();
            if (isGZipped) {
                is = new GZIPInputStream(is);
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            String msg = "Error occurred while retrieving from remote repository:" + this.getRepository() + ": " + e.getMessage();
            throw new TransferFailedException(msg, e);
        }
        inputData.setInputStream(is);
    }

    protected void cleanupGetTransfer(Resource resource) {
        if (this.getMethod != null) {
            this.getMethod.releaseConnection();
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new IllegalStateException("Should not be using the streaming wagon for HTTP PUT");
    }

    private final class RequestEntityImplementation
    implements RequestEntity {
        private final Resource resource;
        private final Wagon wagon;
        private final File source;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private RequestEntityImplementation(InputStream stream, Resource resource, Wagon wagon, File source) throws TransferFailedException {
            if (source != null) {
                this.source = source;
            } else {
                FileOutputStream fos = null;
                try {
                    this.source = File.createTempFile("http-wagon.", ".tmp");
                    this.source.deleteOnExit();
                    fos = new FileOutputStream(this.source);
                    IOUtil.copy(stream, (OutputStream)fos);
                }
                catch (IOException e) {
                    try {
                        AbstractHttpClientWagon.this.fireTransferError(resource, e, 6);
                        throw new TransferFailedException("Failed to buffer stream contents to temp file for upload.", e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(fos);
                        throw throwable;
                    }
                }
                IOUtil.close(fos);
            }
            this.resource = resource;
            this.wagon = wagon;
        }

        public long getContentLength() {
            return this.resource.getContentLength();
        }

        public String getContentType() {
            return null;
        }

        public boolean isRepeatable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRequest(OutputStream output) throws IOException {
            byte[] buffer = new byte[4096];
            TransferEvent transferEvent = new TransferEvent(this.wagon, this.resource, 3, 6);
            transferEvent.setTimestamp(System.currentTimeMillis());
            FileInputStream fin = null;
            try {
                int n;
                fin = new FileInputStream(this.source);
                for (int remaining = Integer.MAX_VALUE; remaining > 0 && (n = fin.read(buffer, 0, Math.min(buffer.length, remaining))) != -1; remaining -= n) {
                    AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer, n);
                    output.write(buffer, 0, n);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fin);
                throw throwable;
            }
            IOUtil.close(fin);
            output.flush();
        }
    }
}

