/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.tinybundles.core.intern;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.ops4j.pax.tinybundles.core.BuildStrategy;
import org.ops4j.pax.tinybundles.core.InnerClassStrategy;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.ops4j.store.Handle;
import org.ops4j.store.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyBundleImpl
implements TinyBundle {
    private Map<String, URL> m_resources = new HashMap<String, URL>();
    private Map<String, String> m_headers = new HashMap<String, String>();
    private final Store<InputStream> m_store;

    public TinyBundleImpl(Store<InputStream> bstore) {
        this.m_store = bstore;
    }

    @Override
    public TinyBundle read(InputStream in) {
        if (in != null) {
            try {
                Handle handle = this.m_store.store((Object)in);
                JarInputStream jarOut = new JarInputStream((InputStream)this.m_store.load(handle));
                Manifest manifest = jarOut.getManifest();
                Attributes att = manifest.getMainAttributes();
                for (Object o : att.keySet()) {
                    String k = o.toString();
                    String v = att.getValue(k);
                    this.set(k, v);
                }
                JarEntry entry = null;
                while ((entry = jarOut.getNextJarEntry()) != null) {
                    this.add(entry.getName(), jarOut);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Problem loading bundle.", e);
            }
        }
        return this;
    }

    @Override
    public TinyBundle add(Class<?> clazz) {
        this.add(clazz, InnerClassStrategy.ALL);
        return this;
    }

    @Override
    public TinyBundle add(Class<?> clazz, InnerClassStrategy strategy) {
        String expression;
        String name = this.mapClassToEntry(clazz.getName());
        URL resource = clazz.getResource("/" + name);
        if (resource == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " not found! (resource: " + name + " )");
        }
        this.add(name, resource);
        if (strategy == InnerClassStrategy.ALL) {
            expression = clazz.getSimpleName() + "\\$.+\\.class";
        } else if (strategy == InnerClassStrategy.ANONYMOUS) {
            expression = clazz.getSimpleName() + "\\$[$0-9]+\\.class";
        } else {
            return this;
        }
        String path = resource.getPath();
        File classFile = new File(path);
        File[] innerClassFiles = classFile.getParentFile().listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().matches(expression);
            }
        });
        if (innerClassFiles == null) {
            return this;
        }
        int basePathIndex = path.lastIndexOf(name);
        for (File f : innerClassFiles) {
            String classPath = f.getPath().substring(basePathIndex);
            this.add(classPath, this.getClass().getResource("/" + classPath));
        }
        return this;
    }

    @Override
    public TinyBundle remove(Class<?> content) {
        String name = this.mapClassToEntry(content.getName());
        this.removeResource(name);
        return this;
    }

    private String mapClassToEntry(String clazzname) {
        return clazzname.replaceAll("\\.", "/") + ".class";
    }

    @Override
    public TinyBundle add(String name, URL url) {
        this.m_resources.put(name, url);
        return this;
    }

    @Override
    public TinyBundle add(String name, InputStream content) {
        try {
            return this.add(name, this.m_store.getLocation(this.m_store.store((Object)content)).toURL());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream build() {
        return TinyBundles.withClassicBuilder().build(this.m_resources, this.m_headers);
    }

    @Override
    public InputStream build(BuildStrategy builder) {
        return builder.build(this.m_resources, this.m_headers);
    }

    @Override
    public TinyBundle set(String key, String value) {
        this.m_headers.put(key, value);
        return this;
    }

    @Override
    public TinyBundle removeResource(String key) {
        this.m_resources.remove(key);
        return this;
    }

    @Override
    public TinyBundle removeHeader(String key) {
        this.m_headers.remove(key);
        return this;
    }
}

