/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathUtil.class);

    private ClassPathUtil() {
    }

    public static URL[] getClassPathJars(Bundle bundle) {
        ArrayList<URL> urls = new ArrayList<URL>();
        String bundleClasspath = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (bundleClasspath != null) {
            String[] segments;
            for (String segment : segments = bundleClasspath.split(",")) {
                URL url = bundle.getEntry(segment);
                if (url == null || !url.toExternalForm().endsWith("jar")) continue;
                LOG.debug("Using url: " + url);
                try {
                    URL jarUrl = new URL("jar:" + url.toExternalForm() + "!/");
                    urls.add(jarUrl);
                }
                catch (MalformedURLException ignore) {
                    LOG.debug(ignore.getMessage());
                }
            }
        }
        LOG.debug("Bundle-ClassPath URLs: " + urls);
        urls.addAll(ClassPathUtil.getLocationsOfBundlesInClassSpace(bundle));
        return urls.toArray(new URL[urls.size()]);
    }

    private static List<URL> getLocationsOfBundlesInClassSpace(Bundle bundle) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Set<Bundle> importedBundles = ClassPathUtil.getBundlesInClassSpace(bundle, new HashSet<Bundle>());
        for (Bundle importedBundle : importedBundles) {
            URL url = ClassPathUtil.getLocationOfBundle(importedBundle);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    private static URL getLocationOfBundle(Bundle importedBundle) {
        URL url = null;
        try {
            url = new URL(importedBundle.getLocation());
        }
        catch (MalformedURLException e) {
            try {
                url = importedBundle.getEntry("/");
            }
            catch (Exception e2) {
                LOG.warn("Exception while calculating location of bundle", (Throwable)e);
            }
        }
        return url;
    }

    public static Set<Bundle> getBundlesInClassSpace(Bundle bundle, Set<Bundle> bundleSet) {
        return ClassPathUtil.getBundlesInClassSpace(bundle.getBundleContext(), bundle, bundleSet);
    }

    private static Set<Bundle> getBundlesInClassSpace(BundleContext context, Bundle bundle, Set<Bundle> bundleSet) {
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        if (bundle == null) {
            LOG.error("Incoming bundle is null");
            return bundles;
        }
        if (context == null) {
            LOG.error("Incoming context is null");
            return bundles;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            LOG.error("BundleWiring is null for: " + bundle);
            return bundles;
        }
        List requiredWires = bundleWiring.getRequiredWires(null);
        for (BundleWire bundleWire : requiredWires) {
            Bundle exportingBundle = bundleWire.getCapability().getRevision().getBundle();
            if (exportingBundle.getBundleId() == 0L || bundles.contains(exportingBundle)) continue;
            bundles.add(exportingBundle);
        }
        HashSet<Bundle> transitiveBundles = new HashSet<Bundle>();
        if (!bundleSet.containsAll(bundles)) {
            bundles.removeAll(bundleSet);
            bundleSet.addAll(bundles);
            for (Bundle importedBundle : bundles) {
                transitiveBundles.addAll(ClassPathUtil.getBundlesInClassSpace(context, importedBundle, bundleSet));
            }
        }
        Iterator<Bundle> bundleIterator = bundleSet.iterator();
        while (bundleIterator.hasNext()) {
            Bundle auxBundle = bundleIterator.next();
            if (auxBundle.getState() != 1) continue;
            bundleIterator.remove();
        }
        return bundleSet;
    }

    public static List<URL> findResources(Iterable<Bundle> bundles, String path, String pattern, boolean recurse) {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (Bundle bundle : bundles) {
            Collection names = ((BundleWiring)bundle.adapt(BundleWiring.class)).listResources(path, pattern, 2 | (recurse ? 1 : 0));
            for (String name : names) {
                resources.add(bundle.getResource(name));
            }
        }
        return resources;
    }
}

