/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.deployer.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.ops4j.pax.web.deployer.internal.DeployerUtils;

public class WarDeployer
implements ArtifactUrlTransformer {
    private static final Log LOG = LogFactory.getLog(WarDeployer.class);
    private static final String PATH_SEPERATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHandle(File artifact) {
        JarFile jar = null;
        try {
            jar = new JarFile(artifact);
            JarEntry entry = jar.getJarEntry("WEB-INF/web.xml");
            if (entry == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No war file do not handle artifact:" + artifact.getName());
                }
                boolean bl = false;
                return bl;
            }
            Manifest m = jar.getManifest();
            if (m != null && m.getMainAttributes().getValue(new Attributes.Name("Bundle-SymbolicName")) != null && m.getMainAttributes().getValue(new Attributes.Name("Bundle-Version")) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("This artifact has OSGi Manifest Header skipping: " + artifact.getName());
                }
                boolean ignore = false;
                return ignore;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Can't handle file " + artifact.getName(), e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block25: {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException ignore) {
                        if (!LOG.isDebugEnabled()) break block25;
                        LOG.debug("failed to close war file", ignore);
                    }
                }
            }
        }
        try {
            new URL("webbundle", null, artifact.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            LOG.warn(String.format("File %s could not be transformed. Most probably that Pax URL WAR handler is not installed", artifact.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public URL transform(URL artifact) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transforming artifact with URL: " + artifact);
        }
        String path = artifact.getPath();
        String protocol = artifact.getProtocol();
        if (path != null) {
            int idx = -1;
            if ("jardir".equalsIgnoreCase(protocol)) {
                File fileInstance = new File(path);
                idx = fileInstance.getAbsolutePath().lastIndexOf(File.separator);
            } else {
                idx = path.lastIndexOf(PATH_SEPERATOR);
            }
            if (idx > 0) {
                String[] name = DeployerUtils.extractNameVersionType(path.substring(idx + 1));
                StringBuilder url = new StringBuilder();
                url.append(artifact.toExternalForm());
                if (artifact.toExternalForm().contains("?")) {
                    url.append("&");
                } else {
                    url.append("?");
                }
                url.append("Web-ContextPath=").append(name[0]);
                url.append("&");
                url.append("Bundle-SymbolicName=").append(name[0]);
                url.append("&");
                url.append("Bundle-Version=").append(name[1]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Transformed URL of %s to following %s", path, url));
                }
                return new URL("webbundle", null, url.toString());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No path for given artifact, retry with webbundle prepended");
        }
        return new URL("webbundle", null, artifact.toExternalForm());
    }
}

