/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;

class UnregisterWebAppVisitorWC
implements WebAppVisitor {
    private static final Log LOG = LogFactory.getLog(UnregisterWebAppVisitorWC.class);
    private final WebContainer m_webContainer;
    private HttpContext m_httpContext;

    UnregisterWebAppVisitorWC(WebContainer webContainer) {
        NullArgumentException.validateNotNull(webContainer, "Web Container");
        this.m_webContainer = webContainer;
    }

    public void visit(WebApp webApp) {
        this.m_httpContext = webApp.getHttpContext();
        try {
            this.m_webContainer.unregister("/");
        }
        catch (Exception ignore) {
            LOG.error("Unregistration exception. Skipping.", ignore);
        }
        try {
            this.m_webContainer.unregisterWelcomeFiles(this.m_httpContext);
        }
        catch (Exception ignore) {
            LOG.error("Unregistration exception. Skipping.", ignore);
        }
        try {
            this.m_webContainer.unregisterJsps(this.m_httpContext);
        }
        catch (UnsupportedOperationException ignore) {
            LOG.warn(ignore.getMessage());
        }
        catch (Exception ignore) {
            LOG.error("Unregistration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppServlet webAppServlet) {
        NullArgumentException.validateNotNull(webAppServlet, "Web app servlet");
        Servlet servlet = webAppServlet.getServlet();
        if (servlet != null) {
            try {
                this.m_webContainer.unregisterServlet(servlet);
            }
            catch (Exception ignore) {
                LOG.error("Unregistration exception. Skipping.", ignore);
            }
        }
    }

    public void visit(WebAppFilter webAppFilter) {
        NullArgumentException.validateNotNull(webAppFilter, "Web app filter");
        Filter filter = webAppFilter.getFilter();
        if (filter != null) {
            try {
                this.m_webContainer.unregisterFilter(filter);
            }
            catch (Exception ignore) {
                LOG.error("Unregistration exception. Skipping.", ignore);
            }
        }
    }

    public void visit(WebAppListener webAppListener) {
        NullArgumentException.validateNotNull(webAppListener, "Web app listener");
        EventListener listener = webAppListener.getListener();
        if (listener != null) {
            try {
                this.m_webContainer.unregisterEventListener(listener);
            }
            catch (Exception ignore) {
                LOG.error("Unregistration exception. Skipping.", ignore);
            }
        }
    }

    public void visit(WebAppErrorPage webAppErrorPage) {
        NullArgumentException.validateNotNull(webAppErrorPage, "Web app error page");
        try {
            this.m_webContainer.unregisterErrorPage(webAppErrorPage.getError(), this.m_httpContext);
        }
        catch (Exception ignore) {
            LOG.error("Unregistration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppLoginConfig loginConfig) {
        NullArgumentException.validateNotNull(loginConfig, "Web app login config");
        this.m_webContainer.unregisterLoginConfig(this.m_httpContext);
    }

    public void visit(WebAppConstraintMapping constraintMapping) {
        NullArgumentException.validateNotNull(constraintMapping, "Web app constraint mapping");
        this.m_webContainer.unregisterConstraintMapping(this.m_httpContext);
    }
}

