/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.net.URL;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.ops4j.pax.swissbox.extender.BundleURLScanner;
import org.ops4j.pax.swissbox.extender.BundleWatcher;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisher;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.WebXmlObserver;
import org.ops4j.pax.web.extender.war.internal.parser.dom.DOMWebXmlParser;
import org.ops4j.pax.web.service.spi.WarManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private BundleWatcher<URL> m_webXmlWatcher;
    private ServiceTracker eventServiceTracker;
    private ServiceTracker logServiceTracker;
    private WebXmlObserver webXmlObserver;
    private BundleContext bundleContext;
    private ScheduledExecutorService executors;
    private WebEventDispatcher webEventDispatcher;

    public void start(BundleContext bundleContext) throws Exception {
        LOG.debug("Pax Web WAR Extender - Starting");
        this.bundleContext = bundleContext;
        this.executors = Executors.newScheduledThreadPool(3, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("WebListenerExecutor: " + this.count.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        this.webEventDispatcher = new WebEventDispatcher(bundleContext, this.executors);
        Filter filterEvent = bundleContext.createFilter("(objectClass=org.osgi.service.event.EventAdmin)");
        this.eventServiceTracker = new ServiceTracker(bundleContext, filterEvent, (ServiceTrackerCustomizer)new EventServiceCustomizer());
        this.eventServiceTracker.open();
        Filter filterLog = bundleContext.createFilter("(objectClass=org.osgi.service.log.LogService)");
        this.logServiceTracker = new ServiceTracker(bundleContext, filterLog, (ServiceTrackerCustomizer)new LogServiceCustomizer());
        this.logServiceTracker.open();
        this.webXmlObserver = new WebXmlObserver(new DOMWebXmlParser(), new WebAppPublisher(), this.webEventDispatcher, bundleContext);
        this.m_webXmlWatcher = new BundleWatcher<URL>(bundleContext, new BundleURLScanner("Webapp-Root", null, null, "WEB-INF/", "web.xml", true), this.webXmlObserver);
        this.m_webXmlWatcher.start();
        bundleContext.registerService(new String[]{WarManager.class.getName()}, (Object)this.webXmlObserver, new Hashtable());
        LOG.debug("Pax Web WAR Extender - Started");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        LOG.debug("Pax Web WAR Extender - Stopping");
        if (this.m_webXmlWatcher != null) {
            this.m_webXmlWatcher.stop();
            this.m_webXmlWatcher = null;
        }
        this.eventServiceTracker.close();
        this.logServiceTracker.close();
        this.webEventDispatcher.destroy();
        this.executors.shutdown();
        LOG.debug("Pax Web WAR Extender - Stopped");
    }

    private class EventServiceCustomizer
    implements ServiceTrackerCustomizer {
        private EventServiceCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            Object eventService = Activator.this.bundleContext.getService(reference);
            if (eventService instanceof EventAdmin) {
                Activator.this.webEventDispatcher.setEventAdminService(eventService);
            }
            return eventService;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            Activator.this.webEventDispatcher.setEventAdminService(null);
            Activator.this.bundleContext.ungetService(reference);
        }
    }

    private class LogServiceCustomizer
    implements ServiceTrackerCustomizer {
        private LogServiceCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            Object logService = Activator.this.bundleContext.getService(reference);
            if (logService instanceof LogService) {
                Activator.this.webEventDispatcher.setLogService(logService);
            }
            return logService;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            Activator.this.webEventDispatcher.setLogService(null);
            Activator.this.bundleContext.ungetService(reference);
        }
    }
}

