/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilterMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppMimeMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityRole;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletMapping;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApp {
    private int m_deploymentState;
    private URL m_webXmlURL;
    private String m_displayName;
    private String m_contextName;
    private String m_rootPath;
    private String m_sessionTimeout;
    private Bundle m_bundle;
    private HttpContext m_httpContext;
    private final Map<String, WebAppServlet> m_servlets = new HashMap<String, WebAppServlet>();
    private final Map<String, Set<WebAppServletMapping>> m_servletMappings = new HashMap<String, Set<WebAppServletMapping>>();
    private final Map<String, WebAppFilter> m_filters = new LinkedHashMap<String, WebAppFilter>();
    private final Map<String, Set<WebAppFilterMapping>> m_filterMappings = new HashMap<String, Set<WebAppFilterMapping>>();
    private final List<String> m_orderedFilters = new ArrayList<String>();
    private final Set<WebAppInitParam> m_contextParams;
    private final Set<WebAppMimeMapping> m_mimeMappings;
    private final List<WebAppListener> m_listeners = new ArrayList<WebAppListener>();
    private final List<WebAppErrorPage> m_errorPages = new ArrayList<WebAppErrorPage>();
    private final List<String> m_welcomeFiles;
    private final List<WebAppConstraintMapping> m_constraintsMapping;
    private final List<WebAppSecurityRole> m_securityRoles;
    private final List<WebAppLoginConfig> m_loginConfig;
    static final Comparator<WebAppServlet> WebAppServletComparator = new Comparator<WebAppServlet>(){

        @Override
        public int compare(WebAppServlet servlet1, WebAppServlet servlet2) {
            return servlet1.getLoadOnStartup() - servlet2.getLoadOnStartup();
        }
    };

    public WebApp() {
        this.m_contextParams = new HashSet<WebAppInitParam>();
        this.m_mimeMappings = new HashSet<WebAppMimeMapping>();
        this.m_welcomeFiles = new ArrayList<String>();
        this.m_constraintsMapping = new ArrayList<WebAppConstraintMapping>();
        this.m_securityRoles = new ArrayList<WebAppSecurityRole>();
        this.m_loginConfig = new ArrayList<WebAppLoginConfig>();
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    private WebAppInitParam getWebAppInitParam(String name) {
        for (WebAppInitParam p : this.m_contextParams) {
            if (!name.equals(p.getParamName())) continue;
            return p;
        }
        return null;
    }

    public void setContextName(String contextName) {
        NullArgumentException.validateNotNull(contextName, "Context name");
        this.m_contextName = contextName;
        WebAppInitParam prev = this.getWebAppInitParam("webapp.context");
        if (prev != null) {
            this.m_contextParams.remove(prev);
        }
        WebAppInitParam initParam = new WebAppInitParam();
        initParam.setParamName("webapp.context");
        initParam.setParamValue(contextName);
        this.m_contextParams.add(initParam);
    }

    public String getContextName() {
        return this.m_contextName;
    }

    public void setRootPath(String rootPath) {
        NullArgumentException.validateNotNull(rootPath, "Root Path");
        this.m_rootPath = rootPath;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public void setSessionTimeout(String minutes) {
        this.m_sessionTimeout = minutes;
    }

    public String getSessionTimeout() {
        return this.m_sessionTimeout;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(Bundle bundle) {
        this.m_bundle = bundle;
    }

    public void addServlet(WebAppServlet servlet) {
        NullArgumentException.validateNotNull(servlet, "Servlet");
        NullArgumentException.validateNotNull(servlet.getServletName(), "Servlet name");
        NullArgumentException.validateNotNull(servlet.getServletClass(), "Servlet class");
        this.m_servlets.put(servlet.getServletName(), servlet);
        for (WebAppServletMapping mapping : this.getServletMappings(servlet.getServletName())) {
            servlet.addUrlPattern(mapping.getUrlPattern());
        }
    }

    public void addServletMapping(WebAppServletMapping servletMapping) {
        NullArgumentException.validateNotNull(servletMapping, "Servlet mapping");
        NullArgumentException.validateNotNull(servletMapping.getServletName(), "Servlet name");
        NullArgumentException.validateNotNull(servletMapping.getUrlPattern(), "Url pattern");
        Set<WebAppServletMapping> servletMappings = this.m_servletMappings.get(servletMapping.getServletName());
        if (servletMappings == null) {
            servletMappings = new HashSet<WebAppServletMapping>();
            this.m_servletMappings.put(servletMapping.getServletName(), servletMappings);
        }
        servletMappings.add(servletMapping);
        WebAppServlet servlet = this.m_servlets.get(servletMapping.getServletName());
        if (servlet != null) {
            servlet.addUrlPattern(servletMapping.getUrlPattern());
        }
    }

    private WebAppServletMapping[] getServletMappings(String servletName) {
        Set<WebAppServletMapping> servletMappings = this.m_servletMappings.get(servletName);
        if (servletMappings == null) {
            return new WebAppServletMapping[0];
        }
        return servletMappings.toArray(new WebAppServletMapping[servletMappings.size()]);
    }

    public void addFilter(WebAppFilter filter) {
        NullArgumentException.validateNotNull(filter, "Filter");
        NullArgumentException.validateNotNull(filter.getFilterName(), "Filter name");
        NullArgumentException.validateNotNull(filter.getFilterClass(), "Filter class");
        this.m_filters.put(filter.getFilterName(), filter);
        for (WebAppFilterMapping mapping : this.getFilterMappings(filter.getFilterName())) {
            if (mapping.getUrlPattern() != null && mapping.getUrlPattern().trim().length() > 0) {
                filter.addUrlPattern(mapping.getUrlPattern());
            }
            if (mapping.getServletName() == null || mapping.getServletName().trim().length() <= 0) continue;
            filter.addServletName(mapping.getServletName());
        }
    }

    public void addFilterMapping(WebAppFilterMapping filterMapping) {
        Set<WebAppFilterMapping> filterMappings;
        NullArgumentException.validateNotNull(filterMapping, "Filter mapping");
        NullArgumentException.validateNotNull(filterMapping.getFilterName(), "Filter name");
        String filterName = filterMapping.getFilterName();
        if (!this.m_orderedFilters.contains(filterName)) {
            this.m_orderedFilters.add(filterName);
        }
        if ((filterMappings = this.m_filterMappings.get(filterName)) == null) {
            filterMappings = new HashSet<WebAppFilterMapping>();
            this.m_filterMappings.put(filterName, filterMappings);
        }
        filterMappings.add(filterMapping);
        WebAppFilter filter = this.m_filters.get(filterName);
        if (filter != null) {
            if (filterMapping.getUrlPattern() != null && filterMapping.getUrlPattern().trim().length() > 0) {
                filter.addUrlPattern(filterMapping.getUrlPattern());
            }
            if (filterMapping.getServletName() != null && filterMapping.getServletName().trim().length() > 0) {
                filter.addServletName(filterMapping.getServletName());
            }
        }
    }

    private WebAppFilterMapping[] getFilterMappings(String filterName) {
        Set<WebAppFilterMapping> filterMappings = this.m_filterMappings.get(filterName);
        if (filterMappings == null) {
            return new WebAppFilterMapping[0];
        }
        return filterMappings.toArray(new WebAppFilterMapping[filterMappings.size()]);
    }

    public void addListener(WebAppListener listener) {
        NullArgumentException.validateNotNull(listener, "Listener");
        NullArgumentException.validateNotNull(listener.getListenerClass(), "Listener class");
        this.m_listeners.add(listener);
    }

    public void addErrorPage(WebAppErrorPage errorPage) {
        NullArgumentException.validateNotNull(errorPage, "Error page");
        if (errorPage.getErrorCode() == null && errorPage.getExceptionType() == null) {
            throw new NullPointerException("At least one of error type or exception code must be set");
        }
        this.m_errorPages.add(errorPage);
    }

    public void addWelcomeFile(String welcomeFile) {
        NullArgumentException.validateNotEmpty(welcomeFile, "Welcome file");
        this.m_welcomeFiles.add(welcomeFile);
    }

    public String[] getWelcomeFiles() {
        return this.m_welcomeFiles.toArray(new String[this.m_welcomeFiles.size()]);
    }

    public void addContextParam(WebAppInitParam contextParam) {
        NullArgumentException.validateNotNull(contextParam, "Context param");
        NullArgumentException.validateNotNull(contextParam.getParamName(), "Context param name");
        NullArgumentException.validateNotNull(contextParam.getParamValue(), "Context param value");
        this.m_contextParams.add(contextParam);
    }

    public WebAppInitParam[] getContextParams() {
        return this.m_contextParams.toArray(new WebAppInitParam[this.m_contextParams.size()]);
    }

    public void addMimeMapping(WebAppMimeMapping mimeMapping) {
        NullArgumentException.validateNotNull(mimeMapping, "Mime mapping");
        NullArgumentException.validateNotNull(mimeMapping.getExtension(), "Mime mapping extension");
        NullArgumentException.validateNotNull(mimeMapping.getMimeType(), "Mime mapping type");
        this.m_mimeMappings.add(mimeMapping);
    }

    public void addConstraintMapping(WebAppConstraintMapping constraintMapping) {
        NullArgumentException.validateNotNull(constraintMapping, "constraint mapping");
        this.m_constraintsMapping.add(constraintMapping);
    }

    public WebAppConstraintMapping[] getConstraintMappings() {
        return this.m_constraintsMapping.toArray(new WebAppConstraintMapping[this.m_constraintsMapping.size()]);
    }

    public void addSecurityRole(WebAppSecurityRole securityRole) {
        NullArgumentException.validateNotNull(securityRole, "Security Role");
        this.m_securityRoles.add(securityRole);
    }

    public WebAppSecurityRole[] getSecurityRoles() {
        return this.m_securityRoles.toArray(new WebAppSecurityRole[this.m_securityRoles.size()]);
    }

    public void addLoginConfig(WebAppLoginConfig loginConfig) {
        NullArgumentException.validateNotNull(loginConfig, "Login Config");
        NullArgumentException.validateNotNull(loginConfig.getAuthMethod(), "Login Config Authorization Method");
        this.m_loginConfig.add(loginConfig);
    }

    public WebAppLoginConfig[] getLoginConfigs() {
        return this.m_loginConfig.toArray(new WebAppLoginConfig[this.m_loginConfig.size()]);
    }

    public WebAppMimeMapping[] getMimeMappings() {
        return this.m_mimeMappings.toArray(new WebAppMimeMapping[this.m_mimeMappings.size()]);
    }

    public HttpContext getHttpContext() {
        return this.m_httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.m_httpContext = httpContext;
    }

    public void accept(WebAppVisitor visitor) {
        visitor.visit(this);
        for (WebAppListener listener : this.m_listeners) {
            visitor.visit(listener);
        }
        if (!this.m_filters.isEmpty()) {
            ArrayList<WebAppFilter> remainingFilters = new ArrayList<WebAppFilter>(this.m_filters.values());
            for (String filterName : this.m_orderedFilters) {
                WebAppFilter filter = this.m_filters.get(filterName);
                visitor.visit(filter);
                remainingFilters.remove(filter);
            }
            for (WebAppFilter filter : remainingFilters) {
                visitor.visit(filter);
            }
        }
        if (!this.m_servlets.isEmpty()) {
            for (WebAppServlet servlet : this.getSortedWebAppServlet()) {
                visitor.visit(servlet);
            }
        }
        if (!this.m_constraintsMapping.isEmpty()) {
            for (WebAppConstraintMapping constraintMapping : this.m_constraintsMapping) {
                visitor.visit(constraintMapping);
            }
        }
        for (WebAppErrorPage errorPage : this.m_errorPages) {
            visitor.visit(errorPage);
        }
        visitor.end();
    }

    private Collection<WebAppServlet> getSortedWebAppServlet() {
        ArrayList<WebAppServlet> servlets = new ArrayList<WebAppServlet>(this.m_servlets.values());
        Collections.sort(servlets, WebAppServletComparator);
        return servlets;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("displayName=").append(this.m_displayName).append(",contextName=").append(this.m_contextName).append("}").toString();
    }

    public URL getWebXmlURL() {
        return this.m_webXmlURL;
    }

    public void setWebXmlURL(URL m_webXmlURL) {
        this.m_webXmlURL = m_webXmlURL;
    }

    public int getDeploymentState() {
        return this.m_deploymentState;
    }

    public void setDeploymentState(int deploymentState) {
        this.m_deploymentState = deploymentState;
    }
}

