/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisher;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.extender.Extension;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.parser.dom.DOMWebXmlParser;
import org.ops4j.pax.web.service.spi.WarManager;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebXmlObserver
implements WarManager {
    private static final Logger LOG = LoggerFactory.getLogger(WebXmlObserver.class);
    private final WebAppPublisher m_publisher;
    private final Map<Long, WebApp> webApps = new HashMap<Long, WebApp>();
    private final Map<String, List<WebApp>> contexts = new HashMap<String, List<WebApp>>();
    private final BundleContext bundleContext;
    private final WebEventDispatcher eventDispatcher;

    WebXmlObserver(WebAppPublisher publisher, WebEventDispatcher eventDispatcher, BundleContext bundleContext) {
        NullArgumentException.validateNotNull(publisher, "Web App Publisher");
        NullArgumentException.validateNotNull(eventDispatcher, "WebEvent Dispatcher");
        NullArgumentException.validateNotNull(bundleContext, "BundleContext");
        this.m_publisher = publisher;
        this.bundleContext = bundleContext;
        this.eventDispatcher = eventDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extension createExtension(final Bundle bundle) throws Exception {
        String path = this.extractRootPath(bundle);
        path = path.isEmpty() ? "WEB-INF" : path + "/WEB-INF";
        URL webXmlURL = bundle.getEntry(path + "/web.xml");
        if (webXmlURL == null) {
            return null;
        }
        InputStream is = null;
        String contextName = "unknown";
        try {
            contextName = this.extractContextName(bundle);
            is = webXmlURL.openStream();
            final WebApp webApp = new DOMWebXmlParser().parse(is);
            if (webApp != null) {
                LOG.debug("Parsed web app [" + webApp + "]");
                webApp.setWebXmlURL(webXmlURL);
                webApp.setBundle(bundle);
                webApp.setContextName(contextName);
                webApp.setRootPath(this.extractRootPath(bundle));
                webApp.setDeploymentState(4);
                Object object = this.webApps;
                synchronized (object) {
                    this.webApps.put(bundle.getBundleId(), webApp);
                }
                object = new Extension(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void start() {
                        Map map = WebXmlObserver.this.webApps;
                        synchronized (map) {
                            if (!WebXmlObserver.this.webApps.containsKey(bundle.getBundleId())) {
                                return;
                            }
                        }
                        WebXmlObserver.this.deploy(webApp);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void destroy() {
                        Map map = WebXmlObserver.this.webApps;
                        synchronized (map) {
                            WebXmlObserver.this.webApps.remove(bundle.getBundleId());
                        }
                        WebXmlObserver.this.undeploy(webApp);
                    }
                };
                return object;
            }
            Extension extension = null;
            return extension;
        }
        catch (Exception e) {
            this.webEvent(5, contextName, bundle, e);
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(WebApp webApp) {
        List<WebApp> queue;
        this.webEvent(1, webApp);
        List<WebApp> list = queue = this.getQueue(webApp);
        synchronized (list) {
            if (queue.isEmpty()) {
                queue.add(webApp);
                webApp.setDeploymentState(2);
                this.m_publisher.publish(webApp);
                this.webEvent(2, webApp);
            } else {
                queue.add(webApp);
                LinkedList<Long> duplicateIds = new LinkedList<Long>();
                for (WebApp duplicateWebApp : queue) {
                    duplicateIds.add(duplicateWebApp.getBundle().getBundleId());
                }
                webApp.setDeploymentState(6);
                this.webEvent(6, webApp, duplicateIds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(WebApp webApp) {
        List<WebApp> queue;
        List<WebApp> list = queue = this.getQueue(webApp);
        synchronized (list) {
            if (!queue.isEmpty() && queue.get(0) == webApp) {
                webApp.setDeploymentState(4);
                this.webEvent(3, webApp);
                this.m_publisher.unpublish(webApp);
                this.webEvent(4, webApp);
                queue.remove(0);
                LOG.debug("Check for a waiting webapp.");
                if (!queue.isEmpty()) {
                    LOG.debug("Found another bundle waiting for the context");
                    WebApp next = queue.get(0);
                    next.setDeploymentState(2);
                    this.webEvent(1, next);
                    this.m_publisher.publish(next);
                    this.webEvent(2, next);
                } else {
                    Map<String, List<WebApp>> map = this.contexts;
                    synchronized (map) {
                        this.contexts.remove(webApp.getContextName());
                    }
                }
            } else if (queue.remove(webApp)) {
                webApp.setDeploymentState(4);
                this.webEvent(4, webApp);
            } else {
                LOG.debug("Web application was not in the deployment queue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WebApp> getQueue(WebApp webApp) {
        Map<String, List<WebApp>> map = this.contexts;
        synchronized (map) {
            List<WebApp> queue = this.contexts.get(webApp.getContextName());
            if (queue == null) {
                queue = new LinkedList<WebApp>();
                this.contexts.put(webApp.getContextName(), queue);
            }
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(long bundleId, String contextName) {
        WebApp webApp;
        Map<Long, WebApp> map = this.webApps;
        synchronized (map) {
            webApp = this.webApps.get(bundleId);
        }
        if (webApp == null) {
            return 2;
        }
        if (webApp.getDeploymentState() != 4) {
            return 3;
        }
        if (contextName != null) {
            webApp.setContextName(contextName);
        }
        this.deploy(webApp);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stop(long bundleId) {
        WebApp webApp;
        Map<Long, WebApp> map = this.webApps;
        synchronized (map) {
            webApp = this.webApps.get(bundleId);
        }
        if (webApp == null) {
            return 2;
        }
        if (webApp.getDeploymentState() == 4) {
            return 4;
        }
        this.undeploy(webApp);
        return 0;
    }

    private void webEvent(int type, WebApp webApp) {
        this.webEvent(type, webApp.getContextName(), webApp.getBundle(), null);
    }

    private void webEvent(int type, WebApp webApp, Collection<Long> ids) {
        this.eventDispatcher.webEvent(new WebEvent(type, "/" + webApp.getContextName(), webApp.getBundle(), this.bundleContext.getBundle(), ids));
    }

    private void webEvent(int type, String contextName, Bundle webAppBundle, Throwable t) {
        this.eventDispatcher.webEvent(new WebEvent(type, "/" + contextName, webAppBundle, this.bundleContext.getBundle(), t));
    }

    private String extractRootPath(Bundle bundle) {
        String rootPath = WebXmlObserver.getHeader(bundle, "Webapp-Root");
        if (rootPath == null) {
            LOG.trace("No 'Webapp-Root' manifest attribute specified in bundle {}", (Object)bundle);
            rootPath = "";
        }
        rootPath = WebXmlObserver.stripPrefix(rootPath, "/");
        rootPath = WebXmlObserver.stripSuffix(rootPath, "/");
        rootPath = rootPath.trim();
        return rootPath;
    }

    private static String stripPrefix(String value, String prefix) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    private static <T> T opt(T value, T orElse) {
        if (value == null) {
            return orElse;
        }
        return value;
    }

    private static String stripSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    private static String getHeader(Bundle bundle, String ... keys) {
        Bundle[] bundles;
        Dictionary headers = bundle.getHeaders();
        for (String key : keys) {
            String value = (String)headers.get(key);
            if (value == null) continue;
            return value;
        }
        for (Bundle fragment : bundles = bundle.getBundleContext().getBundles()) {
            if (fragment.getState() != 4) continue;
            headers = fragment.getHeaders();
            for (String key : keys) {
                String value = (String)headers.get(key);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    private String extractContextName(Bundle bundle) {
        String contextName = WebXmlObserver.getHeader(bundle, "Web-ContextPath", "Webapp-Context");
        if (contextName == null) {
            LOG.debug("No 'Web-ContextPath' or 'Webapp-Context' manifest attribute specified");
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName == null) {
                contextName = String.valueOf(bundle.getBundleId());
                LOG.debug(String.format("Using bundle id [%s] as context name", contextName));
            } else {
                contextName = symbolicName;
                LOG.debug(String.format("Using bundle symbolic name [%s] as context name", contextName));
            }
        }
        if ((contextName = contextName.trim()).startsWith("/")) {
            contextName = contextName.substring(1);
        }
        return contextName;
    }
}

