/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisher;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.WebXmlObserver;
import org.ops4j.pax.web.extender.war.internal.extender.AbstractExtender;
import org.ops4j.pax.web.extender.war.internal.extender.Extension;
import org.ops4j.pax.web.service.spi.WarManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
extends AbstractExtender {
    private WebEventDispatcher webEventDispatcher;
    private WebXmlObserver webXmlObserver;
    private ServiceTracker eventServiceTracker;
    private ServiceTracker logServiceTracker;
    private WebAppPublisher publisher;
    private ServiceRegistration registration;

    @Override
    protected void doStart() throws Exception {
        this.publisher = new WebAppPublisher();
        this.webEventDispatcher = new WebEventDispatcher(this.getBundleContext());
        this.webXmlObserver = new WebXmlObserver(this.publisher, this.webEventDispatcher, this.getBundleContext());
        this.registration = this.getBundleContext().registerService(WarManager.class.getName(), (Object)this.webXmlObserver, new Hashtable());
        Filter filterEvent = this.getBundleContext().createFilter("(objectClass=org.osgi.service.event.EventAdmin)");
        this.eventServiceTracker = new ServiceTracker(this.getBundleContext(), filterEvent, (ServiceTrackerCustomizer)new EventServiceCustomizer());
        this.eventServiceTracker.open();
        Filter filterLog = this.getBundleContext().createFilter("(objectClass=org.osgi.service.log.LogService)");
        this.logServiceTracker = new ServiceTracker(this.getBundleContext(), filterLog, (ServiceTrackerCustomizer)new LogServiceCustomizer());
        this.logServiceTracker.open();
        this.startTracking();
    }

    @Override
    protected void doStop() throws Exception {
        this.registration.unregister();
        this.stopTracking();
        this.eventServiceTracker.close();
        this.logServiceTracker.close();
        this.webEventDispatcher.destroy();
    }

    @Override
    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        return this.webXmlObserver.createExtension(bundle);
    }

    @Override
    protected ScheduledExecutorService createExecutor() {
        return Executors.newScheduledThreadPool(3, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("WebPublisherExecutor: " + this.count.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
    }

    private class EventServiceCustomizer
    implements ServiceTrackerCustomizer {
        private EventServiceCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            Object eventService = Activator.this.getBundleContext().getService(reference);
            if (eventService instanceof EventAdmin) {
                Activator.this.webEventDispatcher.setEventAdminService(eventService);
            }
            return eventService;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            Activator.this.webEventDispatcher.setEventAdminService(null);
            Activator.this.getBundleContext().ungetService(reference);
        }
    }

    private class LogServiceCustomizer
    implements ServiceTrackerCustomizer {
        private LogServiceCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            Object logService = Activator.this.getBundleContext().getService(reference);
            if (logService instanceof LogService) {
                Activator.this.webEventDispatcher.setLogService(logService);
            }
            return logService;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            Activator.this.webEventDispatcher.setLogService(null);
            Activator.this.getBundleContext().ungetService(reference);
        }
    }
}

