/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.parser.dom;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.xml.parsers.ParserConfigurationException;
import org.ops4j.pax.web.extender.war.internal.WebXmlParser;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilterMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppMimeMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityConstraint;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityRole;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletContainerInitializer;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletMapping;
import org.ops4j.pax.web.extender.war.internal.parser.dom.WebFilterAnnotationScanner;
import org.ops4j.pax.web.extender.war.internal.parser.dom.WebServletAnnotationScanner;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.ops4j.util.xml.ElementHelper;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DOMWebXmlParser
implements WebXmlParser {
    private static final Logger LOG = LoggerFactory.getLogger(DOMWebXmlParser.class);

    @Override
    public WebApp parse(Bundle bundle, InputStream inputStream) {
        WebApp webApp;
        block42: {
            webApp = new WebApp();
            try {
                Element rootElement = ElementHelper.getRootElement(inputStream);
                if (rootElement != null) {
                    String version = ElementHelper.getAttribute(rootElement, "version");
                    Integer majorVersion = null;
                    if (version != null && !version.isEmpty() && version.length() > 2) {
                        LOG.debug("version found in web.xml - " + version);
                        try {
                            majorVersion = Integer.parseInt(version.split("\\.")[0]);
                        }
                        catch (NumberFormatException nfe) {}
                    } else if (version != null && !version.isEmpty() && version.length() > 0) {
                        try {
                            majorVersion = Integer.parseInt(version);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    Boolean metaDataComplete = Boolean.parseBoolean(ElementHelper.getAttribute(rootElement, "metadata-complete", "false"));
                    webApp.setMetaDataComplete(metaDataComplete);
                    LOG.debug("metadata-complete is: " + metaDataComplete);
                    webApp.setDisplayName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(rootElement, "display-name")));
                    DOMWebXmlParser.parseContextParams(rootElement, webApp);
                    DOMWebXmlParser.parseSessionConfig(rootElement, webApp);
                    DOMWebXmlParser.parseServlets(rootElement, webApp);
                    DOMWebXmlParser.parseFilters(rootElement, webApp);
                    DOMWebXmlParser.parseListeners(rootElement, webApp);
                    DOMWebXmlParser.parseErrorPages(rootElement, webApp);
                    DOMWebXmlParser.parseWelcomeFiles(rootElement, webApp);
                    DOMWebXmlParser.parseMimeMappings(rootElement, webApp);
                    DOMWebXmlParser.parseSecurity(rootElement, webApp);
                    LOG.debug("scanning for ServletContainerInitializers");
                    HashMap<ServletContainerInitializer, Class> serviceLoader = null;
                    Enumeration resources = bundle.getResources("/META-INF/services/javax.servlet.ServletContainerInitializer");
                    while (resources != null && resources.hasMoreElements()) {
                        if (serviceLoader == null) {
                            serviceLoader = new HashMap<ServletContainerInitializer, Class>();
                        }
                        URL url = (URL)resources.nextElement();
                        InputStream in = null;
                        BufferedReader r = null;
                        ArrayList<String> names = new ArrayList<String>();
                        in = url.openStream();
                        r = new BufferedReader(new InputStreamReader(in, "utf-8"));
                        int lc = 1;
                        while (lc >= 0) {
                            int n;
                            String ln = r.readLine();
                            if (ln == null) {
                                lc = -1;
                                continue;
                            }
                            int ci = ln.indexOf(35);
                            if (ci >= 0) {
                                ln = ln.substring(0, ci);
                            }
                            if ((n = (ln = ln.trim()).length()) != 0) {
                                if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                                    throw new ParserConfigurationException("Illegal configuration-file syntax");
                                }
                                int cp = ln.codePointAt(0);
                                if (!Character.isJavaIdentifierStart(cp)) {
                                    throw new ParserConfigurationException("Illegal provider-class name: " + ln);
                                }
                                for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                                    cp = ln.codePointAt(i);
                                    if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                                    throw new ParserConfigurationException("Illegal provider-class name: " + ln);
                                }
                                if (!names.contains(ln)) {
                                    names.add(ln);
                                }
                            }
                            ++lc;
                        }
                        for (String name : names) {
                            Class loadClass = bundle.loadClass(name);
                            serviceLoader.put((ServletContainerInitializer)loadClass.newInstance(), loadClass);
                        }
                    }
                    if (serviceLoader != null) {
                        LOG.debug("ServletContainerInitializers found");
                        for (Map.Entry service : serviceLoader.entrySet()) {
                            LOG.debug("ServletContainerInitializer: {}", (Object)((Class)service.getValue()).getName());
                            WebAppServletContainerInitializer webAppServletContainerInitializer = new WebAppServletContainerInitializer();
                            webAppServletContainerInitializer.setServletContainerInitializer((ServletContainerInitializer)service.getKey());
                            Class loadClass = bundle.loadClass("javax.servlet.annotation.HandlesTypes");
                            HandlesTypes handlesTypes = (HandlesTypes)loadClass.cast(((Class)service.getValue()).getAnnotation(loadClass));
                            LOG.debug("Found HandlesTypes {}", (Object)handlesTypes);
                            if (handlesTypes != null) {
                                Class[] classes = handlesTypes.value();
                                webAppServletContainerInitializer.setClasses(classes);
                            }
                            webApp.addServletContainerInitializer(webAppServletContainerInitializer);
                        }
                    }
                    if (!webApp.getMetaDataComplete().booleanValue() && majorVersion != null && majorVersion >= 3) {
                        LOG.debug("metadata-complete is either false or not set");
                        LOG.debug("scanning for annotated classes");
                        Enumeration clazzes = bundle.findEntries("/", "*.class", true);
                        while (clazzes.hasMoreElements()) {
                            Class clazz;
                            URL clazzUrl = (URL)clazzes.nextElement();
                            String clazzFile = clazzUrl.getFile();
                            LOG.debug("Class file found at :" + clazzFile);
                            if (clazzFile.startsWith("/WEB-INF/classes")) {
                                clazzFile = clazzFile.replaceFirst("/WEB-INF/classes", "");
                            } else if (clazzFile.startsWith("/WEB-INF/lib")) {
                                clazzFile = clazzFile.replaceFirst("/WEB-INF/lib", "");
                            }
                            String clazzName = clazzFile.replaceAll("/", ".").replaceAll(".class", "").replaceFirst(".", "");
                            try {
                                clazz = bundle.loadClass(clazzName);
                            }
                            catch (ClassNotFoundException e) {
                                LOG.debug("Class {} not found", (Object)clazzName);
                                continue;
                            }
                            if (clazz.isAnnotationPresent(WebServlet.class)) {
                                LOG.debug("found WebServlet annotation on class: " + clazz);
                                WebServletAnnotationScanner annonScanner = new WebServletAnnotationScanner(bundle, clazz.getCanonicalName());
                                annonScanner.scan(webApp);
                                continue;
                            }
                            if (clazz.isAnnotationPresent(WebFilter.class)) {
                                LOG.debug("found WebFilter annotation on class: " + clazz);
                                WebFilterAnnotationScanner filterScanner = new WebFilterAnnotationScanner(bundle, clazz.getCanonicalName());
                                filterScanner.scan(webApp);
                                continue;
                            }
                            if (!clazz.isAnnotationPresent(WebListener.class)) continue;
                            LOG.debug("found WebListener annotation on class: " + clazz);
                            DOMWebXmlParser.addWebListener(webApp, clazz.getSimpleName());
                        }
                        LOG.debug("class scanning done");
                    }
                    Set bundlesInClassSpace = ClassPathUtil.getBundlesInClassSpace((Bundle)bundle, new HashSet());
                    for (Bundle bundleInClassSpace : bundlesInClassSpace) {
                        Enumeration e = bundleInClassSpace.findEntries("/", "*.tld", true);
                        if (e == null) continue;
                        while (e.hasMoreElements()) {
                            URL u = (URL)e.nextElement();
                            Element rootTld = ElementHelper.getRootElement(u.openStream());
                            if (rootTld == null) continue;
                            DOMWebXmlParser.parseListeners(rootTld, webApp);
                        }
                    }
                    break block42;
                }
                LOG.warn("The parsed web.xml does not have a root element");
                return null;
            }
            catch (ParserConfigurationException ignore) {
                LOG.error("Cannot parse web.xml", (Throwable)ignore);
            }
            catch (IOException ignore) {
                LOG.error("Cannot parse web.xml", (Throwable)ignore);
            }
            catch (SAXException ignore) {
                LOG.error("Cannot parse web.xml", (Throwable)ignore);
            }
            catch (ClassNotFoundException ignore) {
                LOG.error("Cannot parse web.xml", (Throwable)ignore);
            }
            catch (SecurityException ignore) {
                LOG.error("Cannot parse web.xml", (Throwable)ignore);
            }
            catch (IllegalArgumentException ignore) {
                LOG.error("Cannot parse web.xml", (Throwable)ignore);
            }
            catch (IllegalAccessException ignore) {
                LOG.error("Cannot parse web.xml", (Throwable)ignore);
            }
            catch (InstantiationException ignore) {
                LOG.error("Cannot parse web.xml", (Throwable)ignore);
            }
        }
        return webApp;
    }

    private static void parseSecurity(Element rootElement, WebApp webApp) {
        Element[] loginConfigElements;
        Element[] securityRoleElements;
        String roleName;
        Element[] securityConstraint = ElementHelper.getChildren(rootElement, "security-constraint");
        if (securityConstraint != null && securityConstraint.length > 0) {
            try {
                for (Element scElement : securityConstraint) {
                    Element[] webResourceElements;
                    Element userDataConstraintsElement;
                    WebAppSecurityConstraint webSecurityConstraint = new WebAppSecurityConstraint();
                    Element authConstraintElement = ElementHelper.getChild(scElement, "auth-constraint");
                    if (authConstraintElement != null) {
                        webSecurityConstraint.setAuthenticate(true);
                        Element[] roleElemnts = ElementHelper.getChildren(authConstraintElement, "role-name");
                        if (roleElemnts != null && roleElemnts.length > 0) {
                            for (Element roleElement : roleElemnts) {
                                roleName = DOMWebXmlParser.getTextContent(roleElement);
                                webSecurityConstraint.addRole(roleName);
                            }
                        }
                    }
                    if ((userDataConstraintsElement = ElementHelper.getChild(scElement, "user-data-constraint")) != null) {
                        String guarantee = DOMWebXmlParser.getTextContent(ElementHelper.getChild(userDataConstraintsElement, "transport-guarantee")).trim().toUpperCase();
                        webSecurityConstraint.setDataConstraint(guarantee);
                    }
                    if ((webResourceElements = ElementHelper.getChildren(scElement, "web-resource-collection")) == null || webResourceElements.length <= 0) continue;
                    for (Element webResourceElement : webResourceElements) {
                        Element[] urlPatternElemnts;
                        WebAppConstraintMapping webConstraintMapping = new WebAppConstraintMapping();
                        WebAppSecurityConstraint sc = (WebAppSecurityConstraint)webSecurityConstraint.clone();
                        String constraintName = DOMWebXmlParser.getTextContent(ElementHelper.getChild(webResourceElement, "web-resource-name"));
                        webConstraintMapping.setConstraintName(constraintName);
                        for (Element urlPattern : urlPatternElemnts = ElementHelper.getChildren(webResourceElement, "url-pattern")) {
                            String url = DOMWebXmlParser.getTextContent(urlPattern);
                            Element[] httpMethodElements = ElementHelper.getChildren(urlPattern, "http-method");
                            if (httpMethodElements != null && httpMethodElements.length > 0) {
                                for (Element httpMethodElement : httpMethodElements) {
                                    webConstraintMapping.setMapping(DOMWebXmlParser.getTextContent(httpMethodElement));
                                    webConstraintMapping.setUrl(url);
                                    webConstraintMapping.setSecurityConstraints(sc);
                                }
                            } else {
                                webConstraintMapping.setUrl(url);
                                webConstraintMapping.setSecurityConstraints(sc);
                            }
                            webApp.addConstraintMapping(webConstraintMapping);
                        }
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                LOG.warn("", (Throwable)e);
            }
        }
        if ((securityRoleElements = ElementHelper.getChildren(rootElement, "security-role")) != null && securityRoleElements.length > 0) {
            for (Element securityRoleElement : securityRoleElements) {
                WebAppSecurityRole webSecurityRole = new WebAppSecurityRole();
                Element[] roleElements = ElementHelper.getChildren(securityRoleElement, "role-name");
                if (roleElements != null && roleElements.length > 0) {
                    for (Element roleElement : roleElements) {
                        roleName = DOMWebXmlParser.getTextContent(roleElement);
                        webSecurityRole.addRoleName(roleName);
                    }
                }
                webApp.addSecurityRole(webSecurityRole);
            }
        }
        if ((loginConfigElements = ElementHelper.getChildren(rootElement, "login-config")) != null && loginConfigElements.length > 0) {
            for (Element loginConfigElement : loginConfigElements) {
                WebAppLoginConfig webLoginConfig = new WebAppLoginConfig();
                webLoginConfig.setAuthMethod(DOMWebXmlParser.getTextContent(ElementHelper.getChild(loginConfigElement, "auth-method")));
                String realmName = DOMWebXmlParser.getTextContent(ElementHelper.getChild(loginConfigElement, "realm-name"));
                webLoginConfig.setRealmName(realmName == null ? "default" : realmName);
                if ("FORM".equalsIgnoreCase(webLoginConfig.getAuthMethod())) {
                    Element formLoginConfigElement = ElementHelper.getChild(loginConfigElement, "form-login-config");
                    webLoginConfig.setFormLoginPage(DOMWebXmlParser.getTextContent(ElementHelper.getChild(formLoginConfigElement, "form-login-page")));
                    webLoginConfig.setFormErrorPage(DOMWebXmlParser.getTextContent(ElementHelper.getChild(formLoginConfigElement, "form-error-page")));
                }
                webApp.addLoginConfig(webLoginConfig);
            }
        }
    }

    private static void parseContextParams(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "context-param");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppInitParam initParam = new WebAppInitParam();
                initParam.setParamName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "param-name")));
                initParam.setParamValue(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "param-value")));
                webApp.addContextParam(initParam);
            }
        }
    }

    private static void parseSessionConfig(Element rootElement, WebApp webApp) {
        Element stElement;
        Element scElement = ElementHelper.getChild(rootElement, "session-config");
        if (scElement != null && (stElement = ElementHelper.getChild(scElement, "session-timeout")) != null) {
            webApp.setSessionTimeout(DOMWebXmlParser.getTextContent(stElement));
        }
    }

    private static void parseServlets(Element rootElement, WebApp webApp) {
        Element[] mappingElements;
        Element[] elements = ElementHelper.getChildren(rootElement, "servlet");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppServlet servlet = new WebAppServlet();
                servlet.setServletName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "servlet-name")));
                String servletClass = DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "servlet-class"));
                if (servletClass != null) {
                    servlet.setServletClass(servletClass);
                    webApp.addServlet(servlet);
                } else {
                    String jspFile = DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "jsp-file"));
                    if (jspFile != null) {
                        WebAppJspServlet jspServlet = new WebAppJspServlet();
                        jspServlet.setServletName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "servlet-name")));
                        jspServlet.setJspPath(jspFile);
                        webApp.addServlet(jspServlet);
                    }
                }
                servlet.setLoadOnStartup(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "load-on-startup")));
                servlet.setAsyncSupported(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "async-supported")));
                Element[] initParamElements = ElementHelper.getChildren(element, "init-param");
                if (initParamElements == null || initParamElements.length <= 0) continue;
                for (Element initParamElement : initParamElements) {
                    WebAppInitParam initParam = new WebAppInitParam();
                    initParam.setParamName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(initParamElement, "param-name")));
                    initParam.setParamValue(DOMWebXmlParser.getTextContent(ElementHelper.getChild(initParamElement, "param-value")));
                    servlet.addInitParam(initParam);
                }
            }
        }
        if ((mappingElements = ElementHelper.getChildren(rootElement, "servlet-mapping")) != null && mappingElements.length > 0) {
            for (Element mappingElement : mappingElements) {
                String servletName = DOMWebXmlParser.getTextContent(ElementHelper.getChild(mappingElement, "servlet-name"));
                Element[] urlPatternsElements = ElementHelper.getChildren(mappingElement, "url-pattern");
                if (urlPatternsElements == null || urlPatternsElements.length <= 0) continue;
                for (Element urlPatternElement : urlPatternsElements) {
                    WebAppServletMapping servletMapping = new WebAppServletMapping();
                    servletMapping.setServletName(servletName);
                    servletMapping.setUrlPattern(DOMWebXmlParser.getTextContent(urlPatternElement));
                    webApp.addServletMapping(servletMapping);
                }
            }
        }
    }

    private static void parseFilters(Element rootElement, WebApp webApp) {
        Element[] mappingElements;
        Element[] elements = ElementHelper.getChildren(rootElement, "filter");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppFilter filter = new WebAppFilter();
                filter.setFilterName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "filter-name")));
                filter.setFilterClass(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "filter-class")));
                webApp.addFilter(filter);
                Element[] initParamElements = ElementHelper.getChildren(element, "init-param");
                if (initParamElements == null || initParamElements.length <= 0) continue;
                for (Element initParamElement : initParamElements) {
                    WebAppInitParam initParam = new WebAppInitParam();
                    initParam.setParamName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(initParamElement, "param-name")));
                    initParam.setParamValue(DOMWebXmlParser.getTextContent(ElementHelper.getChild(initParamElement, "param-value")));
                    filter.addInitParam(initParam);
                }
            }
        }
        if ((mappingElements = ElementHelper.getChildren(rootElement, "filter-mapping")) != null && mappingElements.length > 0) {
            for (Element mappingElement : mappingElements) {
                Element[] servletNamesElements;
                String filterName = DOMWebXmlParser.getTextContent(ElementHelper.getChild(mappingElement, "filter-name"));
                Element[] urlPatternsElements = ElementHelper.getChildren(mappingElement, "url-pattern");
                if (urlPatternsElements != null && urlPatternsElements.length > 0) {
                    for (Element urlPatternElement : urlPatternsElements) {
                        WebAppFilterMapping filterMapping = new WebAppFilterMapping();
                        filterMapping.setFilterName(filterName);
                        filterMapping.setUrlPattern(DOMWebXmlParser.getTextContent(urlPatternElement));
                        webApp.addFilterMapping(filterMapping);
                    }
                }
                if ((servletNamesElements = ElementHelper.getChildren(mappingElement, "servlet-name")) == null || servletNamesElements.length <= 0) continue;
                for (Element servletNameElement : servletNamesElements) {
                    WebAppFilterMapping filterMapping = new WebAppFilterMapping();
                    filterMapping.setFilterName(filterName);
                    filterMapping.setServletName(DOMWebXmlParser.getTextContent(servletNameElement));
                    webApp.addFilterMapping(filterMapping);
                }
            }
        }
    }

    private static void parseListeners(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "listener");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                DOMWebXmlParser.addWebListener(webApp, DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "listener-class")));
            }
        }
    }

    private static void parseErrorPages(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "error-page");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppErrorPage errorPage = new WebAppErrorPage();
                errorPage.setErrorCode(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "error-code")));
                errorPage.setExceptionType(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "exception-type")));
                errorPage.setLocation(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "location")));
                webApp.addErrorPage(errorPage);
            }
        }
    }

    private static void parseWelcomeFiles(Element rootElement, WebApp webApp) {
        Element[] elements;
        Element listElement = ElementHelper.getChild(rootElement, "welcome-file-list");
        if (listElement != null && (elements = ElementHelper.getChildren(listElement, "welcome-file")) != null && elements.length > 0) {
            for (Element element : elements) {
                webApp.addWelcomeFile(DOMWebXmlParser.getTextContent(element));
            }
        }
    }

    private static void parseMimeMappings(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "mime-mapping");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppMimeMapping mimeMapping = new WebAppMimeMapping();
                mimeMapping.setExtension(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "extension")));
                mimeMapping.setMimeType(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "mime-type")));
                webApp.addMimeMapping(mimeMapping);
            }
        }
    }

    private static String getTextContent(Element element) {
        if (element != null) {
            String content = element.getTextContent();
            if (content != null) {
                content = content.trim();
            }
            return content;
        }
        return null;
    }

    private static void addWebListener(WebApp webApp, String clazz) {
        WebAppListener listener = new WebAppListener();
        listener.setListenerClass(clazz);
        webApp.addListener(listener);
    }
}

