/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.parser.dom;

import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilterMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.parser.dom.AnnotationScanner;
import org.osgi.framework.Bundle;

public class WebFilterAnnotationScanner
extends AnnotationScanner<WebFilterAnnotationScanner> {
    public WebFilterAnnotationScanner(Bundle bundle, String className) {
        super(bundle, className);
    }

    /*
     * WARNING - void declaration
     */
    public void scan(WebApp webApp) {
        Class clazz = this.loadClass();
        if (clazz == null) {
            this.LOG.warn("Class %s wasn't loaded", (Object)this.className);
            return;
        }
        if (!Filter.class.isAssignableFrom(clazz)) {
            this.LOG.warn(clazz.getName() + " is not assignable from javax.servlet.Filter");
            return;
        }
        WebFilter filterAnnotation = clazz.getAnnotation(WebFilter.class);
        if (filterAnnotation.value().length > 0 && filterAnnotation.urlPatterns().length > 0) {
            this.LOG.warn(clazz.getName() + " defines both @WebFilter.value and @WebFilter.urlPatterns");
            return;
        }
        String name = filterAnnotation.filterName().equals("") ? clazz.getName() : filterAnnotation.filterName();
        String[] urlPatterns = filterAnnotation.value();
        WebAppFilter filter = webApp.findFilter(name);
        if (filter == null) {
            void var10_23;
            WebAppFilterMapping mapping;
            filter = new WebAppFilter();
            filter.setFilterName(name);
            filter.setFilterClass(this.className);
            for (WebInitParam webInitParam : filterAnnotation.initParams()) {
                WebAppInitParam initParam = new WebAppInitParam();
                initParam.setParamName(webInitParam.name());
                initParam.setParamValue(webInitParam.value());
                filter.addInitParam(initParam);
            }
            for (String string : urlPatterns) {
                mapping = new WebAppFilterMapping();
                mapping.setFilterName(name);
                mapping.setUrlPattern(string);
                webApp.addFilterMapping(mapping);
            }
            for (String string : filterAnnotation.servletNames()) {
                mapping = new WebAppFilterMapping();
                mapping.setFilterName(name);
                mapping.setServletName(string);
                webApp.addFilterMapping(mapping);
            }
            EnumSet<DispatcherType> enumSet = EnumSet.noneOf(DispatcherType.class);
            DispatcherType[] arr$ = filterAnnotation.dispatcherTypes();
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_23 < len$) {
                DispatcherType d = arr$[var10_23];
                enumSet.add(d);
                ++var10_23;
            }
            WebAppFilterMapping mapping2 = new WebAppFilterMapping();
            mapping2.setDispatcherTypes(enumSet);
            webApp.addFilterMapping(mapping2);
        } else {
            void var10_25;
            WebAppInitParam[] webAppInitParamArray = filter.getInitParams();
            WebInitParam[] arr$ = filterAnnotation.initParams();
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_25 < len$) {
                WebInitParam ip = arr$[var10_25];
                if (!this.initParamsContain(webAppInitParamArray, name)) {
                    WebAppInitParam initParam = new WebAppInitParam();
                    initParam.setParamName(ip.name());
                    initParam.setParamValue(ip.value());
                    filter.addInitParam(initParam);
                }
                ++var10_25;
            }
            List<WebAppFilterMapping> filterMappings = webApp.getFilterMappings(name);
            boolean mappingExists = false;
            for (WebAppFilterMapping m : filterMappings) {
                if (!m.getFilterName().equalsIgnoreCase(name)) continue;
                mappingExists = true;
                break;
            }
            if (!mappingExists) {
                WebAppFilterMapping mapping;
                for (String urlPattern : urlPatterns) {
                    mapping = new WebAppFilterMapping();
                    mapping.setFilterName(name);
                    mapping.setUrlPattern(urlPattern);
                    webApp.addFilterMapping(mapping);
                }
                for (String servletName : filterAnnotation.servletNames()) {
                    mapping = new WebAppFilterMapping();
                    mapping.setFilterName(name);
                    mapping.setServletName(servletName);
                    webApp.addFilterMapping(mapping);
                }
                EnumSet<DispatcherType> enumSet = EnumSet.noneOf(DispatcherType.class);
                for (DispatcherType d : filterAnnotation.dispatcherTypes()) {
                    enumSet.add(d);
                }
                WebAppFilterMapping mapping3 = new WebAppFilterMapping();
                mapping3.setDispatcherTypes(enumSet);
                webApp.addFilterMapping(mapping3);
            }
        }
    }
}

