/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Hashtable;
import org.ops4j.pax.web.extender.war.internal.DefaultWebAppDependencyManager;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisher;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.WebObserver;
import org.ops4j.pax.web.extender.war.internal.extender.AbstractExtender;
import org.ops4j.pax.web.extender.war.internal.extender.Extension;
import org.ops4j.pax.web.extender.war.internal.parser.WebAppParser;
import org.ops4j.pax.web.service.spi.WarManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
extends AbstractExtender
implements ServiceTrackerCustomizer<HttpService, ServiceReference<HttpService>> {
    private ServiceTracker<EventAdmin, EventAdmin> eventServiceTracker;
    private ServiceTracker<LogService, LogService> logServiceTracker;
    private ServiceTracker<PackageAdmin, PackageAdmin> packageAdminTracker;
    private ServiceTracker<HttpService, ServiceReference<HttpService>> httpServiceTracker;
    private WebObserver webObserver;
    private WebEventDispatcher webEventDispatcher;
    private ServiceRegistration<WarManager> registration;

    @Override
    protected void doStart() throws Exception {
        this.logger.debug("Pax Web WAR Extender - Starting");
        BundleContext bundleContext = this.getBundleContext();
        this.webEventDispatcher = new WebEventDispatcher(bundleContext);
        Filter filterEvent = bundleContext.createFilter("(objectClass=org.osgi.service.event.EventAdmin)");
        this.eventServiceTracker = new ServiceTracker(bundleContext, filterEvent, (ServiceTrackerCustomizer)new EventServiceCustomizer());
        this.eventServiceTracker.open();
        Filter filterLog = bundleContext.createFilter("(objectClass=org.osgi.service.log.LogService)");
        this.logServiceTracker = new ServiceTracker(bundleContext, filterLog, (ServiceTrackerCustomizer)new LogServiceCustomizer());
        this.logServiceTracker.open();
        Filter filterPackage = bundleContext.createFilter("(objectClass=org.osgi.service.packageadmin.PackageAdmin)");
        this.packageAdminTracker = new ServiceTracker(bundleContext, filterPackage, null);
        this.packageAdminTracker.open();
        DefaultWebAppDependencyManager dependencyManager = new DefaultWebAppDependencyManager();
        this.webObserver = new WebObserver(new WebAppParser(this.packageAdminTracker), new WebAppPublisher(this.webEventDispatcher, bundleContext), this.webEventDispatcher, dependencyManager, bundleContext);
        this.httpServiceTracker = new ServiceTracker(bundleContext, HttpService.class, (ServiceTrackerCustomizer)this);
        this.httpServiceTracker.open();
        this.logger.debug("Pax Web WAR Extender - Started");
    }

    @Override
    protected void doStop() throws Exception {
        this.logger.debug("Pax Web WAR Extender - Stopping");
        this.httpServiceTracker.close();
        this.eventServiceTracker.close();
        this.logServiceTracker.close();
        this.packageAdminTracker.close();
        this.webEventDispatcher.destroy();
        this.logger.debug("Pax Web WAR Extender - Stopped");
    }

    protected void startExtender() {
        this.startTracking();
        this.registration = this.getBundleContext().registerService(WarManager.class, (Object)this.webObserver, new Hashtable());
    }

    protected void stopExtender() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.stopTracking();
    }

    public ServiceReference<HttpService> addingService(ServiceReference<HttpService> reference) {
        if (this.httpServiceTracker.getServiceReference() == null) {
            this.startExtender();
        }
        return reference;
    }

    public void modifiedService(ServiceReference<HttpService> reference, ServiceReference<HttpService> service) {
    }

    public void removedService(ServiceReference<HttpService> reference, ServiceReference<HttpService> service) {
        this.stopExtender();
        if (this.httpServiceTracker.getServiceReference() != null) {
            this.startExtender();
        }
    }

    @Override
    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        return this.webObserver.createExtension(bundle);
    }

    private class EventServiceCustomizer
    implements ServiceTrackerCustomizer<EventAdmin, EventAdmin> {
        private EventServiceCustomizer() {
        }

        public EventAdmin addingService(ServiceReference<EventAdmin> reference) {
            EventAdmin eventService = (EventAdmin)Activator.this.getBundleContext().getService(reference);
            Activator.this.webEventDispatcher.setEventAdminService(eventService);
            return eventService;
        }

        public void modifiedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
        }

        public void removedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
            Activator.this.webEventDispatcher.setEventAdminService(null);
            Activator.this.getBundleContext().ungetService(reference);
        }
    }

    private class LogServiceCustomizer
    implements ServiceTrackerCustomizer<LogService, LogService> {
        private LogServiceCustomizer() {
        }

        public LogService addingService(ServiceReference<LogService> reference) {
            LogService logService = (LogService)Activator.this.getBundleContext().getService(reference);
            Activator.this.webEventDispatcher.setLogService(logService);
            return logService;
        }

        public void modifiedService(ServiceReference<LogService> reference, LogService service) {
        }

        public void removedService(ServiceReference<LogService> reference, LogService service) {
            Activator.this.webEventDispatcher.setLogService(null);
            Activator.this.getBundleContext().ungetService(reference);
        }
    }
}

