/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.extender.war.internal.RegisterWebAppVisitorHS;
import org.ops4j.pax.web.extender.war.internal.RegisterWebAppVisitorWC;
import org.ops4j.pax.web.extender.war.internal.UnregisterWebAppVisitorHS;
import org.ops4j.pax.web.extender.war.internal.UnregisterWebAppVisitorWC;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebAppDependencyHolder;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.ServletContextManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebAppPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppPublisher.class);
    private final Map<WebApp, ServiceTracker<WebAppDependencyHolder, WebAppDependencyHolder>> webApps = Collections.synchronizedMap(new HashMap());
    private final WebEventDispatcher eventDispatcher;
    private final BundleContext bundleContext;

    WebAppPublisher(WebEventDispatcher eventDispatcher, BundleContext bundleContext) {
        this.eventDispatcher = eventDispatcher;
        this.bundleContext = bundleContext;
    }

    public void publish(WebApp webApp) {
        NullArgumentException.validateNotNull(webApp, "Web app");
        LOG.debug("Publishing web application [{}]", (Object)webApp);
        BundleContext webAppBundleContext = BundleUtils.getBundleContext(webApp.getBundle());
        if (webAppBundleContext != null) {
            try {
                Filter filter = webAppBundleContext.createFilter(String.format("(&(objectClass=%s)(bundle.id=%d))", WebAppDependencyHolder.class.getName(), webApp.getBundle().getBundleId()));
                ServiceTracker dependencyTracker = new ServiceTracker(webAppBundleContext, filter, (ServiceTrackerCustomizer)new WebAppDependencyListener(webApp, this.eventDispatcher, this.bundleContext));
                this.webApps.put(webApp, (ServiceTracker<WebAppDependencyHolder, WebAppDependencyHolder>)dependencyTracker);
                dependencyTracker.open();
            }
            catch (InvalidSyntaxException exc) {
                throw new IllegalArgumentException(exc);
            }
        } else {
            LOG.warn("Bundle context could not be discovered for bundle [" + webApp.getBundle() + "]" + "Skipping publishing of web application [" + webApp + "]");
        }
    }

    public void unpublish(WebApp webApp) {
        NullArgumentException.validateNotNull(webApp, "Web app");
        LOG.debug("Unpublishing web application [{}]", (Object)webApp);
        ServiceTracker<WebAppDependencyHolder, WebAppDependencyHolder> tracker = this.webApps.remove(webApp);
        if (tracker != null) {
            tracker.close();
        }
    }

    public static class WebAppDependencyListener
    implements ServiceTrackerCustomizer<WebAppDependencyHolder, WebAppDependencyHolder> {
        private final WebApp webApp;
        private final WebEventDispatcher eventDispatcher;
        private BundleContext bundleContext;
        private HttpService httpService;
        private WebAppDependencyHolder dependencyHolder;

        WebAppDependencyListener(WebApp webApp, WebEventDispatcher eventDispatcher, BundleContext bundleContext) {
            NullArgumentException.validateNotNull(webApp, "Web app");
            this.webApp = webApp;
            this.eventDispatcher = eventDispatcher;
            this.bundleContext = bundleContext;
        }

        public synchronized void modifiedService(ServiceReference<WebAppDependencyHolder> reference, WebAppDependencyHolder service) {
            LOG.debug("modified Service for service reference {}", reference);
            this.unregister();
            this.dependencyHolder = service;
            this.httpService = this.dependencyHolder.getHttpService();
            this.register();
        }

        private void register() {
            if (this.httpService != null) {
                LOG.debug("Registering web application [{}] from http service [{}]", (Object)this.webApp, (Object)this.httpService);
                try {
                    if (WebContainerUtils.webContainerAvailable(this.httpService)) {
                        this.webApp.accept(new RegisterWebAppVisitorWC(this.dependencyHolder));
                    } else {
                        this.webApp.accept(new RegisterWebAppVisitorHS(this.httpService));
                    }
                    ServletContextManager.startContext((String)("/" + this.webApp.getContextName()));
                    this.webApp.setDeploymentState(2);
                    this.eventDispatcher.webEvent(this.webApp, 2, this.httpService);
                }
                catch (Exception e) {
                    LOG.error("Error deploying web application", (Throwable)e);
                    this.eventDispatcher.webEvent(this.webApp, 5, e);
                }
            }
        }

        private void unregister() {
            if (this.httpService != null) {
                try {
                    LOG.debug("Unregistering web application [{}] from http service [{}]", (Object)this.webApp, (Object)this.httpService);
                    if (WebContainerUtils.webContainerAvailable(this.httpService)) {
                        this.webApp.accept(new UnregisterWebAppVisitorWC((WebContainer)this.httpService));
                    } else {
                        this.webApp.accept(new UnregisterWebAppVisitorHS(this.httpService));
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error undeploying web application", (Throwable)e);
                }
            }
        }

        public WebAppDependencyHolder addingService(ServiceReference<WebAppDependencyHolder> reference) {
            WebAppDependencyHolder service;
            LOG.debug("Adding service for service reference {}", reference);
            this.dependencyHolder = service = (WebAppDependencyHolder)this.bundleContext.getService(reference);
            this.httpService = service.getHttpService();
            this.register();
            return service;
        }

        public void removedService(ServiceReference<WebAppDependencyHolder> reference, WebAppDependencyHolder service) {
            this.unregister();
        }
    }
}

