/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.EventListener;
import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletContainerInitializer;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnregisterWebAppVisitorWC
implements WebAppVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(UnregisterWebAppVisitorWC.class);
    private final WebContainer webContainer;
    private HttpContext httpContext;

    UnregisterWebAppVisitorWC(WebContainer webContainer) {
        NullArgumentException.validateNotNull(webContainer, "Web Container");
        this.webContainer = webContainer;
    }

    @Override
    public void visit(WebApp webApp) {
        this.httpContext = webApp.getHttpContext();
        this.webContainer.begin(this.httpContext);
        try {
            this.webContainer.unregister("/");
        }
        catch (IllegalArgumentException badarg) {
        }
        catch (Exception ignore) {
            LOG.warn("Unregistration exception. Skipping.", (Throwable)ignore);
        }
        try {
            this.webContainer.unregisterWelcomeFiles(webApp.getWelcomeFiles(), this.httpContext);
        }
        catch (IllegalArgumentException badarg) {
        }
        catch (Exception ignore) {
            LOG.warn("Unregistration exception. Skipping.", (Throwable)ignore);
        }
        try {
            this.webContainer.unregisterJsps(this.httpContext);
        }
        catch (IllegalArgumentException badarg) {
        }
        catch (UnsupportedOperationException ignore) {
        }
        catch (Exception ignore) {
            LOG.warn("Unregistration exception. Skipping.", (Throwable)ignore);
        }
    }

    @Override
    public void visit(WebAppServlet webAppServlet) {
        NullArgumentException.validateNotNull(webAppServlet, "Web app servlet");
        Class<? extends Servlet> servletClass = webAppServlet.getServletClass();
        if (servletClass != null) {
            try {
                this.webContainer.unregisterServlets(servletClass);
                webAppServlet.setServletClass(null);
            }
            catch (Exception ignore) {
                LOG.warn("Unregistration exception. Skipping.", (Throwable)ignore);
            }
        }
    }

    @Override
    public void visit(WebAppFilter webAppFilter) {
        NullArgumentException.validateNotNull(webAppFilter, "Web app filter");
        WebAppInitParam[] initParams = webAppFilter.getInitParams();
        String filterName = null;
        for (WebAppInitParam webAppInitParam : initParams) {
            if (!"filter-name".equalsIgnoreCase(webAppInitParam.getParamName())) continue;
            filterName = webAppInitParam.getParamValue();
            break;
        }
        if (filterName != null) {
            try {
                this.webContainer.unregisterFilter(filterName);
            }
            catch (Exception ignore) {
                LOG.warn("Unregistration exception. Skipping.", (Throwable)ignore);
            }
        }
    }

    @Override
    public void visit(WebAppListener webAppListener) {
        NullArgumentException.validateNotNull(webAppListener, "Web app listener");
        EventListener listener = webAppListener.getListener();
        if (listener != null) {
            try {
                this.webContainer.unregisterEventListener(listener);
            }
            catch (Exception ignore) {
                LOG.warn("Unregistration exception. Skipping.", (Throwable)ignore);
            }
        }
    }

    @Override
    public void visit(WebAppErrorPage webAppErrorPage) {
        NullArgumentException.validateNotNull(webAppErrorPage, "Web app error page");
        try {
            this.webContainer.unregisterErrorPage(webAppErrorPage.getError(), this.httpContext);
        }
        catch (Exception ignore) {
            LOG.warn("Unregistration exception. Skipping.", (Throwable)ignore);
        }
    }

    @Override
    public void visit(WebAppLoginConfig loginConfig) {
        NullArgumentException.validateNotNull(loginConfig, "Web app login config");
        this.webContainer.unregisterLoginConfig(this.httpContext);
    }

    @Override
    public void visit(WebAppConstraintMapping constraintMapping) {
        NullArgumentException.validateNotNull(constraintMapping, "Web app constraint mapping");
        this.webContainer.unregisterConstraintMapping(this.httpContext);
    }

    public void visit(WebAppServletContainerInitializer servletContainerInitializer) {
        NullArgumentException.validateNotNull(servletContainerInitializer, "Servlet Container Initializer");
        this.webContainer.unregisterServletContainerInitializer(this.httpContext);
    }

    @Override
    public void end() {
    }
}

