/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.List;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ErrorPageMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.FilterMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.FilterTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.HttpContextMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.HttpContextTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.JspMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ListenerMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ListenerTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ResourceMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ServletMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ServletTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.WelcomeFileMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private ExtenderContext m_extenderContext;
    private List<ServiceTracker> m_trackers;

    public void start(BundleContext bundleContext) throws Exception {
        this.m_extenderContext = new ExtenderContext();
        this.m_extenderContext.open(bundleContext);
        this.m_trackers = new ArrayList<ServiceTracker>();
        this.trackHttpContexts(bundleContext);
        this.trackServlets(bundleContext);
        this.trackResources(bundleContext);
        if (WebContainerUtils.WEB_CONATAINER_AVAILABLE) {
            this.trackFilters(bundleContext);
            this.trackListeners(bundleContext);
            this.trackJspMappings(bundleContext);
            this.trackErrorPages(bundleContext);
            this.trackWelcomeFiles(bundleContext);
        } else {
            LOG.warn("Filters tracking has been disabled as the WebContainer (Pax Web) is not available");
            LOG.warn("Event Listeners tracking has been disabled as the WebContainer (Pax Web) is not available");
            LOG.warn("JSP mappings tracking has been disabled as the WebContainer (Pax Web) is not available");
        }
        LOG.debug("Pax Web Extender started");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        for (ServiceTracker tracker : this.m_trackers) {
            tracker.close();
        }
        this.m_trackers = null;
        this.m_extenderContext.close(bundleContext);
        LOG.debug("Pax Web Extender stopped");
    }

    private void trackHttpContexts(BundleContext bundleContext) {
        HttpContextTracker httpContextTracker = new HttpContextTracker(this.m_extenderContext, bundleContext);
        httpContextTracker.open();
        this.m_trackers.add(0, httpContextTracker);
        HttpContextMappingTracker httpContextMappingTracker = new HttpContextMappingTracker(this.m_extenderContext, bundleContext);
        httpContextMappingTracker.open();
        this.m_trackers.add(0, httpContextMappingTracker);
    }

    private void trackServlets(BundleContext bundleContext) {
        ServletTracker servletTracker = new ServletTracker(this.m_extenderContext, bundleContext);
        servletTracker.open();
        this.m_trackers.add(0, servletTracker);
        ServletMappingTracker servletMappingTracker = new ServletMappingTracker(this.m_extenderContext, bundleContext);
        servletMappingTracker.open();
        this.m_trackers.add(0, servletMappingTracker);
    }

    private void trackResources(BundleContext bundleContext) {
        ResourceMappingTracker resourceMappingTracker = new ResourceMappingTracker(this.m_extenderContext, bundleContext);
        resourceMappingTracker.open();
        this.m_trackers.add(0, resourceMappingTracker);
    }

    private void trackFilters(BundleContext bundleContext) {
        FilterTracker filterTracker = new FilterTracker(this.m_extenderContext, bundleContext);
        filterTracker.open();
        this.m_trackers.add(0, filterTracker);
        FilterMappingTracker filterMappingTracker = new FilterMappingTracker(this.m_extenderContext, bundleContext);
        filterMappingTracker.open();
        this.m_trackers.add(0, filterMappingTracker);
    }

    private void trackListeners(BundleContext bundleContext) {
        ListenerTracker listenerTracker = new ListenerTracker(this.m_extenderContext, bundleContext);
        listenerTracker.open();
        this.m_trackers.add(0, listenerTracker);
        ListenerMappingTracker listenerMappingTracker = new ListenerMappingTracker(this.m_extenderContext, bundleContext);
        listenerMappingTracker.open();
        this.m_trackers.add(0, listenerMappingTracker);
    }

    private void trackJspMappings(BundleContext bundleContext) {
        JspMappingTracker jspMappingTracker = new JspMappingTracker(this.m_extenderContext, bundleContext);
        jspMappingTracker.open();
        this.m_trackers.add(0, jspMappingTracker);
    }

    private void trackWelcomeFiles(BundleContext bundleContext) {
        WelcomeFileMappingTracker welcomeFileTracker = new WelcomeFileMappingTracker(this.m_extenderContext, bundleContext);
        welcomeFileTracker.open();
        this.m_trackers.add(0, welcomeFileTracker);
    }

    private void trackErrorPages(BundleContext bundleContext) {
        ErrorPageMappingTracker errorPagesTracker = new ErrorPageMappingTracker(this.m_extenderContext, bundleContext);
        errorPagesTracker.open();
        this.m_trackers.add(0, errorPagesTracker);
    }
}

