/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.WebApplication;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultHttpContextMapping;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ExtenderContext
implements BundleListener {
    private final ConcurrentHashMap<Bundle, HttpServiceTracker> m_httpServiceTrackers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ContextKey, WebApplication> m_webApplications = new ConcurrentHashMap();

    public WebApplication getWebApplication(Bundle bundle, String httpContextId) {
        if (bundle == null) {
            return null;
        }
        ContextKey contextKey = new ContextKey(bundle, httpContextId);
        WebApplication webApplication = this.m_webApplications.get(contextKey);
        if (webApplication == null) {
            webApplication = new WebApplication();
            this.m_webApplications.putIfAbsent(contextKey, webApplication);
            HttpServiceTracker httpServiceTracker = this.getHttpServiceTrackers().get(bundle);
            if (httpServiceTracker == null) {
                httpServiceTracker = new HttpServiceTracker(BundleUtils.getBundleContext(bundle));
                httpServiceTracker.open();
                this.getHttpServiceTrackers().putIfAbsent(bundle, httpServiceTracker);
            }
            httpServiceTracker.addListener(webApplication);
            if (httpContextId == null) {
                webApplication.setHttpContextMapping(new DefaultHttpContextMapping());
            }
        }
        return webApplication;
    }

    public void removeWebApplications(ContextKey contextKey) {
        HttpServiceTracker httpServiceTracker;
        WebApplication webApplication = this.m_webApplications.remove(contextKey);
        if (webApplication != null && (httpServiceTracker = this.getHttpServiceTrackers().get(contextKey.bundle)) != null) {
            httpServiceTracker.removeListener(webApplication);
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 4: {
                this.bundleStopped(event.getBundle());
            }
        }
    }

    private void bundleStopped(Bundle bundle) {
        HttpServiceTracker httpServiceTracker = this.getHttpServiceTrackers().remove(bundle);
        if (httpServiceTracker != null) {
            // empty if block
        }
        for (ContextKey contextKey : this.getContextKeys(bundle)) {
            this.removeWebApplications(contextKey);
        }
    }

    private Collection<ContextKey> getContextKeys(Bundle bundle) {
        ArrayList<ContextKey> keys = new ArrayList<ContextKey>();
        for (ContextKey contextKey : this.m_webApplications.keySet()) {
            if (!contextKey.bundle.equals(bundle)) continue;
            keys.add(contextKey);
        }
        return keys;
    }

    public void open(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void close(BundleContext bundleContext) {
        bundleContext.removeBundleListener((BundleListener)this);
        this.closeServiceTracker();
    }

    void closeServiceTracker() {
        for (Map.Entry<Bundle, HttpServiceTracker> entry : this.getHttpServiceTrackers().entrySet()) {
            entry.getValue().close();
        }
        this.getHttpServiceTrackers().clear();
    }

    ConcurrentHashMap<Bundle, HttpServiceTracker> getHttpServiceTrackers() {
        return this.m_httpServiceTrackers;
    }

    private static class ContextKey {
        Bundle bundle;
        String httpContextId;

        private ContextKey(Bundle bundle, String httpContextId) {
            this.bundle = bundle;
            this.httpContextId = httpContextId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextKey that = (ContextKey)o;
            if (this.bundle != null ? !this.bundle.equals(that.bundle) : that.bundle != null) {
                return false;
            }
            return !(this.httpContextId != null ? !this.httpContextId.equals(that.httpContextId) : that.httpContextId != null);
        }

        public int hashCode() {
            int result = this.bundle != null ? this.bundle.hashCode() : 0;
            result = 31 * result + (this.httpContextId != null ? this.httpContextId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("bundle=").append(this.bundle).append(",httpContextId=").append(this.httpContextId).append("}").toString();
        }
    }
}

