/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.ErrorPageMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class ErrorPageWebElement
implements WebElement {
    private final ErrorPageMapping m_errorPageMapping;

    public ErrorPageWebElement(ErrorPageMapping errorPageMapping) {
        NullArgumentException.validateNotNull(errorPageMapping, "error page errorPageMapping");
        this.m_errorPageMapping = errorPageMapping;
    }

    @Override
    public void register(HttpService httpService, HttpContext httpContext) throws Exception {
        if (!WebContainerUtils.isWebContainer(httpService)) {
            throw new UnsupportedOperationException("Internal error: In use HttpService is not an WebContainer (from Pax Web)");
        }
        ((WebContainer)httpService).registerErrorPage(this.m_errorPageMapping.getError(), this.m_errorPageMapping.getLocation(), httpContext);
    }

    @Override
    public void unregister(HttpService httpService, HttpContext httpContext) {
        if (WebContainerUtils.isWebContainer(httpService)) {
            ((WebContainer)httpService).unregisterErrorPage(this.m_errorPageMapping.getError(), httpContext);
        }
    }

    @Override
    public String getHttpContextId() {
        return this.m_errorPageMapping.getHttpContextId();
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("mapping=").append(this.m_errorPageMapping).append("}").toString();
    }
}

