/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.JspMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class JspWebElement
implements WebElement {
    private JspMapping m_jspMapping;

    public JspWebElement(JspMapping jspMapping) {
        NullArgumentException.validateNotNull(jspMapping, "JSP mapping");
        this.m_jspMapping = jspMapping;
    }

    @Override
    public void register(HttpService httpService, HttpContext httpContext) throws Exception {
        if (!WebContainerUtils.isWebContainer(httpService)) {
            throw new UnsupportedOperationException("Internal error: In use HttpService is not an WebContainer (from Pax Web)");
        }
        ((WebContainer)httpService).registerJsps(this.m_jspMapping.getUrlPatterns(), DictionaryUtils.adapt(this.m_jspMapping.getInitParams()), httpContext);
    }

    @Override
    public void unregister(HttpService httpService, HttpContext httpContext) {
        if (!WebContainerUtils.isWebContainer(httpService)) {
            throw new UnsupportedOperationException("Internal error: In use HttpService is not an WebContainer (from Pax Web)");
        }
        ((WebContainer)httpService).unregisterJsps(this.m_jspMapping.getUrlPatterns(), httpContext);
    }

    @Override
    public String getHttpContextId() {
        return this.m_jspMapping.getHttpContextId();
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("mapping=").append(this.m_jspMapping).append("}").toString();
    }
}

